/**
 * Copyright (c) 2009 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * $id.java
 * -------------------------------------------------------------------------
 */
package com.ebmwebsourcing.wsstar.notification.definition.topics;

import javax.xml.namespace.QName;

/**
 * Constants of WS Topics
 * 
 * @author tdejean - eBM WebSourcing
 */
public class WstopConstants {
	
	
	public static final String WS_TOPICS_NAMESPACE_URI = "http://docs.oasis-open.org/wsn/t-1";

    public static final String WS_TOPICS_PREFIX = "wstop";
	
	public static final QName TOPIC_QNAME = new QName(WS_TOPICS_NAMESPACE_URI, "Topic",
            WS_TOPICS_PREFIX);

	public static final QName TOPICNAMESPACE_QNAME = new QName(WS_TOPICS_NAMESPACE_URI, "TopicNamespace",
            WS_TOPICS_PREFIX);
	
	public static final QName TOPICSET_QNAME = new QName(WS_TOPICS_NAMESPACE_URI, "TopicSet",
            WS_TOPICS_PREFIX);
	
	public static final String SIMPLE_TOPIC_EXPRESSION_DIALECT_URI = WS_TOPICS_NAMESPACE_URI  + "/TopicExpression/Simple";
	
	public static final String CONCRETE_TOPIC_EXPRESSION_DIALECT_URI = WS_TOPICS_NAMESPACE_URI + "/TopicExpression/Concrete";

	public static final String FULL_TOPIC_EXPRESSION_DIALECT_URI = WS_TOPICS_NAMESPACE_URI + "/TopicExpression/Full";
	
	public static final String XPATH_TOPIC_EXPRESSION_DIALECT_URI = "http://www.w3.org/TR/1999/REC-xpath-19991116";

	public static final char SEPARATOR_CHILD_OF = '/';
	
	public static final String SEPARATOR_SUB_TREE_OF = "//";
	 	
	public static final char STAR_WILDCARD = '*';
	
	public static final char POINT_WILDCARD = '.'; 
	
	
	/*
	public static final String EBM_RESOURCEIDS_PREFIX = "ebm";
	
	public static final String EBM_RESOURCEIDS_NAMESPACE_URI = "http://petals.ow2.org/ebmwebsourcing/specific/ResourceIds";
	
	private static final String EBM_TOPICS_EXTENSION_NAMESPACE_URI = "http://org.ow2.petals/ebmwebsourcing/specific/topicExtension";
	
	public static final QName RESOURCE_IDS_QNAME = new QName(EBM_RESOURCEIDS_NAMESPACE_URI, "ResourceIds",EBM_RESOURCEIDS_PREFIX);
	
	public static final QName REGISTRATION_ID_QNAME = new QName(EBM_RESOURCEIDS_NAMESPACE_URI, "RegistrationId",EBM_RESOURCEIDS_PREFIX);

	public static final QName SUBSCRIPTION_ID_QNAME = new QName(EBM_RESOURCEIDS_NAMESPACE_URI, "SubscriptionId",EBM_RESOURCEIDS_PREFIX);
	
	public static final QName SUPPORTED_QNAME_ATTR = new QName(EBM_TOPICS_EXTENSION_NAMESPACE_URI, "supported", EBM_RESOURCEIDS_PREFIX);
	*/
	
	/*  
	public static final String DIALECT = "dialect";
	
    public static final String NAMESPACE_URI = "http://docs.oasis-open.org/wsn/t-1";

    public static final String PREFIX = "wst";

    public static final String CONCRETE_TOPIC_URI = NAMESPACE_URI
            + "/TopicExpression/Concrete";

    public static final String DIALECT = "dialect";

    public static final String FINAL = "final";

    public static final String FULL_TOPIC_URI = NAMESPACE_URI
            + "/TopicExpression/Full";
  
    public static final String MESSAGE_TYPES = "messageTypes";
    
    public static final QName PATTERN_QNAME = new QName(NAMESPACE_URI,
            "MessagePattern", PREFIX);
    
    public static final String SIMPLE_TOPIC_URI = NAMESPACE_URI
            + "/TopicExpression/Simple";

    public static final QName TOPIC_NAMESPACE_QNAME = new QName(NAMESPACE_URI,
            "TopicNamespace", PREFIX);

    public static final QName TOPIC_QNAME = new QName(NAMESPACE_URI, "Topic",
            PREFIX);

    public static final QName TOPIC_SET_QNAME = new QName(NAMESPACE_URI,
            "TopicSet", PREFIX);	
	 */
	 
}
