/**
 * Copyright (c) 2009 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * $Id$
 * -------------------------------------------------------------------------
 */
package com.ebmwebsourcing.wsstar.notification.extension;

import com.ebmwebsourcing.wsstar.notification.extension.api.ContextPolicyType;
import com.ebmwebsourcing.wsstar.notification.extension.api.SOAParameterType;
import com.ebmwebsourcing.wsstar.notification.extension.api.ProcessPolicyType;
import com.ebmwebsourcing.wsstar.notification.extension.api.ResourcesUuidType;
import com.ebmwebsourcing.wsstar.notification.extension.api.TerminationTimeType;
import com.ebmwebsourcing.wsstar.notification.extension.api.XsltStyleSheetType;
import com.ebmwebsourcing.wsstar.notification.extension.inout.WSNotificationExtensionReader;
import com.ebmwebsourcing.wsstar.notification.extension.inout.WSNotificationExtensionWriter;
import com.ebmwebsourcing.wsstar.notification.extension.utils.WSNotificationExtensionException;
import com.ebmwebsourcing.wsstar.notification.jaxbextension.types.ObjectFactory;
/**
 * This abstract class defines a factory API that enables applications
 * to obtain a Factory capable of producing new Definitions, new Reader,
 * and new Writer.
 * 
 * Note : This class is implemented respect to the "Singleton design pattern".
 *    The solution of Bill Pugh - University of Maryland - has been used, because
 *    it supposed to be "thread-safe" without requiring special language constructs
 *    (i.e. volatile or synchronized). For more details, see :
 *    
 *     http://en.wikipedia.org/wiki/Singleton_pattern
 * 
 * @author Thierry Déjean - eBM WebSourcing
 */
public abstract class WSNotificationExtensionFactory {

	protected ObjectFactory specificExtendedTypesFactory;
	 
	//Protected constructor is sufficient to suppress unauthorized calls to the constructor
	protected WSNotificationExtensionFactory (){
		this.specificExtendedTypesFactory = new ObjectFactory(); 
	}
	
	/**
	 * SingletonHolder is loaded on the first execution of Singleton.getInstance() 
	 * or the first access to SingletonHolder.INSTANCE, not before.
	 */
	private static class WSNotificationExtensionFactoryHolder { 
		private final static WSNotificationExtensionFactory INSTANCE = new WSNotificationExtensionFactoryImpl();
	}

	/**
	 * Return an unique - respect to the Singleton design pattern - instance  
	 * of the {@link WSNotificationExtensionFactory} class. Getting this object type is the first step to build
	 * all others "WS-Notification Extended types objects" and Reader/Writer objects.  
	 * 
	 * @return a unique WSNotificationFactory instance. 
	 */
	public static WSNotificationExtensionFactory getInstance() {
		return WSNotificationExtensionFactoryHolder.INSTANCE;
	}
	
	/**
	 * Create a {@link WSNotificationExtensionReader} object
	 * 
	 * @return a {@link WSNotificationExtensionReader} instance
	 * @throws WSNotificationExtensionException
	 */
	//public abstract WSNotificationExtensionReader createWSNotificationExtensionReader() throws WSNotificationExtensionException;
	
	/**
	 * Create a {@link WSNotificationExtensionWriter} object
	 * 
	 * @return a {@link WSNotificationExtensionWriter} instance
	 * @throws WSNotificationExtensionException
	 */
	//public abstract WSNotificationExtensionWriter createWSNotificationExtensionWriter()throws WSNotificationExtensionException;
	
	/**
	 * Create an instance of the {@link SOAParameterType} class
	 * 
	 * @return a new {@link SOAParameterType} object
	 * @throws WSNotificationExtensionException
	 */
	public abstract SOAParameterType createSOAParameterType() throws WSNotificationExtensionException;
	
	/**
	 * Create an instance of the {@link ResourcesUuidType} class
	 * 
	 * @return a new {@link ResourcesUuidType} object
	 * @throws WSNotificationExtensionException
	 */
	public abstract ResourcesUuidType createResourcesUuidType() throws WSNotificationExtensionException;
	
	/**
	 * Create an instance of the {@link ProcessPolicyType} class
	 * 
	 * @return a new {@link ProcessPolicyType} object
	 * @throws WSNotificationExtensionException
	 */
	public abstract ProcessPolicyType createProcessPolicyType() throws WSNotificationExtensionException;
	
	/**
	 * Create an instance of the {@link ContextPolicyType} class
	 * 
	 * @return a new {@link ContextPolicyType} object
	 * @throws WSNotificationExtensionException
	 */
	public abstract ContextPolicyType createContextPolicyType() throws WSNotificationExtensionException;
	
	/**
	 * Create an instance of the {@link XsltStyleSheetType} class
	 * 
	 * @return a new {@link XsltStyleSheetType} object
	 * @throws WSNotificationExtensionException
	 */
	public abstract XsltStyleSheetType createXsltStyleSheetType() throws WSNotificationExtensionException;
	
	/**
	 * Create an instance of the {@link TerminationTimeType} class
	 * 
	 * @return a new {@link TerminationTimeType} object class
	 * @throws WSNotificationExtensionException
	 */
	public abstract TerminationTimeType createTerminationTimeType() throws WSNotificationExtensionException;
}
