/**
 * Copyright (c) 2009 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * $Id$
 * -------------------------------------------------------------------------
 */
package com.ebmwebsourcing.wsstar.notification.extension;

import com.ebmwebsourcing.wsstar.notification.extension.api.ContextPolicyType;
import com.ebmwebsourcing.wsstar.notification.extension.api.SOAParameterType;
import com.ebmwebsourcing.wsstar.notification.extension.api.ProcessPolicyType;
import com.ebmwebsourcing.wsstar.notification.extension.api.ResourcesUuidType;
import com.ebmwebsourcing.wsstar.notification.extension.api.TerminationTimeType;
//import com.ebmwebsourcing.wsstar.notification.extension.api.XpathExpressionsType;
import com.ebmwebsourcing.wsstar.notification.extension.api.XsltStyleSheetType;
import com.ebmwebsourcing.wsstar.notification.extension.impl.ContextPolicyTypeImpl;
import com.ebmwebsourcing.wsstar.notification.extension.impl.ProcessPolicyTypeImpl;
import com.ebmwebsourcing.wsstar.notification.extension.impl.ResourcesUuidTypeImpl;
import com.ebmwebsourcing.wsstar.notification.extension.impl.SOAParameterTypeImpl;
import com.ebmwebsourcing.wsstar.notification.extension.impl.TerminationTimeTypeImpl;
import com.ebmwebsourcing.wsstar.notification.extension.impl.XsltStyleSheetTypeImpl;
import com.ebmwebsourcing.wsstar.notification.extension.utils.WSNotificationExtensionException;
import com.ebmwebsourcing.wsstar.notification.extension.utils.WSNotificationExtensionJAXBContext;

/**
 * This class is a concrete implementation of the abstract class WSNotificationFactory.
 * Some ideas used here have been shamelessly copied from the wonderful JAXP and
 * Xerces work.
 * 
 * @author Thierry Déjean -eBM WebSourcing
 */
public class WSNotificationExtensionFactoryImpl extends	WSNotificationExtensionFactory {

	/**
	 * Default Constructor
	 */
	public WSNotificationExtensionFactoryImpl() {		
	}

	/*
	 * (non-Javadoc)
	 * @see com.ebmwebsourcing.wsstar.notification.extension.WSNotificationExtensionFactory#createWSNotificationExtensionReader()
	 */
	/*@Override
	public WSNotificationExtensionReader createWSNotificationExtensionReader() throws WSNotificationExtensionException {	
		return new WSNotificationExtensionReaderImpl();
	}*/
	
	/*
	 * (non-Javadoc)
	 * @see com.ebmwebsourcing.wsstar.notification.extension.WSNotificationExtensionFactory#createWSNotificationExtensionWriter()
	 */
	/*@Override
	public WSNotificationExtensionWriter createWSNotificationExtensionWriter() throws WSNotificationExtensionException {
		return new WSNotificationExtensionWriterImpl();
	}*/
	
	/*
	 * (non-Javadoc)
	 * @see com.ebmwebsourcing.wsstar.notification.extension.WSNotificationExtensionFactory#createSOAParameterType()
	 */
	@Override
	public SOAParameterType createSOAParameterType() throws WSNotificationExtensionException {	
		return new SOAParameterTypeImpl(WSNotificationExtensionJAXBContext.wsnebmFactory.createSOAParameterType(),null);
	}

	/*
	 * (non-Javadoc)
	 * @see com.ebmwebsourcing.wsstar.notification.extension.WSNotificationExtensionFactory#createResourcesUuidType()
	 */
	@Override
	public ResourcesUuidType createResourcesUuidType() throws WSNotificationExtensionException {
		return new ResourcesUuidTypeImpl(WSNotificationExtensionJAXBContext.wsnebmFactory.createResourcesUuidType(),null);
	}
	
	/*
	 * (non-Javadoc)
	 * @see com.ebmwebsourcing.wsstar.notification.extension.WSNotificationExtensionFactory#createProcessPolicyType()
	 */
	@Override
	public ProcessPolicyType createProcessPolicyType() throws WSNotificationExtensionException {		
		return new ProcessPolicyTypeImpl(WSNotificationExtensionJAXBContext.wsnebmFactory.createProcessPolicyType(),null);
	}
		
	/*
	 * (non-Javadoc)
	 * @see com.ebmwebsourcing.wsstar.notification.extension.WSNotificationExtensionFactory#createContextPolicyType()
	 */
	@Override
	public ContextPolicyType createContextPolicyType() throws WSNotificationExtensionException {		
		return new ContextPolicyTypeImpl(WSNotificationExtensionJAXBContext.wsnebmFactory.createContextPolicyType(),null);
	}
	
	/*
	 * (non-Javadoc)
	 * @see com.ebmwebsourcing.wsstar.notification.extension.WSNotificationExtensionFactory#createXsltStyleSheetType()
	 */
	@Override
	public XsltStyleSheetType createXsltStyleSheetType() throws WSNotificationExtensionException {
		return new XsltStyleSheetTypeImpl(WSNotificationExtensionJAXBContext.wsnebmFactory.createXsltStyleSheetType(),null);
	}
	
	/*
	 * (non-Javadoc)
	 * @see com.ebmwebsourcing.wsstar.notification.extension.WSNotificationExtensionFactory#createTerminationtimeType()
	 */
	@Override
	public TerminationTimeType createTerminationTimeType() throws WSNotificationExtensionException {
		return new TerminationTimeTypeImpl(WSNotificationExtensionJAXBContext.wsnebmFactory.createTerminationTimeType(),null);
	}
}
