/**
 * Copyright (c) 2009 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * $Id$
 * -------------------------------------------------------------------------
 */
package com.ebmwebsourcing.wsstar.notification.extension.impl;

import org.ow2.easywsdl.schema.api.abstractElmt.AbstractSchemaElementImpl;

import com.ebmwebsourcing.wsstar.notification.extension.api.ContextPolicyType;

/**
 * This class implements {@link ContextPolicyType} java interface respect to
 * EASYWSDL Library model.
 * 
 * @author Thierry Déjean - eBM Websourcing
 */
public class ContextPolicyTypeImpl extends AbstractSchemaElementImpl<com.ebmwebsourcing.wsstar.jaxb.notification.extension.types.ContextPolicyType> implements
		ContextPolicyType {

	private static final long serialVersionUID = 1L;

	/**
	 * Constructor (follow EASYWSDL model)
	 * @param model
	 * @param parent
	 */
	public ContextPolicyTypeImpl(com.ebmwebsourcing.wsstar.jaxb.notification.extension.types.ContextPolicyType model,
			AbstractSchemaElementImpl<?> parent) {
		super(model,parent);
	}
	
	/*
	 * (non-Javadoc)
	 * @see com.ebmwebsourcing.wsstar.notification.extension.api.ContextPolicyType#isCorrelationId()
	 */
	public Boolean isCorrelationId() {		
		return this.model.isCorrelationId();
	}

	/*
	 * (non-Javadoc)
	 * @see com.ebmwebsourcing.wsstar.notification.extension.api.ContextPolicyType#isEndpoint()
	 */
	public Boolean isEndpoint() {
		return this.model.isEndpoint(); 
	}

	/*
	 * (non-Javadoc)
	 * @see com.ebmwebsourcing.wsstar.notification.extension.api.ContextPolicyType#isInterface()
	 */
	public Boolean isInterface() {
		return this.model.isInterface();
	}

	/*
	 * (non-Javadoc)
	 * @see com.ebmwebsourcing.wsstar.notification.extension.api.ContextPolicyType#isMeuuid()
	 */
	public Boolean isMeuuid() {
		return this.model.isMeuuid();
	}

	/*
	 * (non-Javadoc)
	 * @see com.ebmwebsourcing.wsstar.notification.extension.api.ContextPolicyType#isNotifDate()
	 */
	public Boolean isNotifDate() {
		return this.model.isNotifDate();
	}

	/*
	 * (non-Javadoc)
	 * @see com.ebmwebsourcing.wsstar.notification.extension.api.ContextPolicyType#isService()
	 */
	public Boolean isService() {
		return this.model.isService();
	}

	/*
	 * (non-Javadoc)
	 * @see com.ebmwebsourcing.wsstar.notification.extension.api.ContextPolicyType#isStatus()
	 */
	public Boolean isStatus() {
		return this.model.isStatus();
	}

	/*
	 * (non-Javadoc)
	 * @see com.ebmwebsourcing.wsstar.notification.extension.api.ContextPolicyType#setCorrelationId(java.lang.Boolean)
	 */
	public void setCorrelationId(Boolean val) {
		this.model.setCorrelationId(val);
	}

	/*
	 * (non-Javadoc)
	 * @see com.ebmwebsourcing.wsstar.notification.extension.api.ContextPolicyType#setEndpoint(java.lang.Boolean)
	 */
	public void setEndpoint(Boolean val) {
		this.model.setEndpoint(val);
	}

	/*
	 * (non-Javadoc)
	 * @see com.ebmwebsourcing.wsstar.notification.extension.api.ContextPolicyType#setInterface(java.lang.Boolean)
	 */
	public void setInterface(Boolean val) {
		this.model.setInterface(val);
	}

	/*
	 * (non-Javadoc)
	 * @see com.ebmwebsourcing.wsstar.notification.extension.api.ContextPolicyType#setMeuuid(java.lang.Boolean)
	 */
	public void setMeuuid(Boolean val) {
		this.model.setMeuuid(val);
	}

	/*
	 * (non-Javadoc)
	 * @see com.ebmwebsourcing.wsstar.notification.extension.api.ContextPolicyType#setNotifDate(java.lang.Boolean)
	 */
	public void setNotifDate(Boolean val) {
		this.model.setNotifDate(val);
	}

	/*
	 * (non-Javadoc)
	 * @see com.ebmwebsourcing.wsstar.notification.extension.api.ContextPolicyType#setService(java.lang.Boolean)
	 */
	public void setService(Boolean val) {
		this.model.setService(val);
	}

	/*
	 * (non-Javadoc)
	 * @see com.ebmwebsourcing.wsstar.notification.extension.api.ContextPolicyType#setStatus(java.lang.Boolean)
	 */
	public void setStatus(Boolean val) {
		this.model.setStatus(val);
	}	

}
