/**
 * Copyright (c) 2009 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * $Id$
 * -------------------------------------------------------------------------
 */
package com.ebmwebsourcing.wsstar.notification.extension.utils;
import org.ow2.easywsdl.schema.api.SchemaException;

/**
 * Typed WSNotification "Extended types" Exception
 * 
 * @author Thierry Déjean - eBM WebSourcing
 */
public class WSNotificationExtensionException extends SchemaException {
   
	public static final long serialVersionUID = 1;

	/**
	 * Constructor. See {@link SchemaException} description for more details
	 *  
	 * @param faultCode exception code (see {@link SchemaException})
	 * @param msg a short significant text description
	 * @param t a wrapped "standard" exception
	 */
    public WSNotificationExtensionException(final String faultCode, final String msg, final Throwable t) {
        super(msg, t);
        this.setFaultCode(faultCode);
    }

    /**
     * Constructor. See {@link SchemaException} description for more details
     * 
     * @param msg a short significant text description
     * @param t a wrapped "standard" exception
     */
    public WSNotificationExtensionException(final String msg, final Throwable t) {
        super(msg, t);
    }

   /**
    * Constructor. See {@link SchemaException} description for more details
    * 
    * @param t a wrapped "standard" exception
    */
    public WSNotificationExtensionException(final Throwable t) {
        super(t);
    }

    /**
     * Constructor. See {@link SchemaException} description for more details
     * 
     * @param msg a wrapped "standard" exception
     */
    public WSNotificationExtensionException(final String msg) {
        super(msg);
    }

   /**
    * Constructor. See {@link SchemaException} description for more details
    * 
    * @param faultCode exception code (see {@link SchemaException})
	* @param msg a short significant text description
	*/
    public WSNotificationExtensionException(final String faultCode, final String msg) {
        this(faultCode, msg, null);
    }

 
}
