/**
 * Copyright (c) 2009 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * $Id$
 * -------------------------------------------------------------------------
 */
package com.ebmwebsourcing.wsstar.notification.service.basenotification.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

import javax.xml.namespace.QName;

import com.ebmwebsourcing.wsstar.addressing.definition.WSAddressingFactory;
import com.ebmwebsourcing.wsstar.addressing.definition.api.EndpointReferenceType;
import com.ebmwebsourcing.wsstar.addressing.definition.api.ReferenceParametersType;
import com.ebmwebsourcing.wsstar.addressing.definition.api.WSAddressingException;
import com.ebmwebsourcing.wsstar.notification.definition.WSNotificationFactory;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.FilterType;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.Renew;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.RenewResponse;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.Subscribe;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.SubscriptionManagerRP;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.SubscriptionPolicyType;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.TopicExpressionType;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.Unsubscribe;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.UnsubscribeResponse;
import com.ebmwebsourcing.wsstar.notification.definition.utils.WSNotificationException;
import com.ebmwebsourcing.wsstar.notification.extension.WSNotificationExtensionFactory;
import com.ebmwebsourcing.wsstar.notification.extension.api.ResourcesUuidType;
import com.ebmwebsourcing.wsstar.notification.extension.api.SOAParameterType;
import com.ebmwebsourcing.wsstar.notification.extension.utils.WSNotificationExtensionException;
import com.ebmwebsourcing.wsstar.notification.extension.utils.WsnSpecificTypeHelper;
import com.ebmwebsourcing.wsstar.notification.service.basenotification.WsnbSubscriptionManager;
import com.ebmwebsourcing.wsstar.notification.service.fault.ResourceNotDestroyedFault;
import com.ebmwebsourcing.wsstar.notification.service.fault.ResourceUnknownFault;
import com.ebmwebsourcing.wsstar.notification.service.fault.WSNotificationFault;
import com.ebmwebsourcing.wsstar.notification.service.fault.WsnFaultMessageConstants;
import com.ebmwebsourcing.wsstar.notification.service.topic.WstopTopicManager;
import com.ebmwebsourcing.wsstar.notification.service.util.WSNotificationNotImplementedException;

public class SubscriptionManagerMgr implements WsnbSubscriptionManager {
	
	protected Logger logger;
	protected Map<String, SubscriptionManagerRP> subscriptions;
	protected WstopTopicManager topicsMgr;
		
	protected String subscriptionsManagerEdp = "http://www.ebmwebsourcing.com/subscriptionManager/default";
	protected QName subscriptionsManagerService = new QName("http://www.ebmwebsourcing.com/default","SubscriptionManagerService");
	protected QName subscriptionsManagerInterface = new QName("http://www.ebmwebsourcing.com/default","SubscriptionManager");	
	
	public SubscriptionManagerMgr(Logger logger, WstopTopicManager topicsMgr) {
		super();
		this.logger = logger;
		this.subscriptions = Collections.synchronizedMap(new HashMap<String, SubscriptionManagerRP>());
		this.topicsMgr = topicsMgr;		
	}
	
	
	// ##################################################
	//  		----- {Getter,Setter} methods ------
	// ##################################################
	
	/**
	 * 
	 * @return
	 */
	public String getSubscriptionsManagerEdp() {
		return subscriptionsManagerEdp;
	}
	
	public void setSubscriptionsManagerEdp(String subscriptionsMgrEdp) {
		this.subscriptionsManagerEdp = subscriptionsMgrEdp;
	}
	
	public QName getSubscriptionsManagerService() {
		return subscriptionsManagerService;
	}
	
	public void setSubscriptionsManagerService(QName subscriptionsMgrService) {
		this.subscriptionsManagerService = subscriptionsMgrService;
	}
	
	public QName getSubscriptionsManagerInterface() {
		return subscriptionsManagerInterface;
	}
	
	public void setSubscriptionsManagerInterface(QName subscriptionsMgrInterface) {
		this.subscriptionsManagerInterface = subscriptionsMgrInterface;
	}
	
	public List<String> getStoredSubscriptionIds(){
		return new ArrayList<String>(this.subscriptions.keySet());
	}
	
	
	// #####################################################################################
	// 	----- Methods' implementation of WS-Notification SubscriptionManager Interface ----
	// #####################################################################################
	
	/*
	 * (non-Javadoc)
	 * @see com.ebmwebsourcing.wsstar.notification.service.basenotification.WsnbSubscriptionManager#unsubscribe(com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.Unsubscribe)
	 */
	public UnsubscribeResponse unsubscribe(Unsubscribe request)
			throws WSNotificationException, WSNotificationFault, WSNotificationExtensionException {
		logger.log(Level.FINE, "performs a \"Unsubscribe\" request ...");
		//TODO : implement this method !!!
		logger.log(Level.FINE, "\"Unsubscribe\"  method implementation in progress ... " );
		UnsubscribeResponse response = null;
		
		// ---- perform a registration destruction ---
		/*EndpointReferenceType edpKeyVal;
		try {
			edpKeyVal = this.getExistingKey(request.getSubscriptionReference());
		} catch (WSAddressingException e) {
			throw new WSNotificationException(e);
		}
		
		if (edpKeyVal != null) {
			subscriptions.remove(edpKeyVal);
			if (subscriptions.containsKey(edpKeyVal))
				throw new ResourceNotDestroyedFault(WsnFaultMessageConstants.FAULT_DESCRIPTION_LANGUAGE,
						WsnFaultMessageConstants.WsnbUnsubcribeFaultDescriptions.UNABLE_TO_DESTROY_SUBSCRIPTION_FAULT_DESC);			
		} else 
			throw new ResourceUnknownFault(WsnFaultMessageConstants.FAULT_DESCRIPTION_LANGUAGE,
					WsnFaultMessageConstants.WsnbUnsubcribeFaultDescriptions.RESOURCE_UNKNOWN_FAULT_DESC);
		 */
		/*try {*/
						
			//List<String> resourcesId = request.getSubscriptionReference().getReferenceParameters().getResourcesUuidType().getUuids();
			ResourcesUuidType uuids = WsnSpecificTypeHelper.getResourcesUuidType(request);
			if (uuids != null){
				List<String> resourcesId = uuids.getUuids();
				if (resourcesId != null){
					for (String rId : resourcesId) {										
						if  (subscriptions.containsKey(rId)){
							subscriptions.remove(rId);
							if (subscriptions.containsKey(rId))
								throw new ResourceNotDestroyedFault(WsnFaultMessageConstants.FAULT_DESCRIPTION_LANGUAGE,
										WsnFaultMessageConstants.WsnbUnsubcribeFaultDescriptions.UNABLE_TO_DESTROY_SUBSCRIPTION_FAULT_DESC);
							else							
								this.topicsMgr.removeExistingSubscription(rId);						
						} else 
							throw new ResourceUnknownFault(WsnFaultMessageConstants.FAULT_DESCRIPTION_LANGUAGE,
									WsnFaultMessageConstants.WsnbUnsubcribeFaultDescriptions.RESOURCE_UNKNOWN_FAULT_DESC);
					}
				}
			}
		/*} catch (WSAddressingException e) {
			throw new WSNotificationException(e);
		}*/
				
		// ---- temporary code :
		response = WSNotificationFactory.getInstance().createUnsubscribeResponse();
		return response;
	}
	
	public RenewResponse renew(Renew request) throws WSNotificationException,
			WSNotificationFault {	
		logger.log(Level.FINE, "performs a \"Renew\" request ...");
		//TODO : implement this method !!!
		throw new WSNotificationNotImplementedException(this.getClass().getName(),"Renew");
	}
	
	// ###############################################
	// 			---- Others methods ----
	// ###############################################
	 	
	
	EndpointReferenceType createAndStoreSubscriptionResource(String subscriptionId,Subscribe payload) 
		throws WSNotificationException, WSAddressingException, WSNotificationExtensionException{
		EndpointReferenceType subsRef = null;
		
		SubscriptionManagerRP subscription = null;
		// ------- Generate UUID as endpoint reference for Subscription :
		subsRef = WSAddressingFactory.getInstance().newEndpointReferenceType();
		
		// use @http of consumerReferenceRequest //EndpointParameterType.DEFAULT_PETALS_ADDRESS
		subsRef.setAddress(payload.getConsumerReference().getAddress());		

		ReferenceParametersType ref = subsRef.newReferenceParameters();
		subsRef.setReferenceParameters(ref);
		
		SOAParameterType soaParam = WSNotificationExtensionFactory.getInstance().createSOAParameterType();
		                                    
		soaParam.setService(this.subscriptionsManagerService);
		soaParam.setInterface(this.subscriptionsManagerInterface);
		soaParam.setEndpoint(this.subscriptionsManagerEdp);
		
		WsnSpecificTypeHelper.setSOAParameter(soaParam, ref);
		
		//endpointParam.addResourceUuid(subscriptionId);
		ResourcesUuidType rUuids = WSNotificationExtensionFactory.getInstance().createResourcesUuidType();
		rUuids.addUuid(subscriptionId);
		WsnSpecificTypeHelper.setResourcesUuidType(rUuids, ref);
		
		// -- Create Subscription resource to manage 
		subscription = WSNotificationFactory.getInstance().createSubscriptionManagerRP();
		subscription.setConsumerReference(payload.getConsumerReference());
		// --- to test ---
		FilterType ft = payload.getFilter();
		// ---------------
		subscription.setFilter(ft);
		subscription.setCreationTime((new GregorianCalendar()).getTime());
		subscription.setSubscriptionPolicy(payload.getSubscriptionPolicy());

		this.subscriptions.put(subscriptionId, subscription);			
				
		return subsRef;
	}
	
	
	/**
	 * 
	 * @param subscriptionId
	 * @return
	 * @throws WSNotificationException
	 */
	public EndpointReferenceType getConsumerEdpRefOfSubscription(String subscriptionId) throws WSNotificationException{
		EndpointReferenceType consumerEdp = null;
		SubscriptionManagerRP subsManResource = this.subscriptions.get(subscriptionId);
        if (subsManResource != null)        
		consumerEdp = subsManResource.getConsumerReference();
		return consumerEdp;
	}
	
	public TopicExpressionType getTopicExpressionOfSubscription(String subscriptionId) throws WSNotificationException{
		TopicExpressionType topExpr = null;
		SubscriptionManagerRP subsManResource = this.subscriptions.get(subscriptionId);
		if (subsManResource != null)
			topExpr = subsManResource.getFilter().getTopicExpression();
		return topExpr;
	}
	
	public FilterType getFilterOfSubscription(String subscriptionId) throws WSNotificationException{
		FilterType filter = null;
		SubscriptionManagerRP subsManResource = this.subscriptions.get(subscriptionId);
		if (subsManResource != null)
			filter = subsManResource.getFilter();
		return filter;
	}
	
	public SubscriptionPolicyType getPolicyOfSubscription(String subscriptionId) throws WSNotificationException {
		SubscriptionPolicyType policy = null;
		SubscriptionManagerRP subsManResource = this.subscriptions.get(subscriptionId);
        if (subsManResource != null)
        	policy = subsManResource.getSubscriptionPolicy();
		return policy;
	}
		
}


