/**
 * Copyright (c) 2009 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * $Id$
 * -------------------------------------------------------------------------
 */
package com.ebmwebsourcing.wsstar.notification.service.topic;

import javax.xml.namespace.QName;

/**
 * The Ws topic constants
 * 
 * @author chamerling - eBM WebSourcing
 * 
 */
public class WstConstants {

    /**
     * 
     */
    public static final String NAMESPACE_URI = "http://docs.oasis-open.org/wsn/t-1";

    /**
     * 
     */
    public static final String PREFIX = "wstop";
    
    /**
     * 
     */
    public static final String XML_SCHEMA_PREFIX = "xsi";
    
    /**
     * 
     */
    public static final String XML_SCHEMA_NAMESPACE = "http://www.w3.org/2001/XMLSchema-instance";     
    
    /**
     * 
     */
    public static final String CONCRETE_TOPIC_URI = NAMESPACE_URI
            + "/TopicExpression/Concrete";

    /**
     * 
     */
    public static final String DIALECT = "dialect";

    /**
     * 
     */
    public static final String FINAL = "final";

    /**
     * 
     */
    public static final String FULL_TOPIC_URI = NAMESPACE_URI
            + "/TopicExpression/Full";

    /**
     * 
     */
    public static final String MESSAGE_TYPES = "messageTypes";

    /**
     * 
     */
    public static final QName PATTERN_QNAME = new QName(NAMESPACE_URI,
            "MessagePattern", PREFIX);

    /**
     * 
     */
    public static final String SIMPLE_TOPIC_URI = NAMESPACE_URI
            + "/TopicExpression/Simple";

    /**
     * 
     */
    public static final QName TOPIC_NAMESPACE_QNAME = new QName(NAMESPACE_URI,
            "TopicNamespace", PREFIX);

    /**
     * 
     */
    public static final QName TOPIC_QNAME = new QName(NAMESPACE_URI, "Topic",
            PREFIX);

    /**
     * 
     */
    public static final QName TOPIC_SET_QNAME = new QName(NAMESPACE_URI,
            "TopicSet", PREFIX);
}
