/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.wsstar.notification.service.basenotification.impl;

import com.ebmwebsourcing.wsstar.addressing.definition.WSAddressingFactory;
import com.ebmwebsourcing.wsstar.addressing.definition.api.EndpointReferenceType;
import com.ebmwebsourcing.wsstar.addressing.definition.api.ReferenceParametersType;
import com.ebmwebsourcing.wsstar.addressing.definition.api.WSAddressingException;
import com.ebmwebsourcing.wsstar.addressing.definition.api.absitf.AbsItfReferenceParametersType;
import com.ebmwebsourcing.wsstar.notification.definition.WSNotificationFactory;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.FilterType;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.Renew;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.RenewResponse;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.Subscribe;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.SubscriptionManagerRP;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.SubscriptionPolicyType;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.TopicExpressionType;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.Unsubscribe;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.UnsubscribeResponse;
import com.ebmwebsourcing.wsstar.notification.definition.utils.WSNotificationException;
import com.ebmwebsourcing.wsstar.notification.extension.WSNotificationExtensionFactory;
import com.ebmwebsourcing.wsstar.notification.extension.api.ResourcesUuidType;
import com.ebmwebsourcing.wsstar.notification.extension.api.SOAParameterType;
import com.ebmwebsourcing.wsstar.notification.extension.utils.WSNotificationExtensionException;
import com.ebmwebsourcing.wsstar.notification.extension.utils.WsnSpecificTypeHelper;
import com.ebmwebsourcing.wsstar.notification.service.basenotification.WsnbSubscriptionManager;
import com.ebmwebsourcing.wsstar.notification.service.fault.ResourceNotDestroyedFault;
import com.ebmwebsourcing.wsstar.notification.service.fault.ResourceUnknownFault;
import com.ebmwebsourcing.wsstar.notification.service.fault.WSNotificationFault;
import com.ebmwebsourcing.wsstar.notification.service.topic.WstopTopicManager;
import com.ebmwebsourcing.wsstar.notification.service.util.WSNotificationNotImplementedException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SubscriptionManagerMgr
implements WsnbSubscriptionManager {
    protected Logger logger;
    protected Map<String, SubscriptionManagerRP> subscriptions;
    protected WstopTopicManager topicsMgr;
    protected String subscriptionsManagerEdp = "http://www.ebmwebsourcing.com/subscriptionManager/default";
    protected QName subscriptionsManagerService = new QName("http://www.ebmwebsourcing.com/default", "SubscriptionManagerService");
    protected QName subscriptionsManagerInterface = new QName("http://www.ebmwebsourcing.com/default", "SubscriptionManager");

    public SubscriptionManagerMgr(Logger logger, WstopTopicManager topicsMgr) {
        this.logger = logger;
        this.subscriptions = Collections.synchronizedMap(new HashMap());
        this.topicsMgr = topicsMgr;
    }

    public String getSubscriptionsManagerEdp() {
        return this.subscriptionsManagerEdp;
    }

    public void setSubscriptionsManagerEdp(String subscriptionsMgrEdp) {
        this.subscriptionsManagerEdp = subscriptionsMgrEdp;
    }

    public QName getSubscriptionsManagerService() {
        return this.subscriptionsManagerService;
    }

    public void setSubscriptionsManagerService(QName subscriptionsMgrService) {
        this.subscriptionsManagerService = subscriptionsMgrService;
    }

    public QName getSubscriptionsManagerInterface() {
        return this.subscriptionsManagerInterface;
    }

    public void setSubscriptionsManagerInterface(QName subscriptionsMgrInterface) {
        this.subscriptionsManagerInterface = subscriptionsMgrInterface;
    }

    public List<String> getStoredSubscriptionIds() {
        return new ArrayList<String>(this.subscriptions.keySet());
    }

    @Override
    public UnsubscribeResponse unsubscribe(Unsubscribe request) throws WSNotificationException, WSNotificationFault, WSNotificationExtensionException {
        List resourcesId;
        this.logger.log(Level.FINE, "performs a \"Unsubscribe\" request ...");
        this.logger.log(Level.FINE, "\"Unsubscribe\"  method implementation in progress ... ");
        UnsubscribeResponse response = null;
        ResourcesUuidType uuids = WsnSpecificTypeHelper.getResourcesUuidType((Unsubscribe)request);
        if (uuids != null && (resourcesId = uuids.getUuids()) != null) {
            for (String rId : resourcesId) {
                if (this.subscriptions.containsKey(rId)) {
                    this.subscriptions.remove(rId);
                    if (this.subscriptions.containsKey(rId)) {
                        throw new ResourceNotDestroyedFault("eng", "The SubscriptionManager was unable to destroy the Subscription resource for some reason.");
                    }
                    this.topicsMgr.removeExistingSubscription(rId);
                    continue;
                }
                throw new ResourceUnknownFault("eng", "The SubscriptionManager is acting as a WS-Resource, and the resource identified in the message is not known to the Web service.");
            }
        }
        response = WSNotificationFactory.getInstance().createUnsubscribeResponse();
        return response;
    }

    @Override
    public RenewResponse renew(Renew request) throws WSNotificationException, WSNotificationFault {
        this.logger.log(Level.FINE, "performs a \"Renew\" request ...");
        throw new WSNotificationNotImplementedException(this.getClass().getName(), "Renew");
    }

    EndpointReferenceType createAndStoreSubscriptionResource(String subscriptionId, Subscribe payload) throws WSNotificationException, WSAddressingException, WSNotificationExtensionException {
        EndpointReferenceType subsRef = null;
        SubscriptionManagerRP subscription = null;
        subsRef = WSAddressingFactory.getInstance().newEndpointReferenceType();
        subsRef.setAddress(payload.getConsumerReference().getAddress());
        ReferenceParametersType ref = (ReferenceParametersType)subsRef.newReferenceParameters();
        subsRef.setReferenceParameters((AbsItfReferenceParametersType)ref);
        SOAParameterType soaParam = WSNotificationExtensionFactory.getInstance().createSOAParameterType();
        soaParam.setService(this.subscriptionsManagerService);
        soaParam.setInterface(this.subscriptionsManagerInterface);
        soaParam.setEndpoint(this.subscriptionsManagerEdp);
        WsnSpecificTypeHelper.setSOAParameter((SOAParameterType)soaParam, (ReferenceParametersType)ref);
        ResourcesUuidType rUuids = WSNotificationExtensionFactory.getInstance().createResourcesUuidType();
        rUuids.addUuid(subscriptionId);
        WsnSpecificTypeHelper.setResourcesUuidType((ResourcesUuidType)rUuids, (ReferenceParametersType)ref);
        subscription = WSNotificationFactory.getInstance().createSubscriptionManagerRP();
        subscription.setConsumerReference(payload.getConsumerReference());
        FilterType ft = payload.getFilter();
        subscription.setFilter(ft);
        subscription.setCreationTime(new GregorianCalendar().getTime());
        subscription.setSubscriptionPolicy(payload.getSubscriptionPolicy());
        this.subscriptions.put(subscriptionId, subscription);
        return subsRef;
    }

    public EndpointReferenceType getConsumerEdpRefOfSubscription(String subscriptionId) throws WSNotificationException {
        EndpointReferenceType consumerEdp = null;
        SubscriptionManagerRP subsManResource = this.subscriptions.get(subscriptionId);
        if (subsManResource != null) {
            consumerEdp = subsManResource.getConsumerReference();
        }
        return consumerEdp;
    }

    public TopicExpressionType getTopicExpressionOfSubscription(String subscriptionId) throws WSNotificationException {
        TopicExpressionType topExpr = null;
        SubscriptionManagerRP subsManResource = this.subscriptions.get(subscriptionId);
        if (subsManResource != null) {
            topExpr = subsManResource.getFilter().getTopicExpression();
        }
        return topExpr;
    }

    public FilterType getFilterOfSubscription(String subscriptionId) throws WSNotificationException {
        FilterType filter = null;
        SubscriptionManagerRP subsManResource = this.subscriptions.get(subscriptionId);
        if (subsManResource != null) {
            filter = subsManResource.getFilter();
        }
        return filter;
    }

    public SubscriptionPolicyType getPolicyOfSubscription(String subscriptionId) throws WSNotificationException {
        SubscriptionPolicyType policy = null;
        SubscriptionManagerRP subsManResource = this.subscriptions.get(subscriptionId);
        if (subsManResource != null) {
            policy = subsManResource.getSubscriptionPolicy();
        }
        return policy;
    }
}

