/**
 * Copyright (c) 2009 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * $Id$
 * -------------------------------------------------------------------------
 */
package com.ebmwebsourcing.wsstar.notification.service.basenotification.impl;

import java.util.logging.Level;
import java.util.logging.Logger;

import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.CreatePullPoint;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.CreatePullPointResponse;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.DestroyPullPoint;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.DestroyPullPointResponse;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.GetMessagesResponse;
import com.ebmwebsourcing.wsstar.notification.definition.utils.WSNotificationException;
import com.ebmwebsourcing.wsstar.notification.service.basenotification.WsnbCreatePullPoint;
import com.ebmwebsourcing.wsstar.notification.service.basenotification.WsnbPullPoint;
import com.ebmwebsourcing.wsstar.notification.service.util.WSNotificationNotImplementedException;
/**
 * @author tdejean - eBM WebSourcing
 * 
 */
public class PullPointMgr implements WsnbPullPoint {

	private Logger logger;
	
	public PullPointMgr(Logger logger) {
		super();
		this.logger = logger;		
	}
	
	/*
	 * (non-Javadoc)
	 * @see com.ebmwebsourcing.wsstar.notification.service.basenotification.WsnbPullPoint#destroyPullPoint(com.ebmwebsourcing.wsstar.notification.service.test.wsnotification.base.DestroyPullPoint)
	 */
	public DestroyPullPointResponse destroyPullPoint(DestroyPullPoint request)
			throws WSNotificationException {
		logger.log(Level.FINE, "performs a \"DestroyPullPoint\" request ...");
		//TODO : implement this method !!!
		throw new WSNotificationNotImplementedException(this.getClass().getName(),"DestroyPullPoint");
	}

	/*
	 * (non-Javadoc)
	 * @see com.ebmwebsourcing.wsstar.notification.service.basenotification.WsnbPullPoint#getMessages(com.ebmwebsourcing.wsstar.notification.service.test.wsnotification.base.GetMessagesResponse)
	 */
	public GetMessagesResponse getMessages(GetMessagesResponse request)
			throws WSNotificationException {
		logger.log(Level.FINE, "performs a \"GetMessages\" request ...");
		throw new WSNotificationNotImplementedException(this.getClass().getName(),"GetMessages");
	}

}
