/**
 * Copyright (c) 2009 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * $Id$
 * -------------------------------------------------------------------------
 */
package com.ebmwebsourcing.wsstar.notification.service.brokerednotification.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;

import javax.xml.namespace.QName;

import com.ebmwebsourcing.wsstar.addressing.definition.WSAddressingFactory;
import com.ebmwebsourcing.wsstar.addressing.definition.api.EndpointReferenceType;
import com.ebmwebsourcing.wsstar.addressing.definition.api.ReferenceParametersType;
import com.ebmwebsourcing.wsstar.addressing.definition.api.WSAddressingException;
import com.ebmwebsourcing.wsstar.notification.definition.WSNotificationFactory;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.TopicExpressionType;
import com.ebmwebsourcing.wsstar.notification.definition.brokerednotification.api.DestroyRegistration;
import com.ebmwebsourcing.wsstar.notification.definition.brokerednotification.api.DestroyRegistrationResponse;
import com.ebmwebsourcing.wsstar.notification.definition.brokerednotification.api.PublisherRegistrationRP;
import com.ebmwebsourcing.wsstar.notification.definition.brokerednotification.api.RegisterPublisher;
import com.ebmwebsourcing.wsstar.notification.definition.brokerednotification.api.RegisterPublisherResponse;
import com.ebmwebsourcing.wsstar.notification.definition.utils.WSNotificationException;
import com.ebmwebsourcing.wsstar.notification.extension.WSNotificationExtensionFactory;
import com.ebmwebsourcing.wsstar.notification.extension.api.ResourcesUuidType;
import com.ebmwebsourcing.wsstar.notification.extension.api.SOAParameterType;
import com.ebmwebsourcing.wsstar.notification.extension.utils.WSNotificationExtensionException;
import com.ebmwebsourcing.wsstar.notification.extension.utils.WsnSpecificTypeHelper;
import com.ebmwebsourcing.wsstar.notification.service.brokerednotification.WsnbrPublisherRegistrationManager;
import com.ebmwebsourcing.wsstar.notification.service.brokerednotification.WsnbrRegisterPublisher;
import com.ebmwebsourcing.wsstar.notification.service.fault.ResourceNotDestroyedFault;
import com.ebmwebsourcing.wsstar.notification.service.fault.ResourceUnknownFault;
import com.ebmwebsourcing.wsstar.notification.service.fault.WSNotificationFault;
import com.ebmwebsourcing.wsstar.notification.service.fault.WsnFaultMessageConstants;
import com.ebmwebsourcing.wsstar.notification.service.persistence.WsnPersistence;
import com.ebmwebsourcing.wsstar.notification.service.topic.WstopTopicManager;

/**
 * @author tdejean - eBM WebSourcing
 */
public class RegistrationsMgr implements WsnbrRegisterPublisher, WsnbrPublisherRegistrationManager {

	private Logger logger;

	private String publisherRegistrationMgrEdpAddress = "http://www.ebmwebsourcing.com/PublisherRegistrationManager/default";
	private QName publisherRegistrationMgrServiceQName = new QName("http://www.ebmwebsourcing.com/default", "PublisherRegistrationManagerService");
	private QName publisherRegistrationMgrInterfaceQName = new QName("http://www.ebmwebsourcing.com/default", "PublisherRegistrationManager");

	private String notificationBrokerEdp = "http://www.ebmwebsourcing.com/NotificationBorker/default";
	private QName notificationBrokerService = new QName("http://www.ebmwebsourcing.com/default", "NotificationBorkerService");
	private QName notificationBrokerInterface = new QName("http://www.ebmwebsourcing.com/default", "NotificationBorker");

	private Map<String, PublisherRegistrationRP> registrations;
	private WstopTopicManager topicsMgr;
	
	private WsnPersistence persistenceMgr = null;

	public RegistrationsMgr(Logger logger, WstopTopicManager topicsMgr, WsnPersistence persistenceMgr) {
		super();
		this.logger = logger;
		this.registrations = Collections.synchronizedMap(new HashMap<String, PublisherRegistrationRP>());
		this.topicsMgr = topicsMgr;
		this.persistenceMgr = persistenceMgr;
	}
	
	public RegistrationsMgr(Logger logger, WstopTopicManager topicsMgr) {
		super();
		this.logger = logger;
		this.registrations = Collections.synchronizedMap(new HashMap<String, PublisherRegistrationRP>());
		this.topicsMgr = topicsMgr;
		this.persistenceMgr = null;
	}
	
	public RegistrationsMgr(Logger logger) {
		super();
		this.logger = logger;
		this.registrations = Collections.synchronizedMap(new HashMap<String, PublisherRegistrationRP>());
		this.topicsMgr = null;
		this.persistenceMgr = null;
	}
	
	
	public void setPublisherRegistrationMgrEdpAddress(String publisherRegisterEdpAddress) {
		this.publisherRegistrationMgrEdpAddress = publisherRegisterEdpAddress;
	}

	public void setPublisherRegistrationMgrInterfaceQName(QName publisherRegisterInterfaceQName) {
		this.publisherRegistrationMgrInterfaceQName = publisherRegisterInterfaceQName;
	}

	public void setPublisherRegistrationMgrServiceQName(QName publisherRegisterServiceQName) {
		this.publisherRegistrationMgrServiceQName = publisherRegisterServiceQName;
	}

	public void setNotificationBrokerEdp(String notificationBrokerEdp) {
		this.notificationBrokerEdp = notificationBrokerEdp;
	}

	public void setNotificationBrokerService(QName notificationBrokerService) {
		this.notificationBrokerService = notificationBrokerService;
	}

	public void setNotificationBrokerInterface(QName notificationBrokerInterface) {
		this.notificationBrokerInterface = notificationBrokerInterface;
	}

	public EndpointReferenceType getPublisherEdpRefOfRegistration(String registrationId) throws WSNotificationException {					
		
		 EndpointReferenceType publisherEdp = null;
		 PublisherRegistrationRP storedRP = this.registrations.get(registrationId);
		 if (storedRP != null){
			
			 publisherEdp = storedRP.getPublisherReference();
		 }
		return publisherEdp;
	}

	public List<EndpointReferenceType> getPublisherEdpRefOfRegistration(List<String> registrationIds) throws WSNotificationException {
		List<EndpointReferenceType> publisherEdps = new ArrayList<EndpointReferenceType>();
		for (String regIdItem : registrationIds) {
			publisherEdps.add(this.registrations.get(regIdItem).getPublisherReference());
		}
		return publisherEdps;
	}

	/*
	 * (non-Javadoc)
	 * @see com.ebmwebsourcing.wsstar.notification.service.brokerednotification.WsnbrRegisterPublisher#registerPublisher(com.ebmwebsourcing.wsstar.notification.service.test.wsnotification.brokered.RegisterPublisher)
	 */
	public RegisterPublisherResponse registerPublisher(RegisterPublisher request) throws WSNotificationException, WSNotificationFault, WSNotificationExtensionException {
		logger.log(Level.FINE, "performs a \"RegisterPublisher\" request ...");
		// TODO : implement this method !
		logger.log(Level.FINE, "\"RegisterPublisher\" method implementation in progress !");

		RegisterPublisherResponse response = null;

		// ---- create new Publisher registration :
		List<TopicExpressionType> topics = request.getTopic();
		// boolean isAcceptedTopics = true;

		for (TopicExpressionType topicExpressionType : topics) {
			// create topic
			if (request.getPublisherReference() != null && logger.isLoggable(Level.FINE) ) {
				logger.log(Level.FINE, "PublisherReference : " + request.getPublisherReference().getAddress());
			}
			if (request.getInitialTerminationTime() != null && logger.isLoggable(Level.FINE)) {
				logger.log(Level.FINE, "initial termination Time : " + request.getInitialTerminationTime().toString());
			}
			if (topicExpressionType != null && logger.isLoggable(Level.FINE)) {
				logger.log(Level.FINE, "Dialect : " + topicExpressionType.getDialect());
				logger.log(Level.FINE, "Topic content : " + topicExpressionType.getContent());
			}
			// ------ WARNING !!! : make test fail on hudson. Why ? -----
			// System.out.println("Topic Namespace content : " + topicExpressionType.getTopicNameSpace());
			if ( logger.isLoggable(Level.FINE) ) {
                            for (QName nsToDisplay : topicExpressionType.getTopicNameSpace()) {
				logger.log(Level.FINE, "Topic Namespace(s) content : " + nsToDisplay);
                            }
			}

			// ----------------------------------------------------------
			try {
				// isAcceptedTopics &= this.topicsMgr.acceptSubscribeOrRegisterTopicExpression(topicExpressionType, /*this.topicsMgr.getSupportedTopics(),*/false);

				PublisherRegistrationRP registration = null;
				// ------- Generate UUID as endpoint reference for Registration :

				String registrationId = /*"uuid:" +*/ UUID.randomUUID().toString();

				this.topicsMgr.storeNewRegistration(topicExpressionType, registrationId);

				// Get previous subscription on topics representing by topicExpressionType
				// A subcription must be process for each of them

				EndpointReferenceType registrationEdpRef = WSAddressingFactory.getInstance().newEndpointReferenceType();

				// use @ of request/publisherRefEdp instead of Default //EndpointParameterType.DEFAULT_PETALS_ADDRESS);
				registrationEdpRef.setAddress(request.getPublisherReference().getAddress());

				ReferenceParametersType ref = registrationEdpRef.newReferenceParameters();
				registrationEdpRef.setReferenceParameters(ref);
				
				SOAParameterType soaParam = WSNotificationExtensionFactory.getInstance().createSOAParameterType();
				
				soaParam.setService(this.publisherRegistrationMgrServiceQName);
				soaParam.setInterface(this.publisherRegistrationMgrInterfaceQName);
				soaParam.setEndpoint(this.publisherRegistrationMgrEdpAddress);

				WsnSpecificTypeHelper.setSOAParameter(soaParam, ref);
				
				// endpointParam.addResourceUuid(registrationId);
				ResourcesUuidType rUuids = WSNotificationExtensionFactory.getInstance().createResourcesUuidType();
				rUuids.addUuid(registrationId);
				WsnSpecificTypeHelper.setResourcesUuidType(rUuids,ref);

				// -- Create PublisherRegistration resource to manage
				registration = WSNotificationFactory.getInstance().createPublisherRegistrationRP();
				registration.setPublisherReference(request.getPublisherReference());
				
				List<TopicExpressionType> topExprLists = request.getTopic(); 
				for (TopicExpressionType topExpItem : topExprLists) {
					registration.addTopic(topExpItem);
				}
				registration.setDemand(request.isDemand());
				registration.setCreationTime((new GregorianCalendar()).getTime());

				this.registrations.put(registrationId, registration);
				if (this.persistenceMgr != null)
					this.persistenceMgr.persist(registration, registrationId);

				response = WSNotificationFactory.getInstance().createRegisterPublisherResponse();
				response.setPublisherRegistrationReference(registrationEdpRef);

				if (!request.isDemand()) {

					EndpointReferenceType consumerRef = WSAddressingFactory.getInstance().newEndpointReferenceType();

					// use @ of request/publisherRefEdp instead of Default //EndpointParameterType.DEFAULT_PETALS_ADDRESS);
					consumerRef.setAddress(request.getPublisherReference().getAddress());

					ReferenceParametersType consRefPar;
					consRefPar = consumerRef.newReferenceParameters();
					consumerRef.setReferenceParameters(consRefPar);
					
					SOAParameterType consSoaParam = WSNotificationExtensionFactory.getInstance().createSOAParameterType();
					
					consSoaParam.setService(this.notificationBrokerService);
					consSoaParam.setInterface(this.notificationBrokerInterface);
					consSoaParam.setEndpoint(this.notificationBrokerEdp);

					WsnSpecificTypeHelper.setSOAParameter(consSoaParam, consRefPar);
					
					response.setConsumerReference(consumerRef);
				}				
				
			} catch (WSAddressingException e) {
				throw new WSNotificationException(e);
			} catch (WSNotificationFault fault) {
				throw fault;
			}
		}
		/*
		 * // ---- Temporaire : int randomFault = 0; //RandomUtils.nextInt(7); if (!isAcceptedTopics) randomFault = 3; switch (randomFault) { case 0: PublisherRegistrationRP registration = null; // ------- Generate UUID as endpoint reference for Registration : try { String registrationId = "uuid:" + UUID.randomUUID();
		 * WstopTopicManager.getInstance().storeNewRegistration(topicExprToCheck, registrationId) EndpointReferenceType registrationEdpRef = WSNotificationFactory.getInstance().createEndpointReferenceType(); registrationEdpRef.setAddress(EndpointParameterType.DEFAULT_PETALS_ADDRESS); ReferenceParametersType ref; ref =
		 * registrationEdpRef.newReferenceParameters(); registrationEdpRef.setReferenceParameters(ref); EndpointParameterType endpointParam = ref.newEndpointParameterType(); ref.setEndpointParameterType(endpointParam); endpointParam.setServiceName(this.publisherRegistrationMgrServiceQName);
		 * endpointParam.setInterfaceName(this.publisherRegistrationMgrInterfaceQName); endpointParam.setEndpoint(this.publisherRegistrationMgrEdpAddress); endpointParam.addResourceUuid(registrationId); // -- Create PublisherRegistration resource to manage registration =
		 * WSNotificationFactory.getInstance().createPublisherRegistrationRP(); registration.setPublisherReference(request.getPublisherReference()); registration.getTopic().addAll(request.getTopic()); registration.setDemand(request.isDemand()); registration.setCreationTime((new GregorianCalendar()).getTime());
		 * this.registrations.put(registrationId, registration); // TODO : add registrationId in all described topic // ------------------------------------------------ response = WSNotificationFactory.getInstance().createRegisterPublisherResponse(); response.setPublisherRegistrationReference(registrationEdpRef);
		 * break; } catch (WSAddressingException e) { // TODO Auto-generated catch block throw new WSNotificationException(e); } case 1: throw new ResourceUnknownFault(WsnFaultMessageConstants.FAULT_DESCRIPTION_LANGUAGE, WsnFaultMessageConstants.WsnbrRegisterPublisherFaultDescriptions.RESOURCE_UNKNOWN_FAULT_DESC); case
		 * 2: throw new InvalidTopicExpressionFault(WsnFaultMessageConstants.FAULT_DESCRIPTION_LANGUAGE, WsnFaultMessageConstants.WsnbrRegisterPublisherFaultDescriptions.INVALID_TOPIC_EXPRESSION_FAULT_DESC); case 3: throw new TopicNotSupportedFault(WsnFaultMessageConstants.FAULT_DESCRIPTION_LANGUAGE,
		 * WsnFaultMessageConstants.WsnbrRegisterPublisherFaultDescriptions.TOPIC_NOT_SUPPORTED_FAULT_DESC); case 4: throw new PublisherRegistrationRejectedFault(WsnFaultMessageConstants.FAULT_DESCRIPTION_LANGUAGE,
		 * WsnFaultMessageConstants.WsnbrRegisterPublisherFaultDescriptions.PUBLISHER_REGISTRATION_REJECTED_FAULT_DESC); case 5: throw new PublisherRegistrationFailedFault(WsnFaultMessageConstants.FAULT_DESCRIPTION_LANGUAGE,
		 * WsnFaultMessageConstants.WsnbrRegisterPublisherFaultDescriptions.PUBLISHER_REGISTRATION_FAILED_FAULT_DESC); case 6: throw new UnacceptableInitialTerminationTimeFault(WsnFaultMessageConstants.FAULT_DESCRIPTION_LANGUAGE,
		 * WsnFaultMessageConstants.WsnbrRegisterPublisherFaultDescriptions.UNACCEPTABLE_INITIAL_TERMINATION_TIME_FAULT_DESC); }
		 */
	
		return response;
	}

	/*
	 * (non-Javadoc)
	 * @see com.ebmwebsourcing.wsstar.notification.service.brokerednotification.WsnbrPublisherRegistrationManager#destroyRegistration(com.ebmwebsourcing.wsstar.notification.service.test.wsnotification.brokered.DestroyRegistration)
	 */
	public DestroyRegistrationResponse destroyRegistration(DestroyRegistration request) throws WSNotificationException, WSNotificationFault, WSNotificationExtensionException {
		logger.log(Level.FINE, "performs a \"DestroyRegistration\" request ...");
		// TODO : implement this method !
		logger.log(Level.FINE, "\"DestroyRegistration\" method implementation in progress !");
		
		DestroyRegistrationResponse response = null;

		// ---- perform a registration destruction ---

		ResourcesUuidType registrationUuids = WsnSpecificTypeHelper.getResourcesUuidType(request);
		if (registrationUuids != null) {
			List<String> resourcesId = registrationUuids.getUuids();
			if (resourcesId != null) {
				for (String rId : resourcesId) {
					if (registrations.containsKey(rId)) {
						registrations.remove(rId);
						if (registrations.containsKey(rId))
							throw new ResourceNotDestroyedFault(WsnFaultMessageConstants.FAULT_DESCRIPTION_LANGUAGE, WsnFaultMessageConstants.WsnbrDestroyRegistrationFaultDescriptions.RESOURCE_NOT_DESTROYED_FAULT_DESC);
						// --- remove the registrationId From the topicTree
						else
							this.topicsMgr.removeExistingRegistration(rId);
							
							if (this.persistenceMgr != null)
								this.persistenceMgr.removeRegistration(rId);
						
					} else
						throw new ResourceUnknownFault(WsnFaultMessageConstants.FAULT_DESCRIPTION_LANGUAGE, WsnFaultMessageConstants.WsnbrDestroyRegistrationFaultDescriptions.RESOURCE_UNKNOWN_FAULT_DESC);
				}
			}
		} else
			throw new ResourceNotDestroyedFault(WsnFaultMessageConstants.FAULT_DESCRIPTION_LANGUAGE, WsnFaultMessageConstants.WsnbrDestroyRegistrationFaultDescriptions.RESOURCE_NOT_DESTROYED_FAULT_DESC);

		// ---- temporary code :
		response = WSNotificationFactory.getInstance().createDestroyRegistrationResponse();
		return response;
	}

	public void restorePersistedRegistration() throws WSNotificationException, WSNotificationFault {

		if (persistenceMgr != null){

			Map<String, PublisherRegistrationRP> pubRegRPToRestore = this.persistenceMgr.getRegistrationsToRestore();

			Set<String> rIds = pubRegRPToRestore.keySet();
			PublisherRegistrationRP currentPubRegRP = null;
			List<TopicExpressionType> currentTopics = null;

			for (String idItem : rIds) {
				currentPubRegRP = pubRegRPToRestore.get(idItem);

				this.registrations.put(idItem, currentPubRegRP);

				currentTopics = currentPubRegRP.getTopic();
				for (TopicExpressionType topExpItem : currentTopics) {
					this.topicsMgr.storeNewRegistration(topExpItem, idItem);
				}			
			}		
		}
	}
}
