/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.wsstar.notification.service.topic;

import com.ebmwebsourcing.wsstar.notification.definition.utils.WSNotificationException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jaxen.JaxenException;
import org.jaxen.NamespaceContext;
import org.jaxen.SimpleNamespaceContext;
import org.jaxen.XPath;
import org.jaxen.jdom.JDOMXPath;
import org.jdom.Element;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.ow2.easywsdl.schema.api.extensions.NamespaceMapperImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XPathAnalyzer {
    private static Logger log = Logger.getLogger(XPathAnalyzer.class.getName());
    private XPath engine;
    private NamespaceContext xpathContext;

    public List<?> evaluate(String xpathExpression, Element source, NamespaceMapperImpl context) throws WSNotificationException {
        ArrayList<String> xpathExpressions = new ArrayList<String>();
        xpathExpressions.add(xpathExpression);
        return this.evaluate(xpathExpressions, source, context);
    }

    public List<?> evaluate(List<String> xpathExpressions, Element source, NamespaceMapperImpl context) throws WSNotificationException {
        List target = null;
        try {
            if (source != null) {
                for (String xpathExpression : xpathExpressions) {
                    this.engine = new JDOMXPath(xpathExpression);
                    this.xpathContext = new SimpleNamespaceContext();
                    for (Map.Entry entry : context.getNamespaces().entrySet()) {
                        ((SimpleNamespaceContext)this.xpathContext).addNamespace((String)entry.getKey(), (String)entry.getValue());
                    }
                    this.engine.setNamespaceContext(this.xpathContext);
                    List res = this.engine.selectNodes((Object)source);
                    if (!(res instanceof List)) continue;
                    target = res;
                    if (!log.isLoggable(Level.FINE)) break;
                    log.fine("this xpath expression " + xpathExpression + " matchs with: \n " + new XMLOutputter(Format.getPrettyFormat()).outputString(source));
                    break;
                }
                if (target == null && log.isLoggable(Level.FINE)) {
                    log.fine("No xpath expressions " + xpathExpressions + " match with: \n " + new XMLOutputter(Format.getPrettyFormat()).outputString(source));
                }
            }
        }
        catch (JaxenException e) {
            throw new WSNotificationException((Throwable)e);
        }
        return target;
    }
}

