/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.wsstar.qml.impl;

import com.ebmwebsourcing.wsstar.qml.api.Constraint;
import com.ebmwebsourcing.wsstar.qml.api.QOSDimension;
import com.ebmwebsourcing.wsstar.qml.api.WSQMLException;
import com.ebmwebsourcing.wsstar.qml.api.WSQMLReader;
import com.ebmwebsourcing.wsstar.qml.impl.ConstraintImpl;
import com.ebmwebsourcing.wsstar.qml.impl.EquivalentToImpl;
import com.ebmwebsourcing.wsstar.qml.impl.QOSDimensionImpl;
import com.ebmwebsourcing.wsstar.qml.impl.WSQMLJAXBContext;
import com.ebmwebsourcing.wsstar.qml.upmc.fr.ConstraintType;
import com.ebmwebsourcing.wsstar.qml.upmc.fr.EquivalentTo;
import com.ebmwebsourcing.wsstar.qml.upmc.fr.QoSDimension;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import org.ow2.easywsdl.schema.api.SchemaException;
import org.ow2.easywsdl.schema.api.XmlException;
import org.ow2.easywsdl.schema.util.SourceHelper;
import org.ow2.easywsdl.schema.util.StreamHelper;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSQMLReaderImpl
implements WSQMLReader {
    private static Logger log = Logger.getLogger(WSQMLReaderImpl.class.getName());
    private Map<WSQMLReader.FeatureConstants, Object> features = new HashMap<WSQMLReader.FeatureConstants, Object>();
    private static Unmarshaller unmarshaller = null;
    private static SchemaException unmarshallerCreationEx = null;

    public WSQMLReaderImpl() {
        this.features.put(WSQMLReader.FeatureConstants.VERBOSE, false);
        this.features.put(WSQMLReader.FeatureConstants.IMPORT_DOCUMENTS, true);
    }

    public static Unmarshaller getUnMarshaller() throws SchemaException {
        if (unmarshallerCreationEx != null) {
            throw unmarshallerCreationEx;
        }
        return unmarshaller;
    }

    public static JAXBContext getJaxbContext() {
        return WSQMLJAXBContext.getJaxbContext();
    }

    @Override
    public QOSDimension readQOSDimension(URI uri) throws WSQMLException {
        QOSDimension desc = null;
        try {
            InputStream input = null;
            File f = new File(uri.getPath());
            input = f.exists() ? new FileInputStream(f) : uri.toURL().openStream();
            desc = this.readQOSDimension(uri, new InputSource(input));
        }
        catch (MalformedURLException e) {
            throw new WSQMLException("Can not get wsdl at: " + uri, e);
        }
        catch (IOException e) {
            throw new WSQMLException("Can not get wsdl at: " + uri, e);
        }
        catch (SchemaException e) {
            throw new WSQMLException("Can not get wsdl at: " + uri, e);
        }
        catch (XmlException e) {
            throw new WSQMLException("Can not get wsdl at: " + uri, e);
        }
        return desc;
    }

    @Override
    public QOSDimension readQOSDimension(Document document) throws WSQMLException {
        QOSDimension desc = null;
        try {
            desc = this.readQOSDimension(new URI(document.getDocumentURI()), SourceHelper.convertDOMSource2InputSource((DOMSource)new DOMSource(document)));
        }
        catch (URISyntaxException e) {
            throw new WSQMLException(e);
        }
        catch (XmlException e) {
            throw new WSQMLException(e);
        }
        return desc;
    }

    @Override
    public QOSDimension readQOSDimension(URI uri, InputSource input) throws WSQMLException {
        QOSDimensionImpl desc = null;
        try {
            XMLReader xmlReader = XMLReaderFactory.createXMLReader();
            SAXSource saxSource = new SAXSource(xmlReader, input);
            JAXBElement dimBinding = WSQMLReaderImpl.getUnMarshaller().unmarshal((Source)saxSource, QoSDimension.class);
            desc = new QOSDimensionImpl(uri, (QoSDimension)dimBinding.getValue(), this.getFeatures());
        }
        catch (XmlException e) {
            throw new WSQMLException(e);
        }
        catch (SAXException e) {
            throw new WSQMLException(e);
        }
        catch (JAXBException e) {
            throw new WSQMLException(e);
        }
        return desc;
    }

    @Override
    public void setFeature(WSQMLReader.FeatureConstants name, Object value) throws IllegalArgumentException {
        this.features.put(name, value);
        log.finest("set features: name = " + (Object)((Object)name) + " - value = " + value);
    }

    @Override
    public Object getFeature(WSQMLReader.FeatureConstants name) throws IllegalArgumentException {
        return this.features.get((Object)name);
    }

    @Override
    public Map<WSQMLReader.FeatureConstants, Object> getFeatures() {
        return this.features;
    }

    public void setFeatures(Map<WSQMLReader.FeatureConstants, Object> features) {
        this.features = features;
    }

    private static ConstraintType convertStream2Constraint(Source stream) throws SchemaException {
        try {
            JAXBElement schemaBinding = WSQMLReaderImpl.getUnMarshaller().unmarshal(stream, ConstraintType.class);
            return (ConstraintType)schemaBinding.getValue();
        }
        catch (JAXBException e) {
            throw new SchemaException("Failed to build Java bindings from SchemaImpl descriptor XML document", (Throwable)e);
        }
    }

    @Override
    public Constraint readConstraint(URI uri) throws WSQMLException {
        Constraint desc = null;
        try {
            InputStream input = null;
            File f = new File(uri.getPath());
            input = f.exists() ? new FileInputStream(f) : uri.toURL().openStream();
            desc = this.readConstraint(uri, new InputSource(StreamHelper.getInputStream((URI)uri)));
        }
        catch (MalformedURLException e) {
            throw new WSQMLException("Can not get wsdl at: " + uri, e);
        }
        catch (IOException e) {
            throw new WSQMLException("Can not get wsdl at: " + uri, e);
        }
        catch (SchemaException e) {
            throw new WSQMLException("Can not get wsdl at: " + uri, e);
        }
        catch (XmlException e) {
            throw new WSQMLException("Can not get wsdl at: " + uri, e);
        }
        return desc;
    }

    @Override
    public Constraint readConstraint(Document document) throws WSQMLException {
        Constraint desc = null;
        try {
            desc = this.readConstraint(new URI(document.getDocumentURI()), SourceHelper.convertDOMSource2InputSource((DOMSource)new DOMSource(document)));
        }
        catch (URISyntaxException e) {
            throw new WSQMLException(e);
        }
        catch (XmlException e) {
            throw new WSQMLException(e);
        }
        return desc;
    }

    @Override
    public Constraint readConstraint(URI uri, InputSource input) throws WSQMLException {
        ConstraintImpl desc = null;
        try {
            XMLReader xmlReader = XMLReaderFactory.createXMLReader();
            SAXSource saxSource = new SAXSource(xmlReader, input);
            JAXBElement constraintBinding = WSQMLReaderImpl.getUnMarshaller().unmarshal((Source)saxSource, ConstraintType.class);
            desc = new ConstraintImpl(uri, (ConstraintType)constraintBinding.getValue(), this.getFeatures());
        }
        catch (XmlException e) {
            throw new WSQMLException(e);
        }
        catch (SAXException e) {
            throw new WSQMLException(e);
        }
        catch (JAXBException e) {
            throw new WSQMLException(e);
        }
        return desc;
    }

    @Override
    public com.ebmwebsourcing.wsstar.qml.api.EquivalentTo readEquivalentTo(URI uri) throws WSQMLException {
        com.ebmwebsourcing.wsstar.qml.api.EquivalentTo desc = null;
        try {
            InputStream input = null;
            File f = new File(uri.getPath());
            input = f.exists() ? new FileInputStream(f) : uri.toURL().openStream();
            desc = this.readEquivalentTo(uri, new InputSource(input));
        }
        catch (MalformedURLException e) {
            throw new WSQMLException("Can not get wsdl at: " + uri, e);
        }
        catch (IOException e) {
            throw new WSQMLException("Can not get wsdl at: " + uri, e);
        }
        catch (SchemaException e) {
            throw new WSQMLException("Can not get wsdl at: " + uri, e);
        }
        catch (XmlException e) {
            throw new WSQMLException("Can not get wsdl at: " + uri, e);
        }
        return desc;
    }

    @Override
    public com.ebmwebsourcing.wsstar.qml.api.EquivalentTo readEquivalentTo(URI uri, InputSource input) throws WSQMLException {
        EquivalentToImpl desc = null;
        try {
            XMLReader xmlReader = XMLReaderFactory.createXMLReader();
            SAXSource saxSource = new SAXSource(xmlReader, input);
            JAXBElement dimBinding = WSQMLReaderImpl.getUnMarshaller().unmarshal((Source)saxSource, EquivalentTo.class);
            desc = new EquivalentToImpl(uri, (EquivalentTo)dimBinding.getValue(), this.getFeatures());
        }
        catch (XmlException e) {
            throw new WSQMLException(e);
        }
        catch (SAXException e) {
            throw new WSQMLException(e);
        }
        catch (JAXBException e) {
            throw new WSQMLException(e);
        }
        return desc;
    }

    static {
        try {
            WSQMLJAXBContext.createContext();
            unmarshaller = WSQMLJAXBContext.getJaxbContext().createUnmarshaller();
        }
        catch (JAXBException e) {
            WSQMLException jaxbContextCreationEx = new WSQMLException("Failed to create jaxb context", e);
            unmarshallerCreationEx = new SchemaException("Failed to create the JAXB unmarshaller", (Throwable)((Object)jaxbContextCreationEx));
        }
        catch (SchemaException e) {
            SchemaException jaxbContextCreationEx = new SchemaException("Failed to create jaxb context", (Throwable)e);
            unmarshallerCreationEx = new SchemaException("Failed to create the JAXB unmarshaller", (Throwable)jaxbContextCreationEx);
        }
    }
}

