/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.wsstar.topics.datatypes.api.test;

import com.ebmwebsourcing.wsstar.addressing.datatypes.api.test.WsaUnitTestsUtils;
import com.ebmwebsourcing.wsstar.topics.datatypes.api.WstopConstants;
import com.ebmwebsourcing.wsstar.topics.datatypes.api.abstraction.QueryExpressionType;
import com.ebmwebsourcing.wsstar.topics.datatypes.api.abstraction.TopicNamespaceType;
import com.ebmwebsourcing.wsstar.topics.datatypes.api.abstraction.TopicSetType;
import com.ebmwebsourcing.wsstar.topics.datatypes.api.abstraction.TopicType;
import com.ebmwebsourcing.wsstar.topics.datatypes.api.abstraction.WstopFactory;
import com.ebmwebsourcing.wsstar.topics.datatypes.api.abstraction.WstopReader;
import com.ebmwebsourcing.wsstar.topics.datatypes.api.abstraction.WstopWriter;
import com.ebmwebsourcing.wsstar.topics.datatypes.api.implementor.WstopModelFactory;
import com.ebmwebsourcing.wsstar.topics.datatypes.api.refinedabstraction.RefinedWstopFactory;
import com.ebmwebsourcing.wsstar.topics.datatypes.api.test.WstopUnitTestsUtils;
import com.ebmwebsourcing.wsstar.topics.datatypes.api.utils.WstopException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import javax.xml.namespace.QName;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.junit.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public abstract class AbsWstopTypesUnitTests
extends TestCase {
    protected boolean isDebug = false;
    private WstopFactory factory;
    protected WstopModelFactory modelFactoryImpl;
    private WstopReader reader;
    private WstopWriter writer;

    protected void setUp() throws Exception {
        super.setUp();
        this.initRefinedWstopFactory();
    }

    private static String getFailedMessagePrefix(String specification) {
        return "\nUnit Tests of " + specification + " Model implementation Failed !\n Failure Cause :\n";
    }

    protected abstract void setWstopModelFactory();

    public void initRefinedWstopFactory() {
        if (this.modelFactoryImpl == null) {
            this.setWstopModelFactory();
        }
        AbsWstopTypesUnitTests.assertNotNull((String)(AbsWstopTypesUnitTests.getFailedMessagePrefix("OASIS \"WS-Topics\"") + "the \"WstopModelFactory\" implementation Object has not been set.\n" + "Please provide an instance of \"WstopModelFactory\" implementation class"), (Object)this.modelFactoryImpl);
        if (this.factory == null) {
            this.factory = RefinedWstopFactory.getInstance((WstopModelFactory)this.modelFactoryImpl);
        }
        if (this.reader == null) {
            this.reader = this.factory.getWstopReader();
        }
        if (this.writer == null) {
            this.writer = this.factory.getWstopWriter();
        }
    }

    protected static boolean checkMessagePattern(QueryExpressionType expectedMessagePattern, QueryExpressionType toCheckMessagePattern, boolean isDebug) {
        URI expectedDialect = expectedMessagePattern.getDialect();
        URI toCheckDialect = toCheckMessagePattern.getDialect();
        if (isDebug) {
            System.out.println("[DEBUG] --> toCheckDialect value : " + (toCheckDialect != null ? toCheckDialect.toString() : "null") + "\n[DEBUG] --> expectedDialect value : " + (expectedDialect != null ? expectedDialect.toString() : "null") + "\n");
        }
        Assert.assertTrue((String)(WsaUnitTestsUtils.getFailedMessagePrefix((String)"OASIS \"WS-Topics\"") + "MessageContentPattern dialects are \n" + "\t(-> toCheckDialect value : " + (toCheckDialect != null ? toCheckDialect.toString() : "null") + "\n\t-> expectedDialect value : " + (expectedDialect != null ? expectedDialect.toString() : "null") + ")"), (toCheckDialect == expectedDialect || toCheckDialect != null && toCheckDialect.equals(expectedDialect) ? 1 : 0) != 0);
        String expectedContent = expectedMessagePattern.getContent();
        String toCheckContent = toCheckMessagePattern.getContent();
        if (isDebug) {
            System.out.println("[DEBUG] --> toCheckContent value : " + toCheckContent + "\n[DEBUG] --> expectedContent value : " + expectedContent + "\n");
        }
        Assert.assertTrue((String)(WsaUnitTestsUtils.getFailedMessagePrefix((String)"OASIS \"WS-Topics\"") + "MessageContentPattern contents are \n" + "\t(-> toCheckContent value : " + toCheckContent + "\n\t-> expectedContent value : " + expectedContent + ")"), (toCheckContent == expectedContent || toCheckContent != null && toCheckContent.equals(expectedContent) ? 1 : 0) != 0);
        return true;
    }

    protected static boolean checkTopicType(TopicType expectedTopic, TopicType toCheckTopic, boolean isDebug) {
        String expectedAttrName = expectedTopic.getName();
        String toCheckAttrName = toCheckTopic.getName();
        if (isDebug) {
            System.out.println("[DEBUG] --> toCheckName attribute : " + toCheckAttrName + "\n[DEBUG] --> expectedName attribute : " + expectedAttrName + "\n");
        }
        Assert.assertTrue((String)(WsaUnitTestsUtils.getFailedMessagePrefix((String)"OASIS \"WS-Topics\"") + "Topic names are differents\n" + "\t(-> toCheckName attribute : " + toCheckAttrName + "\n\t-> expectedName attribute : " + expectedAttrName + ")"), (boolean)toCheckAttrName.equals(expectedAttrName));
        boolean expectedFinalAttr = expectedTopic.isFinal();
        boolean toCheckFinalAttr = toCheckTopic.isFinal();
        if (isDebug) {
            System.out.println("[DEBUG] --> toCheckFinal attribute value : " + toCheckFinalAttr + "\n[DEBUG] --> expectedFinal attribute value : " + expectedFinalAttr + "\n");
        }
        Assert.assertTrue((String)(WsaUnitTestsUtils.getFailedMessagePrefix((String)"OASIS \"WS-Topics\"") + "Topic \"final\" attribute values are \n" + "\t(-> toCheckFinal attribute value : " + toCheckFinalAttr + "\n\t-> expectedFinal attribute value : " + expectedFinalAttr + ")"), (toCheckFinalAttr == expectedFinalAttr ? 1 : 0) != 0);
        QueryExpressionType expectedMsgPattern = expectedTopic.getMessagePattern();
        QueryExpressionType toCheckMsgPattern = toCheckTopic.getMessagePattern();
        AbsWstopTypesUnitTests.checkMessagePattern(expectedMsgPattern, toCheckMsgPattern, isDebug);
        List expectedMsgTypes = expectedTopic.getMessageTypes();
        List toCheckMsgTypes = toCheckTopic.getMessageTypes();
        int expectedMsgTypesCount = expectedMsgTypes != null ? expectedMsgTypes.size() : -1;
        Assert.assertTrue((String)(WsaUnitTestsUtils.getFailedMessagePrefix((String)"OASIS \"WS-Topics\"") + "Topics have different messageTypes list content\n" + "\t(-> toCheckMessageTypes attribute list size : " + (toCheckMsgTypes != null ? Integer.valueOf(toCheckMsgTypes.size()) : "none") + "\n\t-> expectedMessageTypes attribute list size : " + (expectedMsgTypesCount == -1 ? "none" : Integer.valueOf(expectedMsgTypesCount)) + ")"), (expectedMsgTypesCount > 0 && toCheckMsgTypes.size() == expectedMsgTypesCount ? 1 : 0) != 0);
        QName expectedMsgTypesItem = null;
        QName toCheckMsgTypesItem = null;
        for (int i = 0; i < expectedMsgTypesCount; ++i) {
            toCheckMsgTypesItem = (QName)toCheckMsgTypes.get(i);
            expectedMsgTypesItem = (QName)expectedMsgTypes.get(i);
            if (isDebug) {
                System.out.println("[DEBUG] --> toCheckMsgType #" + i + " (QName) : " + toCheckMsgTypesItem + "\n[DEBUG] --> expectedMsgType #" + i + " (QName) : " + expectedMsgTypesItem + "\n");
            }
            Assert.assertTrue((String)(WsaUnitTestsUtils.getFailedMessagePrefix((String)"OASIS \"WS-Topics\"") + "MessageType QName are \n" + "\t(-> toCheckMsgType #" + i + " : " + toCheckMsgTypesItem + "\n\t-> expectedMsgType #" + i + " : " + expectedMsgTypesItem + ")"), (boolean)toCheckMsgTypesItem.equals(expectedMsgTypesItem));
        }
        List expectedChildren = expectedTopic.getTopics();
        List toCheckChildren = toCheckTopic.getTopics();
        int expectedChildrenCount = expectedChildren != null ? expectedChildren.size() : -1;
        Assert.assertTrue((String)(WsaUnitTestsUtils.getFailedMessagePrefix((String)"OASIS \"WS-Topics\"") + "Topics have different children list content\n" + "\t(-> toCheckChildren list size : " + (toCheckChildren != null ? Integer.valueOf(toCheckChildren.size()) : "none") + "\n\t-> expectedChildren list size : " + (expectedChildrenCount == -1 ? "none" : Integer.valueOf(expectedChildrenCount)) + ")"), (toCheckChildren.size() == expectedChildrenCount ? 1 : 0) != 0);
        boolean result = true;
        for (int i = 0; i < expectedChildrenCount; ++i) {
            result &= AbsWstopTypesUnitTests.checkTopicType((TopicType)expectedChildren.get(i), (TopicType)toCheckChildren.get(i), isDebug);
        }
        return result;
    }

    protected static boolean checkTopicNamespeceType(TopicNamespaceType expectedTopicNs, TopicNamespaceType toCheckTopicNs, boolean isDebug) {
        URI expectedNamespaceAttr = expectedTopicNs.getNamespace();
        URI toCheckNamespaceAttr = toCheckTopicNs.getNamespace();
        if (isDebug) {
            System.out.println("[DEBUG] --> toCheckNamespace : " + toCheckNamespaceAttr + "\n[DEBUG] --> expectedNamespace  : " + expectedNamespaceAttr + "\n");
        }
        Assert.assertTrue((String)(WsaUnitTestsUtils.getFailedMessagePrefix((String)"OASIS \"WS-Topics\"") + "TopicNamespace \"targetNamespace\" attributes are differents\n" + "\t(-> toCheckNamespace attribute : " + toCheckNamespaceAttr + "\n\t-> expectedNamespace attribute : " + expectedNamespaceAttr + ")"), (boolean)toCheckNamespaceAttr.equals(expectedNamespaceAttr));
        String expectedNameAttr = expectedTopicNs.getName();
        String toCheckNameAttr = toCheckTopicNs.getName();
        if (isDebug) {
            System.out.println("[DEBUG] --> toCheckNameAttr : " + toCheckNameAttr + "\n[DEBUG] --> expectedNameAttr  : " + expectedNameAttr + "\n");
        }
        Assert.assertTrue((String)(WsaUnitTestsUtils.getFailedMessagePrefix((String)"OASIS \"WS-Topics\"") + "TopicNamespace \"name\" attributes are differents\n" + "\t(-> toCheckName attribute : " + toCheckNamespaceAttr + "\n\t-> expectedName attribute : " + expectedNamespaceAttr + ")"), (boolean)toCheckNameAttr.equals(expectedNameAttr));
        boolean expectedFinalAttr = expectedTopicNs.isFinal();
        boolean toCheckFinalAttr = toCheckTopicNs.isFinal();
        if (isDebug) {
            System.out.println("[DEBUG] --> toCheckFinal attribute value : " + toCheckFinalAttr + "\n[DEBUG] --> expectedFinal attribute value : " + expectedFinalAttr + "\n");
        }
        Assert.assertTrue((String)(WsaUnitTestsUtils.getFailedMessagePrefix((String)"OASIS \"WS-Topics\"") + "Topic \"final\" attribute values are \n" + "\t(-> toCheckFinal attribute value : " + toCheckFinalAttr + "\n\t-> expectedFinal attribute value : " + expectedFinalAttr + ")"), (toCheckFinalAttr == expectedFinalAttr ? 1 : 0) != 0);
        List expectedTopics = expectedTopicNs.getTopics();
        List toCheckTopics = toCheckTopicNs.getTopics();
        int expectedTopicsCount = expectedTopics != null ? expectedTopics.size() : -1;
        Assert.assertTrue((String)(WsaUnitTestsUtils.getFailedMessagePrefix((String)"OASIS \"WS-Topics\"") + "Topics have different topics list content\n" + "\t(-> toCheckTopics list size : " + (toCheckTopics != null ? Integer.valueOf(toCheckTopics.size()) : "none") + "\n\t-> expectedTopics list size : " + (expectedTopicsCount == -1 ? "none" : Integer.valueOf(expectedTopicsCount)) + ")"), (toCheckTopics.size() == expectedTopicsCount ? 1 : 0) != 0);
        boolean result = true;
        String expectedParent = null;
        String toCheckParent = null;
        TopicNamespaceType.Topic expectedTopicItem = null;
        TopicNamespaceType.Topic toCheckTopicItem = null;
        for (int i = 0; i < expectedTopicsCount; ++i) {
            expectedTopicItem = (TopicNamespaceType.Topic)expectedTopics.get(i);
            toCheckTopicItem = (TopicNamespaceType.Topic)toCheckTopics.get(i);
            expectedParent = expectedTopicItem.getParent();
            toCheckParent = toCheckTopicItem.getParent();
            if (isDebug) {
                System.out.println("[DEBUG] --> toCheckParentAttr : " + toCheckParent + "\n[DEBUG] --> expectedParentAttr  : " + expectedParent + "\n");
            }
            Assert.assertTrue((String)(WsaUnitTestsUtils.getFailedMessagePrefix((String)"OASIS \"WS-Topics\"") + "Topic \"Parent\" attributes are differents\n" + "\t(-> toCheckParent attribute : " + toCheckParent + "\n\t-> expectedParent attribute : " + expectedParent + ")"), (boolean)toCheckParent.equals(expectedParent));
            result &= AbsWstopTypesUnitTests.checkTopicType((TopicType)expectedTopicItem, (TopicType)toCheckTopicItem, isDebug);
        }
        return result;
    }

    protected static boolean checkTopicSetType(TopicSetType expectedTopicSet, TopicSetType toCheckTopicSet, boolean isDebug) {
        List toCheckTopicSetTrees = toCheckTopicSet.getTopicsTrees();
        List expectedTopicSetTrees = expectedTopicSet.getTopicsTrees();
        int expectedRPValuesCount = expectedTopicSetTrees != null ? expectedTopicSetTrees.size() : -1;
        Assert.assertTrue((String)(WsaUnitTestsUtils.getFailedMessagePrefix((String)"OASIS \"WS-Topics\"") + "TopicSets have different topics trees values\n" + "\t(-> toCheckTrees count : " + (toCheckTopicSetTrees != null ? Integer.valueOf(toCheckTopicSetTrees.size()) : "none") + "\n\t-> expectedTrees count : " + (expectedRPValuesCount == -1 ? "none" : Integer.valueOf(expectedRPValuesCount)) + ")"), (toCheckTopicSetTrees == null && expectedTopicSetTrees == null || toCheckTopicSetTrees.size() == expectedRPValuesCount ? 1 : 0) != 0);
        for (int i = 0; i < expectedRPValuesCount; ++i) {
            String expectedTopicsTreesItemAsString;
            String toCheckTopicsTreesItemAsString = toCheckTopicSetTrees != null ? WsaUnitTestsUtils.formatToComparison((Element)((Element)toCheckTopicSetTrees.get(i))) : null;
            String string = expectedTopicsTreesItemAsString = expectedTopicSetTrees != null ? WsaUnitTestsUtils.formatToComparison((Element)((Element)expectedTopicSetTrees.get(i))) : null;
            if (isDebug) {
                System.out.println("[DEBUG] --> toCheckTopicsTrees : " + toCheckTopicSetTrees + "\n\t(treeAsString = " + toCheckTopicsTreesItemAsString + ")" + "\n[DEBUG] --> expectedTopicsTrees : " + expectedTopicSetTrees + "\n\t(treeAsString = " + expectedTopicsTreesItemAsString + ")\n");
            }
            Assert.assertTrue((String)(WsaUnitTestsUtils.getFailedMessagePrefix((String)"OASIS \"WS-Topics\"") + "TopicsTrees are different \n" + "\t(-> toCheckTopicTree value formatted to comparison is : " + (toCheckTopicSetTrees != null ? toCheckTopicSetTrees : null) + "\n\t(treesAsString = " + toCheckTopicsTreesItemAsString + ")" + "\n\t-> expectedTopicTree value formatted to comparison is : " + (expectedTopicSetTrees != null ? expectedTopicSetTrees : null) + ")" + "\n\t(treesAsString = " + expectedTopicsTreesItemAsString + ")\n"), (toCheckTopicsTreesItemAsString == expectedTopicsTreesItemAsString || expectedTopicsTreesItemAsString != null && toCheckTopicsTreesItemAsString != null && toCheckTopicsTreesItemAsString.equals(expectedTopicsTreesItemAsString) ? 1 : 0) != 0);
        }
        return true;
    }

    @Test
    public final void testCreateWriteAsDOMReadTopicNamespaceType() throws WstopException, URISyntaxException {
        System.out.println("\n\t ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n\t ~~~~~~~ unit test \"Create, Write-to-DOM and read-from-DOM TopicNamespaceType\" ~~~~~~~ \n");
        TopicNamespaceType topicNamespace = this.factory.createTopicNamespaceType(new URI("http://www.ebmwebsourcing.com/wsstar/wsn-producer"));
        topicNamespace.setFinal(true);
        topicNamespace.setName("SampleTopicSpace");
        TopicNamespaceType.Topic topicToAdd = this.factory.createTopicNamespaceTypeTopic("TopicSet");
        topicToAdd.setParent("tns:ResourcePropertiesChanges");
        QName rpValueChangeMsg = new QName("http://docs.oasis-open.org/wrfr/rp-2", "ResourcePropertyValueChangeNotification");
        topicToAdd.addMessageType(rpValueChangeMsg);
        topicToAdd.setFinal(true);
        QueryExpressionType msgPattern = this.factory.createMessagePattern(WstopConstants.XPATH_TOPIC_EXPRESSION_DIALECT_URI);
        msgPattern.setContent("/Notify/NotificationMessage[Message/ResourcePropertyValueChangeNotification]");
        topicToAdd.setMessagePattern(msgPattern);
        topicNamespace.addTopic(topicToAdd);
        Document topicNamespaceAsDOM = this.writer.writeTopicNamespaceTypeAsDOM(topicNamespace);
        try {
            WsaUnitTestsUtils.validateResult((Document)topicNamespaceAsDOM, (String[])WstopUnitTestsUtils.WSTOP_XML_SCHEMAS_PATHS, (String)"OASIS \"WS-Topics\"", TopicNamespaceType.class, (boolean)this.isDebug);
            System.out.println("\t Unit Test Step 1 (\"create\" and \"write to DOM\") : Passed !\n");
        }
        catch (SAXException e) {
            Assert.fail((String)(WsaUnitTestsUtils.getFailedMessagePrefix((String)"OASIS \"WS-Topics\"") + e.getMessage()));
        }
        TopicNamespaceType readTopicNamespace = this.reader.readTopicNamespaceType(topicNamespaceAsDOM);
        AbsWstopTypesUnitTests.checkTopicNamespeceType(topicNamespace, readTopicNamespace, this.isDebug);
        System.out.println("\t Unit Test Step 2 (\"read from DOM\") : Passed !");
        System.out.println("\n\t OK, unit test \"Create, Write-to-DOM and read-from-DOM TopicNamespaceType\" passed !\n\n\t ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n");
    }

    public final void genericWriteAsDOMReadTopicSetType(TopicSetType topicSet) throws WstopException {
        Document topicSetAsDOM = this.writer.writeTopicSetTypeAsDOM(topicSet);
        try {
            WsaUnitTestsUtils.validateResult((Document)topicSetAsDOM, (String[])WstopUnitTestsUtils.WSTOP_XML_SCHEMAS_PATHS, (String)"OASIS \"WS-Topics\"", TopicSetType.class, (boolean)this.isDebug);
            System.out.println("\t Unit Test Step 1 (\"create\" and \"write to DOM\") : Passed !\n");
        }
        catch (SAXException e) {
            Assert.fail((String)(WsaUnitTestsUtils.getFailedMessagePrefix((String)"OASIS \"WS-Topics\"") + e.getMessage()));
        }
        TopicSetType readTopicSet = this.reader.readTopicSetType(topicSetAsDOM);
        AbsWstopTypesUnitTests.checkTopicSetType(topicSet, readTopicSet, this.isDebug);
        System.out.println("\t Unit Test Step 2 (\"read from DOM\") : Passed !");
    }

    @Test
    public final void testCreateWriteAsDOMReadTopicSetType() throws WstopException {
        System.out.println("\n\t ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n\t ~~~~~~~ unit test \"Create, Write-to-DOM and read-from-DOM TopicSetType\" ~~~~~~~ \n");
        TopicSetType topicSet = this.factory.createTopicSetType();
        List<Element> topicsTrees = WstopUnitTestsUtils.createDefaultTopicTrees();
        for (Element treeItem : topicsTrees) {
            topicSet.addTopicsTree(treeItem);
        }
        this.genericWriteAsDOMReadTopicSetType(topicSet);
        System.out.println("\n\t OK, unit test \"Create, Write-to-DOM and read-from-DOM TopicSetType\" passed !\n\n\t ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n");
    }

    @Test
    public final void testReadFromFSWriteAsDOMReadTopicSetType() throws WstopException {
        System.out.println("\n\t ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n\t ~~~~~~~ unit test \"Read from file, Write-to-DOM and read-from-DOM TopicSetType\" ~~~~~~~ \n");
        InputStream topicSetFromAsStream = AbsWstopTypesUnitTests.class.getResourceAsStream("/SupportedTopicsSet.xml");
        TopicSetType topicSet = this.reader.readTopicSetType(new InputSource(topicSetFromAsStream));
        this.genericWriteAsDOMReadTopicSetType(topicSet);
        System.out.println("\n\t OK, unit test \"Read from file, Write-to-DOM and read-from-DOM TopicSetType\" passed !\n\n\t ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n");
    }
}

