/*
 * Decompiled with CFR 0.152.
 */
package org.jeinnov.jeitime.api.service.collaborateur;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.hibernate.Transaction;
import org.hibernate.classic.Session;
import org.jeinnov.jeitime.api.service.collaborateur.CollaborateurException;
import org.jeinnov.jeitime.api.service.collaborateur.ResultTransformerCollaborateur;
import org.jeinnov.jeitime.api.to.collaborateur.CollegeTO;
import org.jeinnov.jeitime.persistence.bo.collaborateur.CollegeP;
import org.jeinnov.jeitime.persistence.dao.collaborateur.CollegeDAO;
import org.jeinnov.jeitime.utils.HibernateUtil;

public class CollegeManager {
    private final Logger logger = Logger.getLogger(this.getClass());
    private CollegeDAO collegeDAO = CollegeDAO.getInstance();
    private ResultTransformerCollaborateur resultTransformer = new ResultTransformerCollaborateur();
    private static CollegeManager manager;

    public static CollegeManager getInstance() {
        if (manager == null) {
            manager = new CollegeManager();
        }
        return manager;
    }

    public CollegeTO get(int id) throws CollaborateurException {
        CollegeTO college = new CollegeTO();
        if (id == 0) {
            throw new CollaborateurException("Attention, aucun coll\u00e8ge n'a \u00e9t\u00e9 s\u00e9lectionn\u00e9 !");
        }
        Session session = HibernateUtil.getSessionFactory().getCurrentSession();
        Transaction tx = session.beginTransaction();
        try {
            CollegeP collegeP = (CollegeP)this.collegeDAO.find((Serializable)Integer.valueOf(id));
            if (collegeP == null || collegeP.getIdCollege() == 0) {
                throw new CollaborateurException("Le coll\u00e8ge s\u00e9lectionn\u00e9 n'existe pas dans la base.");
            }
            college = this.resultTransformer.toCollegeTO(collegeP);
            tx.commit();
        }
        catch (RuntimeException e) {
            tx.rollback();
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        return college;
    }

    public List<CollegeTO> getAll() {
        ArrayList<CollegeTO> listCollegeTO = new ArrayList<CollegeTO>();
        Session session = HibernateUtil.getSessionFactory().getCurrentSession();
        Transaction tx = session.beginTransaction();
        try {
            List listCollegeP = this.collegeDAO.getAll();
            if (listCollegeP != null) {
                for (CollegeP cP : listCollegeP) {
                    CollegeTO cTO = this.resultTransformer.toCollegeTO(cP);
                    listCollegeTO.add(cTO);
                }
            }
            tx.commit();
        }
        catch (RuntimeException e) {
            tx.rollback();
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        return listCollegeTO;
    }

    public int saveOrUpdate(CollegeTO collegeTO) throws CollaborateurException {
        if (collegeTO == null) {
            throw new CollaborateurException("Vous devez sp\u00e9cifier un coll\u00e8ge avant sa sauvegarde !");
        }
        if (collegeTO.getNomCollege() == null) {
            throw new CollaborateurException("vous devez sp\u00e9cifier un nom au coll\u00e8ge avant sa sauvegarde !");
        }
        Session session = HibernateUtil.getSessionFactory().getCurrentSession();
        Transaction tx = session.beginTransaction();
        CollegeP cP = new CollegeP();
        try {
            cP = this.collegeDAO.getByName(collegeTO.getNomCollege());
            this.verificationAvantEnregistrement(collegeTO, cP);
            if (cP == null || cP.getIdCollege() == 0) {
                cP = new CollegeP();
            }
            this.resultTransformer.toCollegeP(collegeTO, cP);
            this.collegeDAO.save((Object)cP);
            tx.commit();
        }
        catch (RuntimeException e) {
            tx.rollback();
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        return cP.getIdCollege();
    }

    public void delete(int id) throws CollaborateurException {
        if (id == 0) {
            throw new CollaborateurException("Attention vous devez sp\u00e9cifier un coll\u00e8ge avant sa suppression");
        }
        Session session = HibernateUtil.getSessionFactory().getCurrentSession();
        Transaction tx = session.beginTransaction();
        try {
            CollegeP cP = (CollegeP)this.collegeDAO.find((Serializable)Integer.valueOf(id));
            if (cP == null || cP.getIdCollege() == 0) {
                throw new CollaborateurException("Le coll\u00e8ge s\u00e9lectionn\u00e9 n'existe pas dans la base.");
            }
            this.collegeDAO.remove((Object)cP);
            tx.commit();
        }
        catch (RuntimeException e) {
            tx.rollback();
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    public String[] createListSelectionHeure(int idColl) throws CollaborateurException {
        if (idColl == 0) {
            throw new CollaborateurException("Attention, la valeur de l'identifiant du coll\u00e8ge ne peut pas \u00eatre nulle");
        }
        String[] tablListSaisie = null;
        Session session = HibernateUtil.getSessionFactory().getCurrentSession();
        Transaction tx = session.beginTransaction();
        try {
            CollegeP collegeP = (CollegeP)this.collegeDAO.find((Serializable)Integer.valueOf(idColl));
            String listS = collegeP.getListSaisie();
            tablListSaisie = listS != null ? listS.split("/") : null;
            tx.commit();
        }
        catch (RuntimeException e) {
            tx.rollback();
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        return tablListSaisie;
    }

    private void verificationAvantEnregistrement(CollegeTO c, CollegeP cP) throws CollaborateurException {
        if (cP != null) {
            if (c.getIdCollege() == 0) {
                throw new CollaborateurException("Attention, un coll\u00e8ge avec ce nom existe d\u00e9j\u00e0 !");
            }
            if (cP.getIdCollege() != c.getIdCollege()) {
                throw new CollaborateurException("Attention, un coll\u00e8ge avec ce nom existe d\u00e9j\u00e0 !");
            }
        }
    }
}

