/*
 * Decompiled with CFR 0.152.
 */
package org.jeinnov.jeitime.api.service.collaborateur;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.hibernate.Transaction;
import org.hibernate.classic.Session;
import org.jeinnov.jeitime.api.service.collaborateur.CollaborateurException;
import org.jeinnov.jeitime.api.to.collaborateur.EquipeTO;
import org.jeinnov.jeitime.persistence.bo.collaborateur.EquipeP;
import org.jeinnov.jeitime.persistence.dao.collaborateur.EquipeDAO;
import org.jeinnov.jeitime.utils.HibernateUtil;

public class EquipeManager {
    private final Logger logger = Logger.getLogger(this.getClass());
    private EquipeDAO equipeDAO = EquipeDAO.getInstance();
    private static EquipeManager manager;

    public static EquipeManager getInstance() {
        if (manager == null) {
            manager = new EquipeManager();
        }
        return manager;
    }

    public EquipeTO get(int id) throws CollaborateurException {
        if (id == 0) {
            throw new CollaborateurException("Aucune \u00e9quipe n'est sp\u00e9cifi\u00e9e !");
        }
        EquipeTO equipeTO = new EquipeTO();
        EquipeP equipe = new EquipeP();
        Session session = HibernateUtil.getSessionFactory().getCurrentSession();
        Transaction tx = session.beginTransaction();
        try {
            equipe = (EquipeP)this.equipeDAO.find((Serializable)Integer.valueOf(id));
            tx.commit();
        }
        catch (RuntimeException e) {
            tx.rollback();
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        if (equipe == null) {
            throw new CollaborateurException("L'\u00e9quipe s\u00e9lectionn\u00e9 n'existe pas dans la base.");
        }
        equipeTO.setIdEquip(equipe.getIdEquip());
        equipeTO.setNomEquip(equipe.getNomEquip());
        equipeTO.setFonctionEquip(equipe.getFonctionEquip());
        return equipeTO;
    }

    public List<EquipeTO> getAll() {
        ArrayList<EquipeTO> allEquip = new ArrayList<EquipeTO>();
        List allEquipP = new ArrayList();
        Session session = HibernateUtil.getSessionFactory().getCurrentSession();
        Transaction tx = session.beginTransaction();
        try {
            allEquipP = this.equipeDAO.getAll();
            tx.commit();
        }
        catch (RuntimeException e) {
            tx.rollback();
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        if (allEquipP != null) {
            for (EquipeP eq : allEquipP) {
                EquipeTO eqTO = new EquipeTO();
                eqTO.setIdEquip(eq.getIdEquip());
                eqTO.setFonctionEquip(eq.getFonctionEquip());
                eqTO.setNomEquip(eq.getNomEquip());
                allEquip.add(eqTO);
            }
        }
        return allEquip;
    }

    public int saveOrUpdate(EquipeTO eqTO) throws CollaborateurException {
        Session session = HibernateUtil.getSessionFactory().getCurrentSession();
        Transaction tx = session.beginTransaction();
        if (eqTO == null) {
            throw new CollaborateurException("vous devez sp\u00e9cifier une \u00e9quipe avant sa sauvegarde !");
        }
        if (eqTO.getNomEquip() == null) {
            throw new CollaborateurException("vous devez sp\u00e9cifier un nom \u00e0 l'\u00e9quipe avant sa sauvegarde !");
        }
        EquipeP eq = new EquipeP();
        try {
            String nom = eqTO.getNomEquip();
            eq = this.equipeDAO.getByName(nom);
            this.verificationAvantEnregistrement(eqTO, eq);
            if (eq == null || eq.getIdEquip() == 0) {
                eq = new EquipeP();
            }
            eq.setIdEquip(eqTO.getIdEquip());
            eq.setNomEquip(eqTO.getNomEquip());
            eq.setFonctionEquip(eqTO.getFonctionEquip());
            this.equipeDAO.save((Object)eq);
            tx.commit();
        }
        catch (RuntimeException e) {
            tx.rollback();
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        return eq.getIdEquip();
    }

    public void deleteEquipe(int id) throws CollaborateurException {
        if (id == 0) {
            throw new CollaborateurException("Aucune \u00e9quipe n'est sp\u00e9cifi\u00e9e !");
        }
        Session session = HibernateUtil.getSessionFactory().getCurrentSession();
        Transaction tx = session.beginTransaction();
        try {
            EquipeP eP = (EquipeP)this.equipeDAO.find((Serializable)Integer.valueOf(id));
            if (eP == null || eP.getIdEquip() == 0) {
                throw new CollaborateurException("L'\u00e9quipe s\u00e9lectionn\u00e9 n'existe pas dans la base.");
            }
            this.equipeDAO.remove((Object)eP);
            tx.commit();
        }
        catch (RuntimeException e) {
            tx.rollback();
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    public boolean isInCollaborateur(int id) throws CollaborateurException {
        boolean verif = true;
        if (id == 0) {
            throw new CollaborateurException("Aucune \u00e9quipe n'est sp\u00e9cifi\u00e9e !");
        }
        Session session = HibernateUtil.getSessionFactory().getCurrentSession();
        Transaction tx = session.beginTransaction();
        try {
            verif = this.equipeDAO.isInCollaborateur(id, (org.hibernate.Session)session);
            tx.commit();
        }
        catch (RuntimeException e) {
            verif = true;
            tx.rollback();
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        return verif;
    }

    private void verificationAvantEnregistrement(EquipeTO e, EquipeP eP) throws CollaborateurException {
        if (eP != null && eP.getIdEquip() != e.getIdEquip()) {
            throw new CollaborateurException("Attention, une \u00e9quipe avec ce nom existe d\u00e9j\u00e0 !");
        }
    }
}

