/*
 * Decompiled with CFR 0.152.
 */
package org.jeinnov.jeitime.api.service.projet;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.hibernate.Transaction;
import org.hibernate.classic.Session;
import org.jeinnov.jeitime.api.service.projet.ProjetException;
import org.jeinnov.jeitime.api.to.projet.ClientPartTO;
import org.jeinnov.jeitime.persistence.bo.projet.ClientPartP;
import org.jeinnov.jeitime.persistence.dao.projet.ClientPartDAO;
import org.jeinnov.jeitime.utils.HibernateUtil;

public class ClientPartManager {
    private final Logger logger = Logger.getLogger(this.getClass());
    private ClientPartDAO clientPartDAO = ClientPartDAO.getInstance();
    private static ClientPartManager manager;

    public static ClientPartManager getInstance() {
        if (manager == null) {
            manager = new ClientPartManager();
        }
        return manager;
    }

    public ClientPartTO get(int id) throws ProjetException {
        if (id == 0) {
            throw new ProjetException("Attention aucun client ou partenaire n'est sp\u00e9cifi\u00e9 !");
        }
        ClientPartTO cPTO = new ClientPartTO();
        ClientPartP cPP = new ClientPartP();
        Session session = HibernateUtil.getSessionFactory().getCurrentSession();
        Transaction tx = session.beginTransaction();
        try {
            cPP = (ClientPartP)this.clientPartDAO.find((Serializable)Integer.valueOf(id));
            tx.commit();
        }
        catch (RuntimeException e) {
            tx.rollback();
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        if (cPP == null) {
            throw new ProjetException("Aucun client ou partenaire avec cet identifiant est enregistr\u00e9 dans la base");
        }
        cPTO.setIdClientPart(cPP.getIdClientPart());
        cPTO.setNomClientPart(cPP.getNomClientPart());
        cPTO.setCommentaire(cPP.getCommentaire());
        cPTO.setNomContact(cPP.getNomContact());
        cPTO.setNomService(cPP.getNomService());
        return cPTO;
    }

    public List<ClientPartTO> getAll() {
        ArrayList<ClientPartTO> listCPTO = new ArrayList<ClientPartTO>();
        List listCPP = new ArrayList();
        Session session = HibernateUtil.getSessionFactory().getCurrentSession();
        Transaction tx = session.beginTransaction();
        try {
            listCPP = this.clientPartDAO.getAll();
            tx.commit();
        }
        catch (RuntimeException e) {
            tx.rollback();
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        if (listCPP != null) {
            for (ClientPartP cPP : listCPP) {
                ClientPartTO cPTO = new ClientPartTO();
                cPTO.setIdClientPart(cPP.getIdClientPart());
                cPTO.setNomClientPart(cPP.getNomClientPart());
                cPTO.setCommentaire(cPP.getCommentaire());
                cPTO.setNomContact(cPP.getNomContact());
                cPTO.setNomService(cPP.getNomService());
                listCPTO.add(cPTO);
            }
        }
        return listCPTO;
    }

    public int saveOrUpdate(ClientPartTO cPTO) throws ProjetException {
        if (cPTO == null) {
            throw new ProjetException("Aucun client ou partenaire n'a \u00e9t\u00e9 cr\u00e9\u00e9 ");
        }
        if (cPTO.getNomClientPart() == null) {
            throw new ProjetException("Attention vous devez donn\u00e9 un nom \u00e0 votre client/partenaire !");
        }
        ClientPartP cPP = new ClientPartP();
        cPP.setIdClientPart(cPTO.getIdClientPart());
        cPP.setNomClientPart(cPTO.getNomClientPart());
        cPP.setCommentaire(cPTO.getCommentaire());
        cPP.setNomContact(cPTO.getNomContact());
        cPP.setNomService(cPTO.getNomService());
        Session session = HibernateUtil.getSessionFactory().getCurrentSession();
        Transaction tx = session.beginTransaction();
        try {
            this.clientPartDAO.save((Object)cPP);
            tx.commit();
        }
        catch (RuntimeException e) {
            tx.rollback();
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        int id = cPP.getIdClientPart();
        return id;
    }

    public void delete(int id) throws ProjetException {
        if (id == 0) {
            throw new ProjetException("Aucun client ou partenaire n'a \u00e9t\u00e9 cr\u00e9\u00e9 ");
        }
        Session session = HibernateUtil.getSessionFactory().getCurrentSession();
        Transaction tx = session.beginTransaction();
        try {
            ClientPartP cPP = (ClientPartP)this.clientPartDAO.find((Serializable)Integer.valueOf(id));
            if (cPP == null || cPP.getIdClientPart() == 0) {
                throw new ProjetException("Le client/partenaire s\u00e9lectionn\u00e9 n'existe pas dans la base de donn\u00e9es.");
            }
            this.clientPartDAO.remove((Object)cPP);
            tx.commit();
        }
        catch (RuntimeException e) {
            tx.rollback();
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    public boolean isInProject(int id) throws ProjetException {
        boolean verif = true;
        if (id == 0) {
            throw new ProjetException("Attention aucun client ou partenaire n'est sp\u00e9cifi\u00e9 !");
        }
        Session session = HibernateUtil.getSessionFactory().getCurrentSession();
        Transaction tx = session.beginTransaction();
        try {
            verif = this.clientPartDAO.isInProject(id, (org.hibernate.Session)session);
            tx.commit();
        }
        catch (RuntimeException e) {
            verif = true;
            tx.rollback();
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        return verif;
    }
}

