/*
 * Decompiled with CFR 0.152.
 */
package org.jeinnov.jeitime.persistence.bo.projet;

import java.io.Serializable;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.jeinnov.jeitime.persistence.bo.projet.DomaineP;
import org.jeinnov.jeitime.persistence.bo.projet.TacheP;
import org.jeinnov.jeitime.persistence.bo.projet.ThematiqueP;
import org.jeinnov.jeitime.persistence.bo.projet.TypeProjetP;

@Entity
@Table(name="PROJET")
@NamedQueries(value={@NamedQuery(name="ProjetP.getListProjetDom", query="select p from ProjetP p where p.domaine = :iddomaine"), @NamedQuery(name="ProjetP.getListProjetThema", query="select p from ProjetP p where p.thematique = :idthematique"), @NamedQuery(name="ProjetP.getListProjetTypeP", query="select p from ProjetP p where p.typeProjet = :idTypeP")})
public class ProjetP
implements Serializable {
    private static final long serialVersionUID = -1188347660195664024L;
    private int idProjet;
    private String nomProjet;
    private Date dateDeb;
    private Date dateFin;
    private Date dateCloture;
    private Date dateFermeture;
    private float budgeprevu;
    private float tpsprevu;
    private TypeProjetP typeProjet;
    private DomaineP domaine;
    private ThematiqueP thematique;
    private Set<TacheP> tache;
    private Set<ProjetP> projets;
    private ProjetP projet;

    public ProjetP() {
        this.tache = new HashSet(0);
        this.projets = new HashSet();
    }

    public ProjetP(int idProjet) {
        this.idProjet = idProjet;
    }

    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Column(name="IDPROJET", unique=true, nullable=false)
    public int getIdProjet() {
        return this.idProjet;
    }

    public void setIdProjet(int idProjet) {
        this.idProjet = idProjet;
    }

    @Column(name="NOMPROJET", nullable=false)
    public String getNomProjet() {
        return this.nomProjet;
    }

    public void setNomProjet(String nomProjet) {
        this.nomProjet = nomProjet;
    }

    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="DATEDEBUT", length=6, nullable=false)
    public Date getDateDeb() {
        return this.dateDeb;
    }

    public void setDateDeb(Date dateDeb) {
        this.dateDeb = dateDeb;
    }

    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="DATEFIN", length=6)
    public Date getDateFin() {
        return this.dateFin;
    }

    public void setDateFin(Date dateFin) {
        this.dateFin = dateFin;
    }

    @Column(name="BUDGET")
    public float getBudgeprevu() {
        return this.budgeprevu;
    }

    public void setBudgeprevu(float budgeprevu) {
        this.budgeprevu = budgeprevu;
    }

    @Column(name="TPSPREVU")
    public float getTpsprevu() {
        return this.tpsprevu;
    }

    public void setTpsprevu(float tpsprevu) {
        this.tpsprevu = tpsprevu;
    }

    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="DATECLOTURE", length=6)
    public Date getDateCloture() {
        return this.dateCloture;
    }

    public void setDateCloture(Date dateCloture) {
        this.dateCloture = dateCloture;
    }

    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="DATEFERMETURE", length=6)
    public Date getDateFermeture() {
        return this.dateFermeture;
    }

    public void setDateFermeture(Date dateFermeture) {
        this.dateFermeture = dateFermeture;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="IDTYPEPROJET", nullable=false)
    public TypeProjetP getTypeProjet() {
        return this.typeProjet;
    }

    public void setTypeProjet(TypeProjetP typeProjet) {
        this.typeProjet = typeProjet;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="IDDOMAINE")
    public DomaineP getDomaine() {
        return this.domaine;
    }

    public void setDomaine(DomaineP domaine) {
        this.domaine = domaine;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="IDTHEMATIQUE")
    public ThematiqueP getThematique() {
        return this.thematique;
    }

    public void setThematique(ThematiqueP thematique) {
        this.thematique = thematique;
    }

    @OneToMany(cascade={CascadeType.ALL}, fetch=FetchType.LAZY, mappedBy="projet")
    public Set<TacheP> getTache() {
        return this.tache;
    }

    public void setTache(Set<TacheP> tache) {
        this.tache = tache;
    }

    @OneToMany(fetch=FetchType.LAZY)
    public Set<ProjetP> getProjets() {
        return this.projets;
    }

    public void setProjets(Set<ProjetP> projets) {
        this.projets = projets;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="SOUSPROJET")
    public ProjetP getProjet() {
        return this.projet;
    }

    public void setProjet(ProjetP projet) {
        this.projet = projet;
    }
}

