/*
 * Decompiled with CFR 0.152.
 */
package org.jeinnov.jeitime.ui.bilan;

import java.text.DateFormat;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import org.jeinnov.jeitime.api.service.bilan.BilanException;
import org.jeinnov.jeitime.api.service.bilan.ThematiqueBilanManager;
import org.jeinnov.jeitime.api.service.collaborateur.CollaborateurManager;
import org.jeinnov.jeitime.api.service.projet.ThematiqueManager;
import org.jeinnov.jeitime.api.to.bilan.RecapProjetTO;
import org.jeinnov.jeitime.api.to.bilan.SousTotal;
import org.jeinnov.jeitime.api.to.bilan.Total;
import org.jeinnov.jeitime.api.to.collaborateur.CollaborateurTO;
import org.jeinnov.jeitime.api.to.projet.ProjetTO;
import org.jeinnov.jeitime.api.to.projet.TacheTO;
import org.jeinnov.jeitime.api.to.projet.ThematiqueTO;
import org.ow2.opensuit.core.error.IError;
import org.ow2.opensuit.core.error.NonLocalizedError;
import org.ow2.opensuit.core.validation.LocalizedValidationError;
import org.ow2.opensuit.core.validation.ValidationError;
import org.ow2.opensuit.core.validation.ValidationErrors;

public class RecapThemaUIBean {
    private ThematiqueBilanManager manager = ThematiqueBilanManager.getInstance();
    private Date dateDeb;
    private String dateD;
    private Date dateFin;
    private String dateF;
    private int[] selectedThema;
    private List<ThematiqueTO> allThema = new ArrayList();
    private List<CollaborateurTO> collaborateurs = new ArrayList();
    private List<Object> items = new ArrayList();
    private List<RecapProjetTO> listRecap = new ArrayList();
    private boolean voirThema;
    private boolean voirTablThema = false;
    private boolean voirDate;

    public void load() {
        this.allThema = ThematiqueManager.getInstance().getAll();
        this.voirDate = true;
    }

    public void envoyer() {
        this.voirThema = true;
        this.voirTablThema = false;
    }

    public void reset() {
        this.voirDate = true;
        this.voirThema = true;
        this.voirTablThema = false;
        this.selectedThema = null;
    }

    public void voirTableauThema() throws IError {
        Locale locale = Locale.FRANCE;
        DateFormat dateFormat = DateFormat.getDateInstance(3, locale);
        this.dateD = dateFormat.format(this.dateDeb);
        this.dateF = dateFormat.format(this.dateFin);
        this.collaborateurs = CollaborateurManager.getInstance().getAll();
        this.items = new ArrayList();
        try {
            this.items = this.manager.listTacheThema(this.selectedThema);
        }
        catch (BilanException e) {
            NonLocalizedError error = new NonLocalizedError("Attention, aucune th\u00e9matique n'est associ\u00e9e", e.getMessage(), (Throwable)e);
            error.setType((short)0);
            throw error;
        }
        this.listRecap = new ArrayList();
        try {
            this.listRecap = this.manager.creerListRecapProjetThematique(this.selectedThema, this.dateDeb, this.dateFin);
        }
        catch (BilanException e) {
            NonLocalizedError error = new NonLocalizedError("Attention, aucune th\u00e9matique n'est associ\u00e9e", e.getMessage(), (Throwable)e);
            error.setType((short)0);
            throw error;
        }
        this.voirThema = false;
        this.voirTablThema = true;
        this.voirDate = false;
    }

    public String getHtmlName(Object item) {
        if (item instanceof String) {
            return "\\html\\<span class=titleTable>" + item + "</span>";
        }
        if (item instanceof Integer) {
            return "Total de la Th\u00e9matique";
        }
        if (item instanceof ProjetTO) {
            return "\\html\\<span class=sousTitleTable>" + ((ProjetTO)item).getNomProjet() + "</span>";
        }
        if (item instanceof SousTotal) {
            return ((SousTotal)item).getNomSousTotal();
        }
        if (item instanceof Total) {
            return "Total du Projet";
        }
        return ((TacheTO)item).getNomtache().getNomTache();
    }

    public String getValue(Object item, CollaborateurTO collab) {
        if (item instanceof String) {
            return null;
        }
        if (item instanceof ProjetTO) {
            return null;
        }
        if (item instanceof Integer) {
            return this.itemsInstanceOfInteger(item, collab);
        }
        if (item instanceof SousTotal) {
            return this.itemsInstanceOfSousTotal(item, collab);
        }
        if (item instanceof Total) {
            return this.itemsInstanceOfTotal(item, collab);
        }
        return this.itemsInstanceOfTacheTO(item, collab);
    }

    public void validate() throws ValidationErrors {
        ValidationErrors errors = new ValidationErrors();
        if (this.dateDeb != null && this.dateFin != null && this.dateFin.before(this.dateDeb)) {
            errors.addItemError("recapBeanThema.dateFin", (ValidationError)new LocalizedValidationError("validation.date"));
        }
        if (errors.hasErrors()) {
            throw errors;
        }
    }

    private String itemsInstanceOfInteger(Object item, CollaborateurTO collab) {
        String nb = "0";
        int idP = (Integer)item;
        double nbht = 0.0;
        for (int i = 0; i < this.listRecap.size(); ++i) {
            if (((RecapProjetTO)this.listRecap.get(i)).getCollab().getIdColl() != collab.getIdColl() || ((RecapProjetTO)this.listRecap.get(i)).getNomProjet().getThematique().getIdThema() != idP) continue;
            nbht = ((RecapProjetTO)this.listRecap.get(i)).getNbheure() + nbht;
            DecimalFormat df = new DecimalFormat();
            df.setMaximumFractionDigits(2);
            df.setMinimumFractionDigits(2);
            df.setDecimalSeparatorAlwaysShown(true);
            nb = df.format(nbht);
        }
        return nb;
    }

    private String itemsInstanceOfSousTotal(Object item, CollaborateurTO collab) {
        String nb = "0";
        int idP = ((SousTotal)item).getIdProjet();
        boolean rd = ((SousTotal)item).isRd();
        double nbht = 0.0;
        for (int i = 0; i < this.listRecap.size(); ++i) {
            if (((RecapProjetTO)this.listRecap.get(i)).getCollab().getIdColl() != collab.getIdColl() || ((RecapProjetTO)this.listRecap.get(i)).getNomProjet().getIdProjet() != idP || ((RecapProjetTO)this.listRecap.get(i)).getTache().isEligible() != rd) continue;
            nbht = ((RecapProjetTO)this.listRecap.get(i)).getNbheure() + nbht;
            DecimalFormat df = new DecimalFormat();
            df.setMaximumFractionDigits(2);
            df.setMinimumFractionDigits(2);
            df.setDecimalSeparatorAlwaysShown(true);
            nb = df.format(nbht);
        }
        return nb;
    }

    private String itemsInstanceOfTotal(Object item, CollaborateurTO collab) {
        String nb = "0";
        int idP = ((Total)item).getIdProjet();
        double nbht = 0.0;
        for (int i = 0; i < this.listRecap.size(); ++i) {
            if (((RecapProjetTO)this.listRecap.get(i)).getCollab().getIdColl() != collab.getIdColl() || ((RecapProjetTO)this.listRecap.get(i)).getNomProjet().getIdProjet() != idP) continue;
            nbht = ((RecapProjetTO)this.listRecap.get(i)).getNbheure() + nbht;
            DecimalFormat df = new DecimalFormat();
            df.setMaximumFractionDigits(2);
            df.setMinimumFractionDigits(2);
            df.setDecimalSeparatorAlwaysShown(true);
            nb = df.format(nbht);
        }
        return nb;
    }

    private String itemsInstanceOfTacheTO(Object item, CollaborateurTO collab) {
        int idT = ((TacheTO)item).getIdTache();
        int idCo = collab.getIdColl();
        String nb = "";
        for (int i = 0; i < this.listRecap.size(); ++i) {
            if (idT != ((RecapProjetTO)this.listRecap.get(i)).getTache().getIdTache() || idCo != ((RecapProjetTO)this.listRecap.get(i)).getCollab().getIdColl()) continue;
            double nbh = ((RecapProjetTO)this.listRecap.get(i)).getNbheure();
            DecimalFormat df = new DecimalFormat();
            df.setMaximumFractionDigits(2);
            df.setMinimumFractionDigits(2);
            df.setDecimalSeparatorAlwaysShown(true);
            nb = df.format(nbh);
        }
        return nb;
    }

    public String getTotal(Object item) {
        double nbh = 0.0;
        String total = "0";
        if (item instanceof String) {
            return null;
        }
        if (item instanceof ProjetTO) {
            return null;
        }
        if (item instanceof Integer) {
            total = this.totalInstanceOfInteger(item, nbh);
            return total;
        }
        if (item instanceof SousTotal) {
            total = this.totalInstanceOfSousTotal(item);
            return total;
        }
        if (item instanceof Total) {
            total = this.totalInstanceOfTotal(item);
            return total;
        }
        total = this.totalInstanceOfTacheTO(item, nbh);
        return total;
    }

    private String totalInstanceOfInteger(Object item, double nbh) {
        for (int i = 0; i < this.listRecap.size(); ++i) {
            int idP = (Integer)item;
            if (idP != ((RecapProjetTO)this.listRecap.get(i)).getNomProjet().getThematique().getIdThema()) continue;
            nbh = ((RecapProjetTO)this.listRecap.get(i)).getNbheure() + nbh;
        }
        DecimalFormat df = new DecimalFormat();
        df.setMaximumFractionDigits(2);
        df.setMinimumFractionDigits(2);
        df.setDecimalSeparatorAlwaysShown(true);
        String total = df.format(nbh);
        return total;
    }

    private String totalInstanceOfSousTotal(Object item) {
        String totalTmp = null;
        int idP = ((SousTotal)item).getIdProjet();
        boolean rd = ((SousTotal)item).isRd();
        double nbht = 0.0;
        for (int i = 0; i < this.listRecap.size(); ++i) {
            if (((RecapProjetTO)this.listRecap.get(i)).getNomProjet().getIdProjet() != idP || ((RecapProjetTO)this.listRecap.get(i)).getTache().isEligible() != rd) continue;
            nbht = ((RecapProjetTO)this.listRecap.get(i)).getNbheure() + nbht;
            DecimalFormat df = new DecimalFormat();
            df.setMaximumFractionDigits(2);
            df.setMinimumFractionDigits(2);
            df.setDecimalSeparatorAlwaysShown(true);
            totalTmp = df.format(nbht);
        }
        return totalTmp;
    }

    private String totalInstanceOfTotal(Object item) {
        String totalTmp = null;
        int idP = ((Total)item).getIdProjet();
        double nbht = 0.0;
        for (int i = 0; i < this.listRecap.size(); ++i) {
            if (((RecapProjetTO)this.listRecap.get(i)).getNomProjet().getIdProjet() != idP) continue;
            nbht = ((RecapProjetTO)this.listRecap.get(i)).getNbheure() + nbht;
            DecimalFormat df = new DecimalFormat();
            df.setMaximumFractionDigits(2);
            df.setMinimumFractionDigits(2);
            df.setDecimalSeparatorAlwaysShown(true);
            totalTmp = df.format(nbht);
        }
        return totalTmp;
    }

    private String totalInstanceOfTacheTO(Object item, double nbh) {
        int idT = ((TacheTO)item).getIdTache();
        for (int i = 0; i < this.listRecap.size(); ++i) {
            if (idT != ((RecapProjetTO)this.listRecap.get(i)).getTache().getIdTache()) continue;
            nbh = ((RecapProjetTO)this.listRecap.get(i)).getNbheure() + nbh;
        }
        DecimalFormat df = new DecimalFormat();
        df.setMaximumFractionDigits(2);
        df.setMinimumFractionDigits(2);
        df.setDecimalSeparatorAlwaysShown(true);
        return df.format(nbh);
    }

    public void selectAllThema() {
        this.selectedThema = new int[this.allThema.size()];
        for (int i = 0; i < this.allThema.size(); ++i) {
            this.selectedThema[i] = ((ThematiqueTO)this.allThema.get(i)).getIdThema();
        }
    }

    public void deSelectAllThema() {
        this.selectedThema = null;
    }

    public Date getDateDeb() {
        return this.dateDeb;
    }

    public void setDateDeb(Date dateDeb) {
        this.dateDeb = dateDeb;
    }

    public String getDateD() {
        return this.dateD;
    }

    public void setDateD(String dateD) {
        this.dateD = dateD;
    }

    public Date getDateFin() {
        return this.dateFin;
    }

    public void setDateFin(Date dateFin) {
        this.dateFin = dateFin;
    }

    public String getDateF() {
        return this.dateF;
    }

    public void setDateF(String dateF) {
        this.dateF = dateF;
    }

    public int[] getSelectedThema() {
        return this.selectedThema;
    }

    public void setSelectedThema(int[] selectedThema) {
        this.selectedThema = selectedThema;
    }

    public List<ThematiqueTO> getAllThema() {
        return this.allThema;
    }

    public void setAllThema(List<ThematiqueTO> allThema) {
        this.allThema = allThema;
    }

    public List<CollaborateurTO> getCollaborateurs() {
        return this.collaborateurs;
    }

    public void setCollaborateurs(List<CollaborateurTO> collaborateurs) {
        this.collaborateurs = collaborateurs;
    }

    public List<Object> getItems() {
        return this.items;
    }

    public void setItems(List<Object> items) {
        this.items = items;
    }

    public List<RecapProjetTO> getListRecap() {
        return this.listRecap;
    }

    public void setListRecap(List<RecapProjetTO> listRecap) {
        this.listRecap = listRecap;
    }

    public boolean isVoirThema() {
        return this.voirThema;
    }

    public void setVoirThema(boolean voirThema) {
        this.voirThema = voirThema;
    }

    public boolean isVoirTablThema() {
        return this.voirTablThema;
    }

    public void setVoirTablThema(boolean voirTablThema) {
        this.voirTablThema = voirTablThema;
    }

    public boolean isVoirDate() {
        return this.voirDate;
    }

    public void setVoirDate(boolean voirDate) {
        this.voirDate = voirDate;
    }
}

