/*
 * Decompiled with CFR 0.152.
 */
package org.jeinnov.jeitime.ui.collaborateur;

import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.jeinnov.jeitime.api.service.collaborateur.CollaborateurException;
import org.jeinnov.jeitime.api.service.collaborateur.EquipeManager;
import org.jeinnov.jeitime.api.to.collaborateur.EquipeTO;
import org.ow2.opensuit.core.error.IError;
import org.ow2.opensuit.core.error.NonLocalizedError;

public class EquipeUIBean {
    private EquipeManager equipeManager = EquipeManager.getInstance();
    private int idEquipe;
    private String nomEquipe;
    private String fonctionEquipe;
    private EquipeTO selected;
    private List<EquipeTO> allEquip;

    public void loadAll() {
        this.idEquipe = 0;
        this.nomEquipe = null;
        this.fonctionEquipe = null;
        this.allEquip = new ArrayList();
        this.allEquip = this.equipeManager.getAll();
    }

    public void create() throws IError {
        EquipeTO equipColl = new EquipeTO(this.idEquipe, this.nomEquipe, this.fonctionEquipe);
        try {
            this.equipeManager.saveOrUpdate(equipColl);
        }
        catch (CollaborateurException e) {
            NonLocalizedError error = new NonLocalizedError("Attention : ", "Aucune \u00e9quipe n'est sp\u00e9cifi\u00e9e ou l'\u00e9quipe s\u00e9lectionn\u00e9e n'existe plus dans la base.", (Throwable)e);
            error.setType((short)0);
            throw error;
        }
        this.clear();
    }

    public void refresh() {
    }

    public void clear() {
        this.idEquipe = 0;
        this.nomEquipe = null;
        this.fonctionEquipe = null;
        this.allEquip = new ArrayList();
        this.allEquip = this.equipeManager.getAll();
    }

    public void select(HttpServletRequest iRequest) throws IError {
        this.selected = null;
        int id = Integer.parseInt(iRequest.getParameter("ID"));
        try {
            this.selected = this.equipeManager.get(id);
        }
        catch (CollaborateurException e) {
            NonLocalizedError error = new NonLocalizedError("Attention : ", "Aucune \u00e9quipe n'est s\u00e9lectionn\u00e9e ou l'\u00e9quipe s\u00e9lectionn\u00e9e n'existe plus dans la base.", (Throwable)e);
            error.setType((short)0);
            throw error;
        }
    }

    public void update() throws IError {
        int id = this.selected.getIdEquip();
        String nom = this.selected.getNomEquip();
        String fct = this.selected.getFonctionEquip();
        EquipeTO equipe = new EquipeTO(id, nom, fct);
        try {
            this.equipeManager.saveOrUpdate(equipe);
        }
        catch (CollaborateurException e) {
            NonLocalizedError error = new NonLocalizedError("Attention : ", "Aucune \u00e9quipe n'est sp\u00e9cifi\u00e9e ou l'\u00e9quipe s\u00e9lectionn\u00e9e n'existe plus dans la base.", (Throwable)e);
            error.setType((short)0);
            throw error;
        }
        this.selected = null;
        this.clear();
    }

    public void delete(HttpServletRequest iRequest) throws IError {
        int id = Integer.parseInt(iRequest.getParameter("ID"));
        try {
            this.equipeManager.deleteEquipe(id);
        }
        catch (CollaborateurException e) {
            NonLocalizedError error = new NonLocalizedError("Attention : ", "Aucune \u00e9quipe n'est s\u00e9lectionn\u00e9e ou l'\u00e9quipe s\u00e9lectionn\u00e9e n'existe plus dans la base.", (Throwable)e);
            error.setType((short)0);
            throw error;
        }
        this.clear();
    }

    public void cancel() {
        this.selected = null;
    }

    public boolean isInCollab(int id) throws CollaborateurException {
        boolean verif = this.equipeManager.isInCollaborateur(id);
        return verif;
    }

    public EquipeTO getSelected() {
        return this.selected;
    }

    public List<EquipeTO> getAllEquip() {
        return this.allEquip;
    }

    public void setAllEquip(List<EquipeTO> allEquip) {
        this.allEquip = allEquip;
    }

    public int getIdEquipe() {
        return this.idEquipe;
    }

    public void setIdEquipe(int idEquipe) {
        this.idEquipe = idEquipe;
    }

    public String getNomEquipe() {
        return this.nomEquipe;
    }

    public void setNomEquipe(String nomEquipe) {
        this.nomEquipe = nomEquipe;
    }

    public String getFonctionEquipe() {
        return this.fonctionEquipe;
    }

    public void setFonctionEquipe(String fonctionEquipe) {
        this.fonctionEquipe = fonctionEquipe;
    }

    public void setEquipeManager(EquipeManager equipeManager) {
        this.equipeManager = equipeManager;
    }
}

