/*
 * Decompiled with CFR 0.152.
 */
package org.jeinnov.jeitime.ui.heure;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import org.jeinnov.jeitime.api.service.collaborateur.CollaborateurManager;
import org.jeinnov.jeitime.api.service.heure.ConsultationMensuelleManager;
import org.jeinnov.jeitime.api.service.heure.HeureException;
import org.jeinnov.jeitime.api.to.bilan.JourMois;
import org.jeinnov.jeitime.api.to.collaborateur.CollaborateurTO;
import org.jeinnov.jeitime.api.to.heure.SaisieHeureTO;
import org.jeinnov.jeitime.api.to.projet.TacheTO;
import org.jeinnov.jeitime.ui.utils.CalculJourDate;
import org.ow2.opensuit.core.error.IError;
import org.ow2.opensuit.core.error.NonLocalizedError;

public class ConsultMensCollabUIBean {
    private CalculJourDate calCulJourDate = new CalculJourDate();
    private static int[] ALL_MOIS = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11};
    private int mois;
    private int annee;
    private Date dateDeb;
    private Date dateFin;
    private List<JourMois> jour = new ArrayList();
    private List<SaisieHeureTO> listSaisieMens = new ArrayList();
    private List<Object> items = new ArrayList();
    private List<CollaborateurTO> allCollaborateur = new ArrayList();
    private int[] selectedC;
    private boolean voirTabl = false;
    private boolean voirCollab = false;
    private boolean voirDate = true;

    public void load() {
        this.allCollaborateur = CollaborateurManager.getInstance().getAll();
        this.voirTabl = false;
        this.voirCollab = false;
        this.voirDate = true;
        Calendar cal = GregorianCalendar.getInstance();
        cal.getTime();
        this.annee = cal.get(1);
    }

    public void voirSaisieMens() throws IError {
        this.jour = new ArrayList();
        this.calculDate();
        List itemTmp = new ArrayList();
        List listSaisieMensTmp = new ArrayList();
        this.listSaisieMens = new ArrayList();
        this.items = new ArrayList();
        for (int i = 0; i < this.selectedC.length; ++i) {
            NonLocalizedError error;
            int idColl = this.selectedC[i];
            try {
                listSaisieMensTmp = ConsultationMensuelleManager.getInstance().afficheListSaisieAllC(idColl, this.dateDeb, this.dateFin);
            }
            catch (HeureException e) {
                error = new NonLocalizedError("Attention : ", "le collaborateur avec l'id : " + idColl + " n'existe pas dans la base.", (Throwable)e);
                error.setType((short)0);
                throw error;
            }
            try {
                itemTmp = ConsultationMensuelleManager.getInstance().listSaisieAllCollab(listSaisieMensTmp);
            }
            catch (HeureException e) {
                error = new NonLocalizedError("Attention : ", "Une erreur est survenue, la liste des saisie du collaborateur n'a pas pu \u00eatre charg\u00e9e", (Throwable)e);
                error.setType((short)0);
                throw error;
            }
            for (Object o : itemTmp) {
                this.items.add(o);
            }
            for (SaisieHeureTO sh : listSaisieMensTmp) {
                this.listSaisieMens.add(sh);
            }
        }
        this.calCulJourDate.nbrJour(this.annee, this.mois, this.getJour());
        this.voirCollab = false;
        this.voirDate = false;
        this.voirTabl = true;
    }

    public String getHtmlName(Object item) {
        if (item instanceof String) {
            return "\\html\\<span class=Title>" + item + "</span>";
        }
        if (item instanceof CollaborateurTO) {
            return "\\html\\<span class=sousTitre>" + ((CollaborateurTO)item).getNomColl() + "</span>";
        }
        if (item instanceof Integer) {
            return "\\html\\<span class=sousTitre> Total</span>";
        }
        return ((TacheTO)item).getNomtache().getNomTache();
    }

    public String getValue(Object item, int j) {
        String nb = "";
        if (item instanceof String) {
            return null;
        }
        if (item instanceof CollaborateurTO) {
            return null;
        }
        if (item instanceof Integer) {
            nb = this.itemsInstanceOfInteger(item, j);
            return nb;
        }
        nb = this.itemsInstanceOfTacheTO(item, j);
        return nb;
    }

    private String itemsInstanceOfInteger(Object item, int j) {
        String nb = "0";
        double nbht = 0.0;
        int idC = (Integer)item;
        int jo = 0;
        for (int i = 0; i < this.listSaisieMens.size(); ++i) {
            if (((SaisieHeureTO)this.listSaisieMens.get(i)).getSaisiDate() == null || (jo = this.definirLeJour(((SaisieHeureTO)this.listSaisieMens.get(i)).getSaisiDate())) != j || idC != ((SaisieHeureTO)this.listSaisieMens.get(i)).getCollab().getIdColl()) continue;
            nbht = (double)((SaisieHeureTO)this.listSaisieMens.get(i)).getNbHeure() + nbht;
            DecimalFormat df = new DecimalFormat();
            df.setMaximumFractionDigits(2);
            df.setMinimumFractionDigits(2);
            df.setDecimalSeparatorAlwaysShown(true);
            nb = df.format(nbht);
        }
        return nb;
    }

    private String itemsInstanceOfTacheTO(Object item, int j) {
        String nb = "";
        int idT = ((TacheTO)item).getIdTache();
        int idC = ((TacheTO)item).getPriorite();
        for (int i = 0; i < this.listSaisieMens.size(); ++i) {
            int jo;
            if (((SaisieHeureTO)this.listSaisieMens.get(i)).getSaisiDate() == null || j != (jo = this.definirLeJour(((SaisieHeureTO)this.listSaisieMens.get(i)).getSaisiDate())) || idT != ((SaisieHeureTO)this.listSaisieMens.get(i)).getTache().getIdTache() || idC != ((SaisieHeureTO)this.listSaisieMens.get(i)).getCollab().getIdColl()) continue;
            double nbh = ((SaisieHeureTO)this.listSaisieMens.get(i)).getNbHeure();
            DecimalFormat df = new DecimalFormat();
            df.setMaximumFractionDigits(2);
            df.setMinimumFractionDigits(2);
            df.setDecimalSeparatorAlwaysShown(true);
            nb = df.format(nbh);
        }
        return nb;
    }

    public String getTotal(Object item) {
        double nbh = 0.0;
        if (item instanceof String) {
            return null;
        }
        if (item instanceof CollaborateurTO) {
            return null;
        }
        if (item instanceof Integer) {
            return this.totalInstanceOfInteger(item, nbh);
        }
        return this.totalInstanceOfTacheTO(item, nbh);
    }

    private String totalInstanceOfInteger(Object item, double nbh) {
        int idC = (Integer)item;
        for (int i = 0; i < this.listSaisieMens.size(); ++i) {
            if (idC != ((SaisieHeureTO)this.listSaisieMens.get(i)).getCollab().getIdColl()) continue;
            nbh = (double)((SaisieHeureTO)this.listSaisieMens.get(i)).getNbHeure() + nbh;
        }
        DecimalFormat df = new DecimalFormat();
        df.setMaximumFractionDigits(2);
        df.setMinimumFractionDigits(2);
        df.setDecimalSeparatorAlwaysShown(true);
        return df.format(nbh);
    }

    private String totalInstanceOfTacheTO(Object item, double nbh) {
        int idT = ((TacheTO)item).getIdTache();
        int idC = ((TacheTO)item).getPriorite();
        for (int i = 0; i < this.listSaisieMens.size(); ++i) {
            if (idT == 0 || ((SaisieHeureTO)this.listSaisieMens.get(i)).getTache().getIdTache() == 0 || idT != ((SaisieHeureTO)this.listSaisieMens.get(i)).getTache().getIdTache() || idC != ((SaisieHeureTO)this.listSaisieMens.get(i)).getCollab().getIdColl()) continue;
            nbh = (double)((SaisieHeureTO)this.listSaisieMens.get(i)).getNbHeure() + nbh;
        }
        DecimalFormat df = new DecimalFormat();
        df.setMaximumFractionDigits(2);
        df.setMinimumFractionDigits(2);
        df.setDecimalSeparatorAlwaysShown(true);
        return df.format(nbh);
    }

    public void calculDate() {
        Calendar cal = GregorianCalendar.getInstance();
        if (this.annee == 0) {
            cal.getTime();
            this.annee = cal.get(1);
        }
        if (this.mois == 1) {
            if (this.annee == 2012 || this.annee == 2016 || this.annee == 2020) {
                this.dateDeb = this.calCulJourDate.calculDateFevrierDebut(cal, this.annee, this.mois);
                this.dateFin = this.calCulJourDate.calculDateFevrierFin29(cal, this.annee, this.mois);
            } else {
                this.dateDeb = this.calCulJourDate.calculDateFevrierDebut(cal, this.annee, this.mois);
                this.dateFin = this.calCulJourDate.calculDateFevrierFin28(cal, this.annee, this.mois);
            }
        } else if (this.mois == 0 || this.mois == 2 || this.mois == 4 || this.mois == 6 || this.mois == 7 || this.mois == 9 || this.mois == 11) {
            this.dateDeb = this.calCulJourDate.calculDateMoisDebut(cal, this.annee, this.mois);
            this.dateFin = this.calCulJourDate.calculDateMois31Fin(cal, this.annee, this.mois);
        } else {
            this.dateDeb = this.calCulJourDate.calculDateMoisDebut(cal, this.annee, this.mois);
            this.dateFin = this.calCulJourDate.calculDateMois30Fin(cal, this.annee, this.mois);
        }
    }

    public int definirLeJour(Date d) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(d);
        return cal.get(5);
    }

    public void voirMoisSuiv() throws IError {
        if (this.mois == 11) {
            ++this.annee;
            this.mois = 0;
        } else {
            ++this.mois;
        }
        this.jour = new ArrayList();
        this.voirSaisieMens();
    }

    public void voirMoisPrec() throws IError {
        if (this.mois == 0) {
            --this.annee;
            this.mois = 11;
        } else {
            --this.mois;
        }
        this.jour = new ArrayList();
        this.voirSaisieMens();
    }

    public void envoyer() {
        this.voirCollab = true;
    }

    public void reset() {
        this.voirTabl = false;
        this.voirCollab = false;
        this.voirDate = true;
        this.selectedC = null;
        this.listSaisieMens = new ArrayList();
        this.items = new ArrayList();
        this.allCollaborateur = new ArrayList();
        this.allCollaborateur = CollaborateurManager.getInstance().getAll();
    }

    public void selectAll() {
        this.selectedC = new int[this.allCollaborateur.size()];
        for (int i = 0; i < this.allCollaborateur.size(); ++i) {
            this.selectedC[i] = ((CollaborateurTO)this.allCollaborateur.get(i)).getIdColl();
        }
    }

    public void deSelectAll() {
        this.selectedC = null;
    }

    public int getMois() {
        return this.mois;
    }

    public void setMois(int mois) {
        this.mois = mois;
    }

    public int getAnnee() {
        return this.annee;
    }

    public void setAnnee(int annee) {
        this.annee = annee;
    }

    public Date getDateDeb() {
        return this.dateDeb;
    }

    public void setDateDeb(Date dateDeb) {
        this.dateDeb = dateDeb;
    }

    public Date getDateFin() {
        return this.dateFin;
    }

    public void setDateFin(Date dateFin) {
        this.dateFin = dateFin;
    }

    public List<JourMois> getJour() {
        return this.jour;
    }

    public void setJour(List<JourMois> jour) {
        this.jour = jour;
    }

    public List<SaisieHeureTO> getListSaisieMens() {
        return this.listSaisieMens;
    }

    public void setListSaisieMens(List<SaisieHeureTO> listSaisieMens) {
        this.listSaisieMens = listSaisieMens;
    }

    public List<Object> getItems() {
        return this.items;
    }

    public void setItems(List<Object> items) {
        this.items = items;
    }

    public List<CollaborateurTO> getAllCollaborateur() {
        return this.allCollaborateur;
    }

    public void setAllCollaborateur(List<CollaborateurTO> allCollaborateur) {
        this.allCollaborateur = allCollaborateur;
    }

    public int[] getSelectedC() {
        return this.selectedC;
    }

    public void setSelectedC(int[] selectedC) {
        this.selectedC = selectedC;
    }

    public boolean isVoirTabl() {
        return this.voirTabl;
    }

    public void setVoirTabl(boolean voirTabl) {
        this.voirTabl = voirTabl;
    }

    public boolean isVoirCollab() {
        return this.voirCollab;
    }

    public void setVoirCollab(boolean voirCollab) {
        this.voirCollab = voirCollab;
    }

    public boolean isVoirDate() {
        return this.voirDate;
    }

    public void setVoirDate(boolean voirDate) {
        this.voirDate = voirDate;
    }

    public static int[] getAllMois() {
        return ALL_MOIS;
    }
}

