/*
 * Decompiled with CFR 0.152.
 */
package org.jeinnov.jeitime.ui.heure;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import org.jeinnov.jeitime.api.service.heure.ConsultationMensuelleManager;
import org.jeinnov.jeitime.api.service.heure.HeureException;
import org.jeinnov.jeitime.api.to.bilan.JourMois;
import org.jeinnov.jeitime.api.to.bilan.SousTotal;
import org.jeinnov.jeitime.api.to.collaborateur.CollaborateurTO;
import org.jeinnov.jeitime.api.to.heure.SaisieHeureTO;
import org.jeinnov.jeitime.api.to.projet.TacheTO;
import org.jeinnov.jeitime.ui.utils.CalculJourDate;
import org.ow2.opensuit.core.error.IError;
import org.ow2.opensuit.core.error.NonLocalizedError;

public class ConsultationMensuelleUIBean {
    private CalculJourDate calCulJourDate = new CalculJourDate();
    private static int[] ALL_MOIS = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11};
    private int mois;
    private int annee;
    private Date dateDeb;
    private Date dateFin;
    private List<JourMois> jour = new ArrayList();
    private List<SaisieHeureTO> listSaisieMens = new ArrayList();
    private List<Object> items = new ArrayList();
    private boolean voirTabl = false;
    private boolean voirDate = true;

    public void load() {
        Calendar cal = GregorianCalendar.getInstance();
        cal.getTime();
        this.annee = cal.get(1);
    }

    public void voirSaisieMens(int idCollab) throws IError {
        this.jour = new ArrayList();
        this.calCulJourDate.nbrJour(this.annee, this.mois, this.getJour());
        this.calculDate();
        try {
            this.listSaisieMens = ConsultationMensuelleManager.getInstance().afficheListSaisieAllC(idCollab, this.dateDeb, this.dateFin);
        }
        catch (HeureException e) {
            NonLocalizedError error = new NonLocalizedError("Attention : ", "Une erreur est survenue, le collaborateur avec l'id : " + idCollab + " n'existe pas dans la base.", (Throwable)e);
            error.setType((short)0);
            throw error;
        }
        try {
            this.items = ConsultationMensuelleManager.getInstance().listSaisieAllCollab(this.listSaisieMens);
        }
        catch (HeureException e) {
            NonLocalizedError error = new NonLocalizedError("Attention : ", "Une erreur est survenue, la liste des saisie du collaborateur n'a pas pu \u00eatre charg\u00e9e", (Throwable)e);
            error.setType((short)0);
            throw error;
        }
        this.voirTabl = true;
        this.voirDate = false;
    }

    public void cancel() {
        this.listSaisieMens = null;
        this.jour = null;
        this.items = null;
        this.voirDate = true;
        this.voirTabl = false;
    }

    public String getHtmlName(Object item) {
        if (item instanceof String) {
            return "\\html\\<span class=Title>" + item + "</span>";
        }
        if (item instanceof CollaborateurTO) {
            return "\\html\\<span class=sousTitre>" + ((CollaborateurTO)item).getNomColl() + "</span>";
        }
        if (item instanceof Integer) {
            return "\\html\\<span class=sousTitre> Total</span>";
        }
        if (item instanceof SousTotal) {
            return "\\html\\<span class=sousTitre>" + ((SousTotal)item).getNomSousTotal() + "</span>";
        }
        return ((TacheTO)item).getNomtache().getNomTache();
    }

    public String getValue(Object item, int j) {
        if (item instanceof String) {
            return null;
        }
        if (item instanceof CollaborateurTO) {
            return null;
        }
        if (item instanceof Integer) {
            return "\\html\\<span class=sousTitre>" + this.itemsInstanceOfInteger(j) + "</span>";
        }
        if (item instanceof SousTotal) {
            return this.itemsInstanceOfSousTotal(item, j);
        }
        return this.itemsInstanceOfTacheTO(item, j);
    }

    public String getTotal(Object item) {
        double nbh = 0.0;
        String total = "0";
        if (item instanceof String) {
            return null;
        }
        if (item instanceof CollaborateurTO) {
            return null;
        }
        if (item instanceof Integer) {
            total = this.totalInstanceOfInteger(nbh);
        } else if (item instanceof SousTotal) {
            this.totalInstanceOfSousTotal(item, nbh);
        } else {
            total = this.totalInstanceOfTacheTO(item, nbh);
        }
        return total;
    }

    public void voirMoisSuiv(int idCollab) throws IError {
        if (this.mois == 11) {
            ++this.annee;
            this.mois = 0;
        } else {
            ++this.mois;
        }
        this.jour = new ArrayList();
        this.voirSaisieMens(idCollab);
    }

    public void voirMoisPrec(int idCollab) throws IError {
        if (this.mois == 0) {
            --this.annee;
            this.mois = 11;
        } else {
            --this.mois;
        }
        this.jour = new ArrayList();
        this.voirSaisieMens(idCollab);
    }

    private void calculDate() {
        Calendar cal = GregorianCalendar.getInstance();
        if (this.annee == 0) {
            cal.getTime();
            this.annee = cal.get(1);
        }
        if (this.mois == 1) {
            if (this.annee == 2012 || this.annee == 2016 || this.annee == 2020) {
                this.dateDeb = this.calCulJourDate.calculDateFevrierDebut(cal, this.annee, this.mois);
                this.dateFin = this.calCulJourDate.calculDateFevrierFin29(cal, this.annee, this.mois);
            } else {
                this.dateDeb = this.calCulJourDate.calculDateFevrierDebut(cal, this.annee, this.mois);
                this.dateFin = this.calCulJourDate.calculDateFevrierFin28(cal, this.annee, this.mois);
            }
        } else if (this.mois == 0 || this.mois == 2 || this.mois == 4 || this.mois == 6 || this.mois == 7 || this.mois == 9 || this.mois == 11) {
            this.dateDeb = this.calCulJourDate.calculDateMoisDebut(cal, this.annee, this.mois);
            this.dateFin = this.calCulJourDate.calculDateMois31Fin(cal, this.annee, this.mois);
        } else {
            this.dateDeb = this.calCulJourDate.calculDateMoisDebut(cal, this.annee, this.mois);
            this.dateFin = this.calCulJourDate.calculDateMois30Fin(cal, this.annee, this.mois);
        }
    }

    private int definirLeJour(Date d) {
        int j = 0;
        if (d != null) {
            Calendar cal = Calendar.getInstance();
            cal.setTime(d);
            j = cal.get(5);
        }
        return j;
    }

    private String itemsInstanceOfInteger(int j) {
        String nb = "0";
        double nbht = 0.0;
        for (int i = 0; i < this.listSaisieMens.size(); ++i) {
            int jo = this.definirLeJour(((SaisieHeureTO)this.listSaisieMens.get(i)).getSaisiDate());
            if (jo != j) continue;
            nbht = (double)((SaisieHeureTO)this.listSaisieMens.get(i)).getNbHeure() + nbht;
            DecimalFormat df = new DecimalFormat();
            df.setMaximumFractionDigits(2);
            df.setMinimumFractionDigits(2);
            df.setDecimalSeparatorAlwaysShown(true);
            nb = df.format(nbht);
        }
        return nb;
    }

    private String itemsInstanceOfSousTotal(Object item, int j) {
        String nb = "0";
        double nbht = 0.0;
        int idP = ((SousTotal)item).getIdProjet();
        for (int i = 0; i < this.listSaisieMens.size(); ++i) {
            int jo = this.definirLeJour(((SaisieHeureTO)this.listSaisieMens.get(i)).getSaisiDate());
            if (jo != j || idP != ((SaisieHeureTO)this.listSaisieMens.get(i)).getProjet().getIdProjet()) continue;
            nbht = (double)((SaisieHeureTO)this.listSaisieMens.get(i)).getNbHeure() + nbht;
            DecimalFormat df = new DecimalFormat();
            df.setMaximumFractionDigits(2);
            df.setMinimumFractionDigits(2);
            df.setDecimalSeparatorAlwaysShown(true);
            nb = df.format(nbht);
        }
        return nb;
    }

    private String itemsInstanceOfTacheTO(Object item, int j) {
        int idT = ((TacheTO)item).getIdTache();
        String nb = "";
        for (int i = 0; i < this.listSaisieMens.size(); ++i) {
            int jo = this.definirLeJour(((SaisieHeureTO)this.listSaisieMens.get(i)).getSaisiDate());
            if (j != jo || idT != ((SaisieHeureTO)this.listSaisieMens.get(i)).getTache().getIdTache()) continue;
            double nbh = ((SaisieHeureTO)this.listSaisieMens.get(i)).getNbHeure();
            DecimalFormat df = new DecimalFormat();
            df.setMaximumFractionDigits(2);
            df.setMinimumFractionDigits(2);
            df.setDecimalSeparatorAlwaysShown(true);
            nb = df.format(nbh);
        }
        return nb;
    }

    private String totalInstanceOfInteger(double nbh) {
        for (int i = 0; i < this.listSaisieMens.size(); ++i) {
            nbh = (double)((SaisieHeureTO)this.listSaisieMens.get(i)).getNbHeure() + nbh;
        }
        DecimalFormat df = new DecimalFormat();
        df.setMaximumFractionDigits(2);
        df.setMinimumFractionDigits(2);
        df.setDecimalSeparatorAlwaysShown(true);
        String total = df.format(nbh);
        return total;
    }

    private void totalInstanceOfSousTotal(Object item, double nbh) {
        int idP = ((SousTotal)item).getIdProjet();
        for (int i = 0; i < this.listSaisieMens.size(); ++i) {
            if (idP != ((SaisieHeureTO)this.listSaisieMens.get(i)).getProjet().getIdProjet()) continue;
            nbh = (double)((SaisieHeureTO)this.listSaisieMens.get(i)).getNbHeure() + nbh;
        }
    }

    private String totalInstanceOfTacheTO(Object item, double nbh) {
        int idT = ((TacheTO)item).getIdTache();
        for (int i = 0; i < this.listSaisieMens.size(); ++i) {
            if (idT != ((SaisieHeureTO)this.listSaisieMens.get(i)).getTache().getIdTache()) continue;
            nbh = (double)((SaisieHeureTO)this.listSaisieMens.get(i)).getNbHeure() + nbh;
        }
        DecimalFormat df = new DecimalFormat();
        df.setMaximumFractionDigits(2);
        df.setMinimumFractionDigits(2);
        df.setDecimalSeparatorAlwaysShown(true);
        String total = df.format(nbh);
        return total;
    }

    public int getMois() {
        return this.mois;
    }

    public void setMois(int mois) {
        this.mois = mois;
    }

    public static int[] getAllMois() {
        return ALL_MOIS;
    }

    public int getAnnee() {
        return this.annee;
    }

    public void setAnnee(int annee) {
        this.annee = annee;
    }

    public boolean isVoirTabl() {
        return this.voirTabl;
    }

    public void setVoirTabl(boolean voirTabl) {
        this.voirTabl = voirTabl;
    }

    public Date getDateDeb() {
        return this.dateDeb;
    }

    public void setDateDeb(Date dateDeb) {
        this.dateDeb = dateDeb;
    }

    public Date getDateFin() {
        return this.dateFin;
    }

    public void setDateFin(Date dateFin) {
        this.dateFin = dateFin;
    }

    public List<JourMois> getJour() {
        return this.jour;
    }

    public void setJour(List<JourMois> jour) {
        this.jour = jour;
    }

    public List<SaisieHeureTO> getListSaisieMens() {
        return this.listSaisieMens;
    }

    public void setListSaisieMens(List<SaisieHeureTO> listSaisieMens) {
        this.listSaisieMens = listSaisieMens;
    }

    public List<Object> getItems() {
        return this.items;
    }

    public void setItems(List<Object> items) {
        this.items = items;
    }

    public boolean isVoirDate() {
        return this.voirDate;
    }

    public void setVoirDate(boolean voirDate) {
        this.voirDate = voirDate;
    }
}

