/*
 * Decompiled with CFR 0.152.
 */
package org.jeinnov.jeitime.ui.heure;

import java.text.DateFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;
import org.jeinnov.jeitime.api.service.collaborateur.CollaborateurException;
import org.jeinnov.jeitime.api.service.collaborateur.CollaborateurManager;
import org.jeinnov.jeitime.api.service.heure.GestionHeureManager;
import org.jeinnov.jeitime.api.service.heure.HeureException;
import org.jeinnov.jeitime.api.service.projet.ProjetException;
import org.jeinnov.jeitime.api.service.projet.ProjetManager;
import org.jeinnov.jeitime.api.service.projet.TacheManager;
import org.jeinnov.jeitime.api.to.collaborateur.CollaborateurTO;
import org.jeinnov.jeitime.api.to.heure.GereHeure;
import org.jeinnov.jeitime.api.to.heure.SaisieHeureTO;
import org.jeinnov.jeitime.api.to.projet.NomTacheTO;
import org.jeinnov.jeitime.api.to.projet.ProjetTO;
import org.jeinnov.jeitime.api.to.projet.TacheTO;
import org.jeinnov.jeitime.ui.heure.CalculDateIntervalle;
import org.ow2.opensuit.core.error.IError;
import org.ow2.opensuit.core.error.NonLocalizedError;
import org.ow2.opensuit.core.validation.LocalizedValidationError;
import org.ow2.opensuit.core.validation.ValidationError;
import org.ow2.opensuit.core.validation.ValidationErrors;

public class SaisieHeureUIBean {
    private final Logger logger = Logger.getLogger(this.getClass());
    private GestionHeureManager gestionHeureManager = GestionHeureManager.getInstance();
    private CalculDateIntervalle calculDateIntervalle = new CalculDateIntervalle();
    private TacheTO tache;
    private int idTache;
    private List<TacheTO> allTache;
    private String nomTache;
    private CollaborateurTO collab;
    private ProjetTO projet;
    private int idProjet;
    private List<ProjetTO> allProjet;
    private List<ProjetTO> allProjetPrAdmin;
    private String nomProjet;
    private Date date;
    private String nbHeure = "0";
    private String commentaire;
    private String dateMard;
    private String dateMerc;
    private String dateLun;
    private String dateJeud;
    private String dateVend;
    private String dateSem;
    private String mois;
    private int numJour;
    private float nbHeureLundi = 0.0f;
    private float nbHeureMardi = 0.0f;
    private float nbHeureMerc = 0.0f;
    private float nbHeureJeudi = 0.0f;
    private float nbHeureVend = 0.0f;
    private GereHeure ttsHeure;
    private List<GereHeure> tablHeure = new ArrayList();
    private float total;
    private boolean voisListSaisie = false;
    private String[] tablListSaisie;
    private boolean visible = true;
    private boolean editable = false;
    private int idCollab;
    private SaisieHeureTO saisie;
    private List<SaisieHeureTO> allHeures = new ArrayList();
    private String ttHeure;

    public void load(int idCollab) throws IError, ProjetException, HeureException {
        this.allProjet = new ArrayList();
        ProjetTO aucunProjet = new ProjetTO();
        aucunProjet.setIdProjet(0);
        aucunProjet.setNomProjet("Tous les Projets");
        this.allProjet = ProjetManager.getInstance().getAllForCollabNotClose(idCollab);
        this.allProjet.add(aucunProjet);
        this.allHeures = null;
        this.tablListSaisie = this.createListSaisie(idCollab);
        this.date = new Date();
        this.voirSaisie(idCollab);
    }

    public void loadConsult() {
        this.allHeures = null;
    }

    public void loadCons(HttpServletRequest iRequest) throws CollaborateurException, ProjetException, IError, HeureException {
        this.allHeures = null;
        this.idCollab = Integer.parseInt(iRequest.getParameter("id"));
        this.collab = CollaborateurManager.getInstance().get(this.idCollab);
        this.allProjet = new ArrayList();
        ProjetTO aucunProjet = new ProjetTO();
        aucunProjet.setIdProjet(0);
        aucunProjet.setNomProjet("Tous les Projets");
        this.allProjet = ProjetManager.getInstance().getAllForCollabNotLock(this.idCollab);
        this.allProjet.add(aucunProjet);
        this.nbHeure = "0";
        this.allHeures = null;
        this.tablListSaisie = this.createListSaisie(this.idCollab);
        this.date = new Date();
        this.voirSaisie(this.idCollab);
    }

    public void create(int idCollab) throws CollaborateurException, ProjetException, HeureException, IError {
        this.collab = CollaborateurManager.getInstance().get(idCollab);
        this.selectSaisie();
        Calendar cal = Calendar.getInstance();
        cal.setTime(this.date);
        int numJ = cal.get(7);
        if (this.saisie != null && this.saisie.getNbHeure() != 0.0f) {
            if (numJ != 1 && numJ != 7) {
                try {
                    this.gestionHeureManager.saveOrUpdate(this.saisie);
                }
                catch (HeureException e) {
                    NonLocalizedError error = new NonLocalizedError("Attention : ", "Soit le collaborateur, la date ou la t\u00e2che ne sont pas correctement sp\u00e9cifi\u00e9s. La saise n'a pas pu \u00eatre sauvegard\u00e9e. ", (Throwable)e);
                    error.setType((short)0);
                    throw error;
                }
            }
            if (numJ == 1 || numJ == 7) {
                NonLocalizedError error = new NonLocalizedError("Attention saisie sur un samedi ou un dimanche", "Il vous est impossible de saisir sur un samedi ou un dimanche ");
                error.setType((short)0);
                throw error;
            }
        }
        this.voirSaisie(idCollab);
        this.refresh();
    }

    public void update(int idColl, Date dateJ) throws IError, HeureException {
        TacheTO taches = new TacheTO(this.idTache);
        ProjetTO proj = new ProjetTO(this.idProjet);
        CollaborateurTO coll = new CollaborateurTO(idColl);
        float heure = this.parseHeure();
        this.saisie = new SaisieHeureTO(taches, proj, coll, this.date, heure, this.commentaire);
        if (heure == 0.0f) {
            try {
                this.gestionHeureManager.delete(this.saisie);
            }
            catch (HeureException e) {
                NonLocalizedError error = new NonLocalizedError("Attention : ", "Soit le collaborateur, la date ou la t\u00e2che ne sont pas correctement sp\u00e9cifi\u00e9s. La saise n'a pas pu \u00eatre sauvegard\u00e9e. ", (Throwable)e);
                error.setType((short)0);
                throw error;
            }
        }
        try {
            this.gestionHeureManager.saveOrUpdate(this.saisie);
        }
        catch (HeureException e) {
            NonLocalizedError error = new NonLocalizedError("Attention : ", "Soit le collaborateur, la date ou la t\u00e2che ne sont pas correctement sp\u00e9cifi\u00e9s. La saise n'a pas pu \u00eatre sauvegard\u00e9e. ", (Throwable)e);
            error.setType((short)0);
            throw error;
        }
        this.visible = true;
        this.voirSaisie(idColl, dateJ);
        this.refresh();
    }

    public void cancel() {
        this.visible = true;
        this.nbHeure = "0";
        this.idTache = 0;
        this.idProjet = 0;
        this.tache = null;
        this.projet = null;
        this.saisie = null;
        this.commentaire = null;
    }

    public void refresh() {
        this.nbHeure = "0";
        this.idTache = 0;
        this.idProjet = 0;
        this.tache = null;
        this.projet = new ProjetTO();
        this.saisie = null;
        this.allTache = null;
        this.commentaire = null;
    }

    public void selectProjet(int idColl) throws IError {
        this.nbHeure = "0";
        if (this.idProjet == 0) {
            this.allTache = null;
        } else {
            try {
                this.allTache = TacheManager.getInstance().getAllInProjectAndForACollaborateur(this.idProjet, idColl);
            }
            catch (ProjetException e) {
                NonLocalizedError error = new NonLocalizedError("Attention : ", "Une erreur est survenue. Le projet ou le collaborateur ne sont pas correctement sp\u00e9cifi\u00e9s", (Throwable)e);
                error.setType((short)0);
                throw error;
            }
            if (this.allTache == null || this.allTache.isEmpty()) {
                TacheTO t = new TacheTO();
                t.setIdTache(0);
                t.setNomtache(new NomTacheTO(0, "aucune t\u00e2che n'est rattach\u00e9e \u00e0 ce collaborateur"));
                this.allTache.add(t);
            }
        }
    }

    public Float getHeures(float v) {
        if (v == 0.0f) {
            return null;
        }
        return Float.valueOf(v);
    }

    public void voirSaisie(int idColl, Date dateD) throws IError, HeureException {
        this.date = dateD;
        this.voirSaisie(idColl);
    }

    public void voirSaisie(int idColl) throws NonLocalizedError, HeureException {
        try {
            this.allHeures = this.gestionHeureManager.getAllByIdCollaborateurAndDate(idColl, this.date);
        }
        catch (HeureException e) {
            NonLocalizedError error = new NonLocalizedError("Attention : ", "Aucune saisie n'est sp\u00e9cifi\u00e9e", (Throwable)e);
            error.setType((short)0);
            throw error;
        }
        this.tablHeure = new ArrayList();
        ArrayList<GereHeure> tablHeureTmp = new ArrayList<GereHeure>();
        if (this.allHeures != null) {
            for (int i = 0; i < this.allHeures.size(); ++i) {
                this.createTtsHeure(i);
                tablHeureTmp.add(this.ttsHeure);
                Collections.sort(tablHeureTmp);
            }
        } else {
            this.allHeures = null;
        }
        this.tablHeure = this.gestionHeureManager.fusionElemTablHeure(tablHeureTmp);
        this.dateIntervalle();
    }

    public void afficheTacheSaisie(HttpServletRequest iRequest, int idColl, String dateJour) throws IError {
        this.idTache = Integer.parseInt(iRequest.getParameter("id"));
        Date dateJ = null;
        SimpleDateFormat dateformat = new SimpleDateFormat("dd/MM/yy");
        try {
            dateJ = dateformat.parse(dateJour);
        }
        catch (Exception pe) {
            this.logger.error((Object)pe.getMessage(), (Throwable)pe);
        }
        try {
            this.saisie = this.gestionHeureManager.getByIdCollaborateurAndIdTacheAndDate(this.idTache, idColl, dateJ);
        }
        catch (HeureException e) {
            NonLocalizedError error = new NonLocalizedError("Attention : ", "Une erreur est survenue. La t\u00e2che ou le collaborateur ne sont pas correctement sp\u00e9cifi\u00e9s", (Throwable)e);
            error.setType((short)0);
            throw error;
        }
        if (this.saisie != null) {
            this.idProjet = this.saisie.getProjet().getIdProjet();
            this.nomProjet = this.saisie.getProjet().getNomProjet();
            try {
                this.allTache = TacheManager.getInstance().getAllTacheInProject(this.idProjet);
            }
            catch (ProjetException e) {
                NonLocalizedError error = new NonLocalizedError("Attention : ", "Une erreur est survenue. le projet n'est peut \u00eatre pas correctement sp\u00e9cifi\u00e9", (Throwable)e);
                error.setType((short)0);
                throw error;
            }
            this.idTache = this.saisie.getTache().getIdTache();
            this.nomTache = this.saisie.getTache().getNomtache().getNomTache();
            this.nbHeure = String.valueOf(this.saisie.getNbHeure());
            this.commentaire = this.saisie.getCommentaire();
            this.date = this.saisie.getSaisiDate();
            this.afficheJour();
            this.visible = false;
        } else {
            this.visible = true;
        }
    }

    public void voirSemSuiv(int idColl, Date dateLun) throws IError, HeureException {
        Calendar cal = Calendar.getInstance();
        cal.setTime(dateLun);
        int intLun = cal.get(5) + 7;
        cal.set(5, intLun);
        Date d = cal.getTime();
        this.voirSaisie(idColl, d);
    }

    public void voirSemPrec(int idColl, Date dateLun) throws IError, HeureException {
        Calendar cal = Calendar.getInstance();
        cal.setTime(dateLun);
        int intLun = cal.get(5) - 7;
        cal.set(5, intLun);
        Date d = cal.getTime();
        this.voirSaisie(idColl, d);
    }

    public boolean peutModifier(TacheTO tache, float heures) throws ProjetException {
        ProjetTO projetP;
        boolean verifProjet = false;
        if (heures == 0.0f) {
            return false;
        }
        verifProjet = tache.getIdTache() != 0 ? (projetP = ProjetManager.getInstance().getProjectNotClose(tache.getProjet().getIdProjet())).getDateFermeture() == null : false;
        return verifProjet;
    }

    public boolean peutModifierC(TacheTO tache, float heures) throws ProjetException {
        ProjetTO projetP;
        boolean verifProjet = false;
        if (heures == 0.0f) {
            return false;
        }
        verifProjet = tache.getIdTache() != 0 ? (projetP = ProjetManager.getInstance().getProjectNotLock(tache.getProjet().getIdProjet())).getDateCloture() == null : false;
        return verifProjet;
    }

    public boolean projetFerme(int idTache) throws ProjetException {
        ProjetTO projetP;
        boolean verifProjet = false;
        verifProjet = this.tache.getIdTache() != 0 ? (projetP = ProjetManager.getInstance().getProjectNotClose(this.tache.getProjet().getIdProjet())).getDateFermeture() == null : false;
        return verifProjet;
    }

    public String verifNbHeureSaisie(int idCollab) throws IError, HeureException, ProjetException {
        this.selectSaisie();
        String result = null;
        try {
            this.collab = CollaborateurManager.getInstance().get(idCollab);
        }
        catch (CollaborateurException e) {
            NonLocalizedError error = new NonLocalizedError("Attention : ", "Aucun collaborateur n'est s\u00e9lectionn\u00e9", (Throwable)e);
            error.setType((short)0);
            throw error;
        }
        Calendar cal = Calendar.getInstance();
        int numJ = 0;
        cal.setTime(this.date);
        numJ = cal.get(7);
        float heure = this.parseHeure();
        if (heure != 0.0f) {
            float heureTot = this.gestionHeureManager.getResultByIdCollaborateurAndDate(idCollab, this.date);
            heureTot += heure;
            if (numJ == 2) {
                result = heure > this.collab.getNbHeureLundi() || heureTot > this.collab.getNbHeureLundi() ? "DepassHeure" : "DepassPasHeure";
            }
            if (numJ == 3) {
                result = heure > this.collab.getNbHeureMardi() || heureTot > this.collab.getNbHeureMardi() ? "DepassHeure" : "DepassPasHeure";
            }
            if (numJ == 4) {
                result = heure > this.collab.getNbHeureMercredi() || heureTot > this.collab.getNbHeureMercredi() ? "DepassHeure" : "DepassPasHeure";
            }
            if (numJ == 5) {
                result = heure > this.collab.getNbHeureJeudi() || heureTot > this.collab.getNbHeureJeudi() ? "DepassHeure" : "DepassPasHeure";
            }
            if (numJ == 6) {
                result = heure > this.collab.getNbHeureVendredi() || heureTot > this.collab.getNbHeureVendredi() ? "DepassHeure" : "DepassPasHeure";
            }
            if (numJ == 1) {
                result = "DepassPasHeure";
            }
            if (numJ == 7) {
                result = "DepassPasHeure";
            }
        } else {
            result = "DepassPasHeure";
        }
        return result;
    }

    public void validate() throws ValidationErrors {
        ValidationErrors errors = new ValidationErrors();
        if (this.idProjet == 0 && !this.nbHeure.equalsIgnoreCase("0")) {
            errors.addItemError("saisieHeureBean.idProjet", (ValidationError)new LocalizedValidationError("validation.projetSaisie"));
        }
        if (this.idProjet != 0 && this.idTache == 0) {
            errors.addItemError("saisieHeureBean.idTache", (ValidationError)new LocalizedValidationError("validation.tacheSaisie"));
        }
        if (this.nbHeure == null || this.nbHeure == "" || this.nbHeure == " ") {
            errors.addItemError("saisieHeureBean.nbHeure", (ValidationError)new LocalizedValidationError("validation.heureSaisie"));
        }
        if (errors.hasErrors()) {
            throw errors;
        }
    }

    private void selectSaisie() throws ProjetException, IError {
        float heure = this.parseHeure();
        String nomprojet = null;
        if (this.idTache != 0 && this.idProjet != 0 && heure != 0.0f) {
            this.tache = TacheManager.getInstance().get(this.idTache);
            NomTacheTO nomTacheTO = this.tache.getNomtache();
            this.tache = new TacheTO(this.idTache, nomTacheTO);
            this.projet = ProjetManager.getInstance().get(this.idProjet);
            nomprojet = this.projet.getNomProjet();
            this.projet = new ProjetTO(this.idProjet, nomprojet);
            this.saisie = new SaisieHeureTO(this.tache, this.projet, this.collab, this.date, heure, this.commentaire);
        }
        this.afficheJour();
    }

    private void afficheJour() {
        CalculDateIntervalle calDate = new CalculDateIntervalle();
        Calendar cal = Calendar.getInstance();
        cal.setTime(this.date);
        int numJourSem = cal.get(7);
        this.numJour = cal.get(5);
        this.dateSem = calDate.trouveJourSemaine(numJourSem);
        int numMois = cal.get(2);
        this.mois = calDate.trouveMois(numMois);
    }

    private String[] createListSaisie(int idC) throws NonLocalizedError {
        String[] listSaisie = null;
        if ((listSaisie = this.gestionHeureManager.listSaisieVerifCollege(idC, listSaisie)) != null) {
            this.voisListSaisie = true;
        } else {
            this.voisListSaisie = false;
            String[] tablListSaisieTmp = new String[]{"Il n'y a pas de donn\u00e9es pour le tableau", "Aucune info"};
            this.tablListSaisie = tablListSaisieTmp;
        }
        return listSaisie;
    }

    private void dateIntervalle() {
        Locale locale = Locale.FRANCE;
        DateFormat dateFormat = DateFormat.getDateInstance(3, locale);
        Calendar cal = Calendar.getInstance();
        cal.setTime(this.date);
        int numPremJour = cal.get(7);
        switch (numPremJour) {
            case 2: {
                this.dateIntervalleLundi(dateFormat, cal);
                break;
            }
            case 3: {
                this.dateIntervalleMardi(dateFormat, cal);
                break;
            }
            case 4: {
                this.dateIntervalleMercredi(dateFormat, cal);
                break;
            }
            case 5: {
                this.dateIntervalleJeudi(dateFormat, cal);
                break;
            }
            case 6: {
                this.dateIntervalleVendredi(dateFormat, cal);
                break;
            }
            case 7: {
                this.dateIntervalleSamedi(dateFormat, cal);
                break;
            }
            case 1: {
                this.dateIntervalleDimanche(dateFormat, cal);
            }
        }
    }

    private void dateIntervalleDimanche(DateFormat dateFormat, Calendar cal) {
        this.dateLun = this.calculDateIntervalle.dateIntervalleMoins6(dateFormat, cal, this.date);
        this.dateMard = this.calculDateIntervalle.dateIntervalleMoins5(dateFormat, cal, this.date);
        this.dateMerc = this.calculDateIntervalle.dateIntervalleMoins4(dateFormat, cal, this.date);
        this.dateJeud = this.calculDateIntervalle.dateIntervalleMoins3(dateFormat, cal, this.date);
        this.dateVend = this.calculDateIntervalle.dateIntervalleMoins2(dateFormat, cal, this.date);
    }

    private void dateIntervalleSamedi(DateFormat dateFormat, Calendar cal) {
        this.dateLun = this.calculDateIntervalle.dateIntervalleMoins5(dateFormat, cal, this.date);
        this.dateMard = this.calculDateIntervalle.dateIntervalleMoins4(dateFormat, cal, this.date);
        this.dateMerc = this.calculDateIntervalle.dateIntervalleMoins3(dateFormat, cal, this.date);
        this.dateJeud = this.calculDateIntervalle.dateIntervalleMoins2(dateFormat, cal, this.date);
        this.dateVend = this.calculDateIntervalle.dateIntervalleMoins1(dateFormat, cal, this.date);
    }

    private void dateIntervalleVendredi(DateFormat dateFormat, Calendar cal) {
        this.dateLun = this.calculDateIntervalle.dateIntervalleMoins4(dateFormat, cal, this.date);
        this.dateMard = this.calculDateIntervalle.dateIntervalleMoins3(dateFormat, cal, this.date);
        this.dateMerc = this.calculDateIntervalle.dateIntervalleMoins2(dateFormat, cal, this.date);
        this.dateJeud = this.calculDateIntervalle.dateIntervalleMoins1(dateFormat, cal, this.date);
        this.dateVend = dateFormat.format(this.date);
    }

    private void dateIntervalleJeudi(DateFormat dateFormat, Calendar cal) {
        this.dateLun = this.calculDateIntervalle.dateIntervalleMoins3(dateFormat, cal, this.date);
        this.dateMard = this.calculDateIntervalle.dateIntervalleMoins2(dateFormat, cal, this.date);
        this.dateMerc = this.calculDateIntervalle.dateIntervalleMoins1(dateFormat, cal, this.date);
        this.dateJeud = dateFormat.format(this.date);
        this.dateVend = this.calculDateIntervalle.dateIntervallePlus1(dateFormat, cal, this.date);
    }

    private void dateIntervalleMercredi(DateFormat dateFormat, Calendar cal) {
        this.dateLun = this.calculDateIntervalle.dateIntervalleMoins2(dateFormat, cal, this.date);
        this.dateMard = this.calculDateIntervalle.dateIntervalleMoins1(dateFormat, cal, this.date);
        this.dateMerc = dateFormat.format(this.date);
        this.dateJeud = this.calculDateIntervalle.dateIntervallePlus1(dateFormat, cal, this.date);
        this.dateVend = this.calculDateIntervalle.dateIntervallePlus2(dateFormat, cal, this.date);
    }

    private void dateIntervalleMardi(DateFormat dateFormat, Calendar cal) {
        this.dateLun = this.calculDateIntervalle.dateIntervalleMoins1(dateFormat, cal, this.date);
        this.dateMard = dateFormat.format(this.date);
        this.dateMerc = this.calculDateIntervalle.dateIntervallePlus1(dateFormat, cal, this.date);
        this.dateJeud = this.calculDateIntervalle.dateIntervallePlus2(dateFormat, cal, this.date);
        this.dateVend = this.calculDateIntervalle.dateIntervallePlus3(dateFormat, cal, this.date);
    }

    private void dateIntervalleLundi(DateFormat dateFormat, Calendar cal) {
        this.dateLun = dateFormat.format(this.date);
        this.dateMard = this.calculDateIntervalle.dateIntervallePlus1(dateFormat, cal, this.date);
        this.dateMerc = this.calculDateIntervalle.dateIntervallePlus2(dateFormat, cal, this.date);
        this.dateJeud = this.calculDateIntervalle.dateIntervallePlus3(dateFormat, cal, this.date);
        this.dateVend = this.calculDateIntervalle.dateIntervallePlus4(dateFormat, cal, this.date);
    }

    private float parseHeure() throws IError {
        float heure = 0.0f;
        try {
            heure = Float.parseFloat(this.nbHeure);
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            try {
                NumberFormat nf = NumberFormat.getInstance(Locale.FRANCE);
                heure = nf.parse(this.nbHeure).floatValue();
            }
            catch (ParseException pe) {
                NonLocalizedError error = new NonLocalizedError("Attention : ", "La valeur saisie pour le nombre d'heure doit \u00eatre num\u00e9rique.", (Throwable)e);
                error.setType((short)0);
                throw error;
            }
        }
        return heure;
    }

    private void createTtsHeure(int i) {
        Date dateS = ((SaisieHeureTO)this.allHeures.get(i)).getSaisiDate();
        Calendar cal = Calendar.getInstance();
        cal.setTime(dateS);
        int numJourTmp = cal.get(7);
        float nbrHeure = ((SaisieHeureTO)this.allHeures.get(i)).getNbHeure();
        String nomT = ((SaisieHeureTO)this.allHeures.get(i)).getTache().getNomtache().getNomTache();
        TacheTO tacheTO = ((SaisieHeureTO)this.allHeures.get(i)).getTache();
        String nomP = ((SaisieHeureTO)this.allHeures.get(i)).getProjet().getNomProjet();
        int idTaches = ((SaisieHeureTO)this.allHeures.get(i)).getTache().getIdTache();
        this.determineNbheureJour(numJourTmp, nbrHeure);
        float totalTmp = this.nbHeureLundi + this.nbHeureMardi + this.nbHeureMerc + this.nbHeureJeudi + this.nbHeureVend;
        this.ttsHeure = new GereHeure(this.nbHeureLundi, this.nbHeureMardi, this.nbHeureMerc, this.nbHeureJeudi, this.nbHeureVend, totalTmp, nomT, nomP, idTaches);
        this.ttsHeure.setTache(tacheTO);
    }

    private void determineNbheureJour(int numJour, float nbrHeure) {
        switch (numJour) {
            case 2: {
                this.nbHeureLundi = nbrHeure;
                this.nbHeureMardi = 0.0f;
                this.nbHeureMerc = 0.0f;
                this.nbHeureJeudi = 0.0f;
                this.nbHeureVend = 0.0f;
                break;
            }
            case 3: {
                this.nbHeureLundi = 0.0f;
                this.nbHeureMardi = nbrHeure;
                this.nbHeureMerc = 0.0f;
                this.nbHeureJeudi = 0.0f;
                this.nbHeureVend = 0.0f;
                break;
            }
            case 4: {
                this.nbHeureLundi = 0.0f;
                this.nbHeureMardi = 0.0f;
                this.nbHeureMerc = nbrHeure;
                this.nbHeureJeudi = 0.0f;
                this.nbHeureVend = 0.0f;
                break;
            }
            case 5: {
                this.nbHeureLundi = 0.0f;
                this.nbHeureMardi = 0.0f;
                this.nbHeureMerc = 0.0f;
                this.nbHeureJeudi = nbrHeure;
                this.nbHeureVend = 0.0f;
                break;
            }
            case 6: {
                this.nbHeureLundi = 0.0f;
                this.nbHeureMardi = 0.0f;
                this.nbHeureMerc = 0.0f;
                this.nbHeureJeudi = 0.0f;
                this.nbHeureVend = nbrHeure;
            }
        }
    }

    public TacheTO getTache() {
        return this.tache;
    }

    public void setTache(TacheTO tache) {
        this.tache = tache;
    }

    public CollaborateurTO getCollab() {
        return this.collab;
    }

    public void setCollab(CollaborateurTO collab) {
        this.collab = collab;
    }

    public ProjetTO getProjet() {
        return this.projet;
    }

    public void setProjet(ProjetTO projet) {
        this.projet = projet;
    }

    public Date getDate() {
        return this.date;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    public String getNbHeure() {
        return this.nbHeure;
    }

    public void setNbHeure(String nbHeure) {
        this.nbHeure = nbHeure;
    }

    public String getCommentaire() {
        return this.commentaire;
    }

    public void setCommentaire(String commentaire) {
        this.commentaire = commentaire;
    }

    public int getIdProjet() {
        return this.idProjet;
    }

    public void setIdProjet(int idProjet) {
        this.idProjet = idProjet;
    }

    public List<ProjetTO> getAllProjet() {
        return this.allProjet;
    }

    public void setAllProjet(List<ProjetTO> allProjet) {
        this.allProjet = allProjet;
    }

    public int getIdTache() {
        return this.idTache;
    }

    public void setIdTache(int idTache) {
        this.idTache = idTache;
    }

    public List<TacheTO> getAllTache() {
        return this.allTache;
    }

    public void setAllTache(List<TacheTO> allTache) {
        this.allTache = allTache;
    }

    public SaisieHeureTO getSaisie() {
        return this.saisie;
    }

    public void setSaisie(SaisieHeureTO saisie) {
        this.saisie = saisie;
    }

    public String getTtHeure() {
        return this.ttHeure;
    }

    public void setTtHeure(String ttHeure) {
        this.ttHeure = ttHeure;
    }

    public float getNbHeureLundi() {
        return this.nbHeureLundi;
    }

    public void setNbHeureLundi(float nbHeureLundi) {
        this.nbHeureLundi = nbHeureLundi;
    }

    public float getNbHeureMardi() {
        return this.nbHeureMardi;
    }

    public void setNbHeureMardi(float nbHeureMardi) {
        this.nbHeureMardi = nbHeureMardi;
    }

    public float getNbHeureMerc() {
        return this.nbHeureMerc;
    }

    public void setNbHeureMerc(float nbHeureMerc) {
        this.nbHeureMerc = nbHeureMerc;
    }

    public float getNbHeureJeudi() {
        return this.nbHeureJeudi;
    }

    public void setNbHeureJeudi(float nbHeureJeudi) {
        this.nbHeureJeudi = nbHeureJeudi;
    }

    public float getNbHeureVend() {
        return this.nbHeureVend;
    }

    public void setNbHeureVend(float nbHeureVend) {
        this.nbHeureVend = nbHeureVend;
    }

    public GereHeure getTtsHeure() {
        return this.ttsHeure;
    }

    public void setTtsHeure(GereHeure ttsHeure) {
        this.ttsHeure = ttsHeure;
    }

    public List<GereHeure> getTablHeure() {
        return this.tablHeure;
    }

    public void setTablHeure(List<GereHeure> tablHeure) {
        this.tablHeure = tablHeure;
    }

    public float getTotal() {
        return this.total;
    }

    public void setTotal(float total) {
        this.total = total;
    }

    public List<SaisieHeureTO> getAllHeures() {
        return this.allHeures;
    }

    public void setAllHeures(List<SaisieHeureTO> allHeures) {
        this.allHeures = allHeures;
    }

    public String getDateLun() {
        return this.dateLun;
    }

    public void setDateLun(String dateLun) {
        this.dateLun = dateLun;
    }

    public String getDateMard() {
        return this.dateMard;
    }

    public void setDateMard(String dateMard) {
        this.dateMard = dateMard;
    }

    public String getDateMerc() {
        return this.dateMerc;
    }

    public void setDateMerc(String dateMerc) {
        this.dateMerc = dateMerc;
    }

    public String getDateJeud() {
        return this.dateJeud;
    }

    public void setDateJeud(String dateJeud) {
        this.dateJeud = dateJeud;
    }

    public String getDateVend() {
        return this.dateVend;
    }

    public void setDateVend(String dateVend) {
        this.dateVend = dateVend;
    }

    public String getDateSem() {
        return this.dateSem;
    }

    public void setDateSem(String dateSem) {
        this.dateSem = dateSem;
    }

    public int getNumJour() {
        return this.numJour;
    }

    public void setNumJour(int numJour) {
        this.numJour = numJour;
    }

    public String getMois() {
        return this.mois;
    }

    public void setMois(String mois) {
        this.mois = mois;
    }

    public String[] getTablListSaisie() {
        return this.tablListSaisie;
    }

    public void setTablListSaisie(String[] tablListSaisie) {
        this.tablListSaisie = tablListSaisie;
    }

    public boolean isVoisListSaisie() {
        return this.voisListSaisie;
    }

    public void setVoisListSaisie(boolean voisListSaisie) {
        this.voisListSaisie = voisListSaisie;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public String getNomTache() {
        return this.nomTache;
    }

    public void setNomTache(String nomTache) {
        this.nomTache = nomTache;
    }

    public String getNomProjet() {
        return this.nomProjet;
    }

    public void setNomProjet(String nomProjet) {
        this.nomProjet = nomProjet;
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setEditable(boolean editable) {
        this.editable = editable;
    }

    public int getIdCollab() {
        return this.idCollab;
    }

    public void setIdCollab(int idCollab) {
        this.idCollab = idCollab;
    }

    public List<ProjetTO> getAllProjetPrAdmin() {
        return this.allProjetPrAdmin;
    }

    public void setAllProjetPrAdmin(List<ProjetTO> allProjetPrAdmin) {
        this.allProjetPrAdmin = allProjetPrAdmin;
    }
}

