/*
 * Decompiled with CFR 0.152.
 */
package org.jeinnov.jeitime.ui.projet;

import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.jeinnov.jeitime.api.service.projet.DomaineManager;
import org.jeinnov.jeitime.api.service.projet.ProjetException;
import org.jeinnov.jeitime.api.to.projet.DomaineTO;
import org.ow2.opensuit.core.error.IError;
import org.ow2.opensuit.core.error.NonLocalizedError;

public class DomaineUIBean {
    private DomaineManager domaineManager = DomaineManager.getInstance();
    private int idDom;
    private String nomDom;
    private DomaineTO selected;
    private List<DomaineTO> allDomaine;
    private List<String> domCir;

    public void loadAll() {
        this.allDomaine = new ArrayList();
        this.allDomaine = this.domaineManager.getAll();
        this.domCir = this.getDomaineCir();
    }

    public List<String> getDomaineCir() {
        ArrayList<String> recup = new ArrayList<String>();
        recup.add("Informatique,Electronique");
        recup.add("Biologie,Botanique");
        recup.add("Sciences m\u00e9dicales");
        recup.add("Math\u00e9matiques,Physique fondamentale");
        recup.add("Sciences agronomiques et alimentaires");
        recup.add("Oc\u00e9an, Atmosph\u00e8re, Terre, Environnement naturel");
        recup.add("Energ\u00e9tique,Thermique,");
        recup.add("...");
        return recup;
    }

    public void create() throws IError {
        DomaineTO dom = new DomaineTO(this.idDom, this.nomDom);
        try {
            this.domaineManager.saveOrUpdate(dom);
        }
        catch (ProjetException e) {
            NonLocalizedError error = new NonLocalizedError("Attention : ", "Une erreur est survenue, le domaine n'a pas pu etre sauvegard\u00e9. Un autre domaine existe peut-\u00eatre d\u00e9j\u00e0 avec ce nom. ", (Throwable)e);
            error.setType((short)0);
            throw error;
        }
        this.refresh();
    }

    public void update() throws IError {
        int id = this.selected.getIdDomaine();
        String nom = this.selected.getNomDomaine();
        DomaineTO dom = new DomaineTO(id, nom);
        try {
            this.domaineManager.saveOrUpdate(dom);
        }
        catch (ProjetException e) {
            NonLocalizedError error = new NonLocalizedError("Attention : ", "Une erreur est survenue. Le domaine n'a pas pu \u00eatre sauvegard\u00e9.Le domaine avec ce  nom existe peut-\u00eatre d\u00e9j\u00e0 dans la base.", (Throwable)e);
            error.setType((short)0);
            throw error;
        }
        this.refresh();
    }

    public void delete(HttpServletRequest iRequest) throws IError {
        int id = Integer.parseInt(iRequest.getParameter("ID"));
        try {
            this.domaineManager.delete(id);
        }
        catch (ProjetException e) {
            NonLocalizedError error = new NonLocalizedError("Attention : ", "Une erreur est survenue, le domaine n'a pas pu \u00eatre supprim\u00e9.", (Throwable)e);
            error.setType((short)0);
            throw error;
        }
        this.refresh();
    }

    public void cancel() {
        this.selected = null;
    }

    public void refresh() {
        this.idDom = 0;
        this.nomDom = null;
        this.selected = null;
        this.allDomaine = new ArrayList();
        this.allDomaine = this.domaineManager.getAll();
    }

    public void select(HttpServletRequest iRequest) throws IError {
        this.selected = null;
        int id = Integer.parseInt(iRequest.getParameter("ID"));
        try {
            this.selected = this.domaineManager.get(id);
        }
        catch (ProjetException e) {
            NonLocalizedError error = new NonLocalizedError("Attention : ", "Une erreur est survenue, le domaine n'a pas pu \u00eatre charg\u00e9", (Throwable)e);
            error.setType((short)0);
            throw error;
        }
    }

    public boolean isInProject(int id) throws ProjetException {
        boolean verif = this.domaineManager.isInProject(id);
        return verif;
    }

    public List<DomaineTO> getAllDomaine() {
        return this.allDomaine;
    }

    public void setAllDomaine(List<DomaineTO> allDomaine) {
        this.allDomaine = allDomaine;
    }

    public DomaineTO getSelected() {
        return this.selected;
    }

    public int getIdDom() {
        return this.idDom;
    }

    public void setIdDom(int idDom) {
        this.idDom = idDom;
    }

    public String getNomDom() {
        return this.nomDom;
    }

    public void setNomDom(String nomDom) {
        this.nomDom = nomDom;
    }

    public List<String> getDomCir() {
        return this.domCir;
    }
}

