/*
 * Decompiled with CFR 0.152.
 */
package org.jeinnov.jeitime.ui.projet;

import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;
import org.jeinnov.jeitime.api.service.projet.ClientPartManager;
import org.jeinnov.jeitime.api.service.projet.ContratManager;
import org.jeinnov.jeitime.api.service.projet.DomaineManager;
import org.jeinnov.jeitime.api.service.projet.ProjetException;
import org.jeinnov.jeitime.api.service.projet.ProjetManager;
import org.jeinnov.jeitime.api.service.projet.TacheManager;
import org.jeinnov.jeitime.api.service.projet.ThematiqueManager;
import org.jeinnov.jeitime.api.service.projet.TypeProjetManager;
import org.jeinnov.jeitime.api.to.affecter.RecapAffectTO;
import org.jeinnov.jeitime.api.to.projet.ClientPartTO;
import org.jeinnov.jeitime.api.to.projet.DomaineTO;
import org.jeinnov.jeitime.api.to.projet.ProjetTO;
import org.jeinnov.jeitime.api.to.projet.TacheTO;
import org.jeinnov.jeitime.api.to.projet.ThematiqueTO;
import org.jeinnov.jeitime.api.to.projet.TypeProjetTO;
import org.ow2.opensuit.core.error.IError;
import org.ow2.opensuit.core.error.NonLocalizedError;
import org.ow2.opensuit.core.validation.LocalizedValidationError;
import org.ow2.opensuit.core.validation.ValidationError;
import org.ow2.opensuit.core.validation.ValidationErrors;

public class ProjetUIBean {
    private final Logger logger = Logger.getLogger(this.getClass());
    private ProjetManager projetManager = ProjetManager.getInstance();
    private int idProjet;
    private String nomProjet;
    private Date dateDebu;
    private Date dateFin;
    private Date dateCloture;
    private Date dateFermeture;
    private String budgeprevu = "0";
    private String tpsprevu = "0";
    private String sousProjet;
    private List<TypeProjetTO> allTypPro;
    private int idTypPro;
    private String nomTypPro;
    private List<DomaineTO> allDom;
    private int idDom;
    private String nomDom;
    private List<ThematiqueTO> allThema;
    private int idThema;
    private String nomThem;
    private List<ClientPartTO> allCliPart;
    private List<ClientPartTO> allCliPartSelect;
    private int idCliPart;
    private int typeCli;
    private static int[] ALL_TYPESCLI = new int[]{0, 1};
    private List<TacheTO> alltache;
    private List<RecapAffectTO> listRecapAffect;
    private ProjetTO projet;
    private List<ProjetTO> projets;
    private int idSousProjet;

    public void load() throws IError {
        this.allTypPro = new ArrayList();
        this.allTypPro = TypeProjetManager.getInstance().getAll();
        if (this.allTypPro == null || this.allTypPro.isEmpty()) {
            NonLocalizedError error = new NonLocalizedError("Attention : ", "Vous ne pouvez pas cr\u00e9er un nouveau projet, il faut au pr\u00e9alable avoir cr\u00e9\u00e9 au moins un type de projet");
            error.setType((short)0);
            throw error;
        }
        this.allDom = new ArrayList();
        DomaineTO aucunDom = new DomaineTO();
        aucunDom.setIdDomaine(0);
        aucunDom.setNomDomaine("Non Concern\u00e9");
        this.allDom = DomaineManager.getInstance().getAll();
        this.allDom.add(0, aucunDom);
        this.allThema = new ArrayList();
        ThematiqueTO aucuneThema = new ThematiqueTO();
        aucuneThema.setIdThema(0);
        aucuneThema.setNomThema("aucun \u00e9l\u00e9ment s\u00e9lectionn\u00e9");
        this.allThema = ThematiqueManager.getInstance().getAll();
        this.allThema.add(0, aucuneThema);
        this.allCliPart = new ArrayList();
        ClientPartTO aucunCliPart = new ClientPartTO();
        aucunCliPart.setIdClientPart(0);
        aucunCliPart.setNomClientPart("aucun \u00e9l\u00e9ment s\u00e9lectionn\u00e9");
        this.allCliPart = ClientPartManager.getInstance().getAll();
        this.allCliPart.add(0, aucunCliPart);
        this.projets = new ArrayList();
        ProjetTO aucunProjet = new ProjetTO();
        aucunProjet.setIdProjet(0);
        aucunProjet.setNomProjet("aucun \u00e9l\u00e9ment s\u00e9lectionn\u00e9");
        this.projets = this.projetManager.getAll();
        this.projets.add(0, aucunProjet);
    }

    public void create(int idP) throws IError, ValidationErrors {
        NumberFormat nf = NumberFormat.getInstance(Locale.FRANCE);
        float budget = 0.0f;
        float tmps = 0.0f;
        try {
            budget = Float.parseFloat(this.budgeprevu);
        }
        catch (Exception e) {
            try {
                budget = nf.parse(this.budgeprevu).floatValue();
            }
            catch (ParseException pe) {
                this.logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        try {
            tmps = Float.parseFloat(this.tpsprevu);
        }
        catch (Exception e) {
            try {
                tmps = nf.parse(this.tpsprevu).floatValue();
            }
            catch (ParseException pe) {
                this.logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        this.projet = new ProjetTO(idP, this.nomProjet, this.dateDebu, this.dateFin, this.dateCloture, this.dateFermeture, budget, tmps, new TypeProjetTO(this.idTypPro), new DomaineTO(this.idDom), new ThematiqueTO(this.idThema), new ProjetTO(this.idSousProjet));
        try {
            this.projetManager.saveOrUpdate(this.projet);
        }
        catch (ProjetException e) {
            NonLocalizedError error = new NonLocalizedError("Attention : ", "Une erreur est survenue, le projet n'a pas pu etre sauvegard\u00e9. Un autre projet existe peut-\u00eatre d\u00e9j\u00e0 avec ce nom. ", (Throwable)e);
            error.setType((short)0);
            throw error;
        }
    }

    public void addCliPart(int idProjetTmp) throws IError {
        for (int i = 0; i < this.allCliPartSelect.size(); ++i) {
            int idCliPartTmp = ((ClientPartTO)this.allCliPartSelect.get(i)).getIdClientPart();
            int typeCliTmp = ((ClientPartTO)this.allCliPartSelect.get(i)).getType();
            try {
                ContratManager.getInstance().save(idProjetTmp, idCliPartTmp, typeCliTmp);
                continue;
            }
            catch (ProjetException e) {
                NonLocalizedError error = new NonLocalizedError("Attention : ", "Une erreur est survenue. Le contrat n'a pas pu \u00eatre enregistr\u00e9.", (Throwable)e);
                error.setType((short)0);
                throw error;
            }
        }
    }

    public void search(HttpServletRequest iRequest) throws IError, ProjetException {
        int id = Integer.parseInt(iRequest.getParameter("id"));
        try {
            this.projet = this.projetManager.get(id);
        }
        catch (ProjetException e) {
            NonLocalizedError error = new NonLocalizedError("Attention : ", "Une erreur est survenue, le projet n'a pas pu \u00eatre charg\u00e9", (Throwable)e);
            error.setType((short)0);
            throw error;
        }
        this.allCliPartSelect = ContratManager.getInstance().getClientPartByProjectIdInContrat(id);
        this.idProjet = this.projet.getIdProjet();
        this.nomProjet = this.projet.getNomProjet();
        this.dateDebu = this.projet.getDateDeb();
        this.dateFin = this.projet.getDateFin();
        this.budgeprevu = String.valueOf(this.projet.getBudgeprevu());
        this.tpsprevu = String.valueOf(this.projet.getTpsprevu());
        this.idTypPro = this.projet.getTypeProjet().getIdTypeProj();
        this.nomTypPro = this.projet.getTypeProjet().getNomTypePro();
        ProjetTO proj = this.projet.getProjet();
        if (proj != null) {
            this.idSousProjet = this.projet.getProjet().getIdProjet();
            this.sousProjet = this.projet.getProjet().getNomProjet();
        } else {
            this.idSousProjet = 0;
            this.sousProjet = "Aucun Projet n'est rattach\u00e9";
        }
        ThematiqueTO thema = this.projet.getThematique();
        if (thema != null) {
            this.idThema = this.projet.getThematique().getIdThema();
            this.nomThem = this.projet.getThematique().getNomThema();
        } else {
            this.idThema = 0;
            this.nomThem = "Aucune Th\u00e9matique n'est rattach\u00e9e";
        }
        DomaineTO dom = this.projet.getDomaine();
        if (dom != null) {
            this.idDom = this.projet.getDomaine().getIdDomaine();
            this.nomDom = this.projet.getDomaine().getNomDomaine();
        } else {
            this.idDom = 0;
            this.nomDom = "Aucun Domaine n'est rattach\u00e9";
        }
        this.alltache = TacheManager.getInstance().getAllTacheInProject(id);
        this.calculBudget(this.alltache);
    }

    public void calculBudget(List<TacheTO> alltaches) {
        this.budgeprevu = null;
        this.tpsprevu = null;
        this.alltache = alltaches;
        float budget = 0.0f;
        for (int i = 0; i < this.alltache.size(); ++i) {
            budget += ((TacheTO)this.alltache.get(i)).getBudgetprevu();
        }
        this.budgeprevu = String.valueOf(budget);
        float tmps = 0.0f;
        for (int i = 0; i < this.alltache.size(); ++i) {
            tmps += ((TacheTO)this.alltache.get(i)).getTpsprevu();
        }
        this.tpsprevu = String.valueOf(tmps);
    }

    public void cancel() {
    }

    public void selectCli(int typeCli, int idProjetTmp) throws ValidationErrors, IError {
        int id = this.idCliPart;
        if (id != 0) {
            ClientPartTO clientPart;
            try {
                clientPart = ClientPartManager.getInstance().get(id);
            }
            catch (ProjetException e) {
                NonLocalizedError error = new NonLocalizedError("Attention : ", "Une erreur est survenue. Le client/partenaire n'a pas pu \u00eatre charg\u00e9.", (Throwable)e);
                error.setType((short)0);
                throw error;
            }
            clientPart.setType(typeCli);
            this.allCliPartSelect.add(clientPart);
        } else {
            ValidationErrors errors = new ValidationErrors();
            errors.addItemError("projetBean.idCliPart", (ValidationError)new LocalizedValidationError("validation.client"));
        }
        this.addCliPart(idProjetTmp);
    }

    public void deselecteCli(HttpServletRequest iRequest, int idProjetTmp) throws IError {
        int id = Integer.parseInt(iRequest.getParameter("id"));
        for (int i = 0; i < this.allCliPartSelect.size(); ++i) {
            if (((ClientPartTO)this.allCliPartSelect.get(i)).getIdClientPart() != id) continue;
            this.allCliPartSelect.remove(i);
            break;
        }
        this.supprLienCli(id, idProjetTmp);
    }

    public void supprLienCli(int idCliPartTmp, int idProjetTmp) throws IError {
        try {
            ContratManager.getInstance().delete(idProjetTmp, idCliPartTmp);
        }
        catch (ProjetException e) {
            NonLocalizedError error = new NonLocalizedError("Attention : ", "Une erreur est survenue. Le contrat n'a pas pu \u00eatre supprim\u00e9.", (Throwable)e);
            error.setType((short)0);
            throw error;
        }
    }

    public void deselectColl(HttpServletRequest iRequest) {
        int id = Integer.parseInt(iRequest.getParameter("id"));
        for (int i = 0; i < this.listRecapAffect.size(); ++i) {
            if (((RecapAffectTO)this.listRecapAffect.get(i)).getCollaborateur().getIdColl() != id) continue;
            this.listRecapAffect.remove(i);
            break;
        }
    }

    public void validate() throws ValidationErrors {
        ValidationErrors errors = new ValidationErrors();
        if (this.dateDebu != null && this.dateFin != null && this.dateFin.before(this.dateDebu)) {
            errors.addItemError("projetBean.dateFin", (ValidationError)new LocalizedValidationError("validation.date"));
        }
        if (errors.hasErrors()) {
            throw errors;
        }
    }

    public boolean isInLienTach(int id) {
        boolean verif = this.projetManager.isInLienTachUtil(id);
        return verif;
    }

    public String getNomProjet() {
        return this.nomProjet;
    }

    public void setNomProjet(String nomProjet) {
        this.nomProjet = nomProjet;
    }

    public Date getDateDebu() {
        return this.dateDebu;
    }

    public void setDateDebu(Date dateDebu) {
        this.dateDebu = dateDebu;
    }

    public Date getDateFin() {
        return this.dateFin;
    }

    public void setDateFin(Date dateFin) {
        this.dateFin = dateFin;
    }

    public Date getDateCloture() {
        return this.dateCloture;
    }

    public void setDateCloture(Date dateCloture) {
        this.dateCloture = dateCloture;
    }

    public Date getDateFermeture() {
        return this.dateFermeture;
    }

    public void setDateFermeture(Date dateFermeture) {
        this.dateFermeture = dateFermeture;
    }

    public int getIdProjet() {
        return this.idProjet;
    }

    public void setIdProjet(int idProjet) {
        this.idProjet = idProjet;
    }

    public String getBudgeprevu() {
        return this.budgeprevu;
    }

    public void setBudgeprevu(String budgeprevu) {
        this.budgeprevu = budgeprevu;
    }

    public String getTpsprevu() {
        return this.tpsprevu;
    }

    public void setTpsprevu(String tpsprevu) {
        this.tpsprevu = tpsprevu;
    }

    public List<TypeProjetTO> getAllTypPro() {
        return this.allTypPro;
    }

    public void setAllTypPro(List<TypeProjetTO> allTypPro) {
        this.allTypPro = allTypPro;
    }

    public int getIdTypPro() {
        return this.idTypPro;
    }

    public void setIdTypPro(int idTypPro) {
        this.idTypPro = idTypPro;
    }

    public List<DomaineTO> getAllDom() {
        return this.allDom;
    }

    public void setAllDom(List<DomaineTO> allDom) {
        this.allDom = allDom;
    }

    public int getIdDom() {
        return this.idDom;
    }

    public void setIdDom(int idDom) {
        this.idDom = idDom;
    }

    public List<ThematiqueTO> getAllThema() {
        return this.allThema;
    }

    public void setAllThema(List<ThematiqueTO> allThema) {
        this.allThema = allThema;
    }

    public int getIdThema() {
        return this.idThema;
    }

    public void setIdThema(int idThema) {
        this.idThema = idThema;
    }

    public List<ClientPartTO> getAllCliPart() {
        return this.allCliPart;
    }

    public void setAllCliPart(List<ClientPartTO> allCliPart) {
        this.allCliPart = allCliPart;
    }

    public List<ClientPartTO> getAllCliPartSelect() {
        return this.allCliPartSelect;
    }

    public void setAllCliPartSelect(List<ClientPartTO> allCliPartSelect) {
        this.allCliPartSelect = allCliPartSelect;
    }

    public int getIdCliPart() {
        return this.idCliPart;
    }

    public void setIdCliPart(int idCliPart) {
        this.idCliPart = idCliPart;
    }

    public List<TacheTO> getAlltache() {
        return this.alltache;
    }

    public void setAlltache(List<TacheTO> alltache) {
        this.alltache = alltache;
    }

    public ProjetTO getProjet() {
        return this.projet;
    }

    public void setProjet(ProjetTO projet) {
        this.projet = projet;
    }

    public int getTypeCli() {
        return this.typeCli;
    }

    public void setTypeCli(int typeCli) {
        this.typeCli = typeCli;
    }

    public static int[] getAllTypesCli() {
        return ALL_TYPESCLI;
    }

    public List<ProjetTO> getProjets() {
        return this.projets;
    }

    public void setProjets(List<ProjetTO> projets) {
        this.projets = projets;
    }

    public String getNomTypPro() {
        return this.nomTypPro;
    }

    public void setNomTypPro(String nomTypPro) {
        this.nomTypPro = nomTypPro;
    }

    public String getNomDom() {
        return this.nomDom;
    }

    public void setNomDom(String nomDom) {
        this.nomDom = nomDom;
    }

    public String getNomThem() {
        return this.nomThem;
    }

    public void setNomThem(String nomThem) {
        this.nomThem = nomThem;
    }

    public String getSousProjet() {
        return this.sousProjet;
    }

    public void setSousProjet(String sousProjet) {
        this.sousProjet = sousProjet;
    }

    public int getIdSousProjet() {
        return this.idSousProjet;
    }

    public void setIdSousProjet(int idSousProjet) {
        this.idSousProjet = idSousProjet;
    }
}

