/*
 * Decompiled with CFR 0.152.
 */
package org.jeinnov.jeitime.ui.projet;

import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.jeinnov.jeitime.api.service.projet.ProjetException;
import org.jeinnov.jeitime.api.service.projet.ThematiqueManager;
import org.jeinnov.jeitime.api.to.projet.ThematiqueTO;
import org.ow2.opensuit.core.error.IError;
import org.ow2.opensuit.core.error.NonLocalizedError;

public class ThematiqueUIBean {
    private ThematiqueManager thematiqueManager = ThematiqueManager.getInstance();
    private int idThema;
    private String nomThema;
    private ThematiqueTO selected;
    private List<ThematiqueTO> allThema;
    private List<String> themat;

    public void load() {
        this.allThema = new ArrayList();
        this.allThema = this.thematiqueManager.getAll();
    }

    public List<String> getThema() {
        ArrayList<String> recup = new ArrayList<String>();
        recup.add("Thematique 1");
        recup.add("Thematique 2");
        recup.add("Thematique 3");
        recup.add("Thematique 4");
        recup.add("Thematique 5");
        return recup;
    }

    public void create() throws IError {
        ThematiqueTO thema = new ThematiqueTO(this.idThema, this.nomThema);
        try {
            this.thematiqueManager.saveOrUpdate(thema);
        }
        catch (ProjetException e) {
            NonLocalizedError error = new NonLocalizedError("Attention : ", "Une erreur est survenue. La th\u00e9matique n'a pas pu \u00eatre sauvegard\u00e9e.Une th\u00e9matique avec ce  nom existe peut-\u00eatre d\u00e9j\u00e0 dans la base.", (Throwable)e);
            error.setType((short)0);
            throw error;
        }
        this.refresh();
    }

    public void update() throws IError {
        int id = this.selected.getIdThema();
        String nom = this.selected.getNomThema();
        ThematiqueTO thema = new ThematiqueTO(id, nom);
        try {
            this.thematiqueManager.saveOrUpdate(thema);
        }
        catch (ProjetException e) {
            NonLocalizedError error = new NonLocalizedError("Attention : ", "Une erreur est survenue. La th\u00e9matique n'a pas pu \u00eatre sauvegard\u00e9e.Une th\u00e9matique avec ce  nom existe peut-\u00eatre d\u00e9j\u00e0 dans la base.", (Throwable)e);
            error.setType((short)0);
            throw error;
        }
        this.refresh();
    }

    public void delete(HttpServletRequest iRequest) throws IError {
        int id = Integer.parseInt(iRequest.getParameter("ID"));
        try {
            this.thematiqueManager.delete(id);
        }
        catch (ProjetException e) {
            NonLocalizedError error = new NonLocalizedError("Attention : ", "Une erreur est survenue. La th\u00e9matique s\u00e9lectionn\u00e9e n'a pas pu \u00eatre supprim\u00e9e", (Throwable)e);
            error.setType((short)0);
            throw error;
        }
        this.refresh();
    }

    public void cancel() {
        this.selected = null;
    }

    public void refresh() {
        this.idThema = 0;
        this.nomThema = null;
        this.selected = null;
        this.allThema = new ArrayList();
        this.allThema = this.thematiqueManager.getAll();
    }

    public void select(HttpServletRequest iRequest) throws IError {
        this.selected = null;
        int id = Integer.parseInt(iRequest.getParameter("ID"));
        try {
            this.selected = this.thematiqueManager.get(id);
        }
        catch (ProjetException e) {
            NonLocalizedError error = new NonLocalizedError("Attention : ", "Une erreur est survenue. La th\u00e9matique s\u00e9lectionn\u00e9e n'a pas pu \u00eatre charg\u00e9e.", (Throwable)e);
            error.setType((short)0);
            throw error;
        }
    }

    public boolean isInProject(int id) throws ProjetException {
        boolean verif = this.thematiqueManager.isInProject(id);
        return verif;
    }

    public List<ThematiqueTO> getAllThema() {
        return this.allThema;
    }

    public void setAllThema(List<ThematiqueTO> allThema) {
        this.allThema = allThema;
    }

    public ThematiqueTO getSelected() {
        return this.selected;
    }

    public int getIdThema() {
        return this.idThema;
    }

    public void setIdThema(int idThema) {
        this.idThema = idThema;
    }

    public String getNomThema() {
        return this.nomThema;
    }

    public void setNomThema(String nomThema) {
        this.nomThema = nomThema;
    }

    public List<String> getThemat() {
        return this.themat;
    }
}

