/**
 * PETALS - PETALS Services Platform.
 * Copyright (c) 2008 OW2 consortium (www.ow2.org)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * $Id: XMLUtil.java 98 2006-02-24 16:18:48Z alouis $
 * -------------------------------------------------------------------------
 */

package org.ow2.easywsdl.extensions.wsdl4complexwsdl;

import org.ow2.easywsdl.extensions.wsdl4complexwsdl.api.WSDL4ComplexWsdlReader;

import com.ebmwebsourcing.easycommons.pooling.PoolException;
import com.ebmwebsourcing.easycommons.pooling.PoolPolicy;

/**
 * A static pool of {@link WSDL4ComplexWsdlReader} to improve {@link WSDL4ComplexWsdlReader} creation efficiency. 
 * A {@link WSDL4ComplexWsdlReader} is initialized the first time this class is used.
 * An infinite number (integer maximum value) of {@link WSDL4ComplexWsdlReader} may be created. They are never evicted.
 * 
 * @ author noddoux
 */
public final class WSDL4ComplexWsdlReaders {

    private static final WSDL4ComplexWsdlReaderResourcePool wsdl4ComplexWsdlReaderResourcePool = new WSDL4ComplexWsdlReaderResourcePool(1, Integer.MAX_VALUE, PoolPolicy.WAIT);

    /**
     * Take a {@link WSDL4ComplexWsdlReader} from the pool
     * 
     * @return one {@link WSDL4ComplexWsdlReader}
     * 
     * @throws PoolException
     *             if the current thread waits for a {@link WSDL4ComplexWsdlReader}
     *             of the pool and is interrupted
     */
    public final static WSDL4ComplexWsdlReader takeWSDL4ComplexWsdlReader() throws PoolException {
       return wsdl4ComplexWsdlReaderResourcePool.take();
    }

    /**
     * Release a {@link WSDL4ComplexWsdlReader} to the pool
     * 
     * @param wsdl4ComplexWsdlReader a {@link WSDL4ComplexWsdlReader} to release
     */
    public final static void releaseWSDL4ComplexWsdlReader(WSDL4ComplexWsdlReader wsdl4ComplexWsdlReader) {
        wsdl4ComplexWsdlReaderResourcePool.release(wsdl4ComplexWsdlReader);
    }
}
