package org.ow2.easywsdl.tooling.xsd2xml;

import java.util.HashMap;
import java.util.Map;

import org.ow2.easywsdl.schema.DefaultSchemaImpl;
import org.ow2.easywsdl.schema.api.SchemaException;
import org.ow2.easywsdl.schema.api.Type;
import org.ow2.easywsdl.schema.api.absItf.AbsItfElement;
import org.ow2.easywsdl.schema.org.w3._2001.xmlschema.FormChoice;

public abstract class XSD2XML {

	
	public static XSD2XML newInstance() {
		return new XSD2XMLImpl();
	}
	
    public abstract String printXml(final AbsItfElement e, Object value) throws SchemaException;
    
    public abstract String printXml(final AbsItfElement e, Map<Type, Object> value, boolean createOptionalElement, boolean createOptionalAttribute) throws SchemaException;
    
    public abstract org.jdom.Element generateElement(final AbsItfElement eIn, final Object values) throws SchemaException;
    
    public abstract org.jdom.Element generateElement(AbsItfElement eIn, Map<Type, Object> values, FormChoice form, int minOccurs, boolean createOptionalElement, boolean createOptionalAttribute)
	throws SchemaException;
    
    public abstract org.jdom.Element addMinOccursEqual0OrArrayElement(final AbsItfElement childDefinition, final org.jdom.Element parentElement) throws SchemaException;
    
    
    public static Map<Type, Object> createDefaultMap(Object value) {
    	Map<Type, Object> values = new HashMap<Type, Object>();
    	for(Type type: DefaultSchemaImpl.getInstance().getTypes()) {
    		values.put(type, value);
    	}
    	return values;
    }
}
