package org.ow2.easywsdl.tooling.xsd2xml;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import org.jdom.Attribute;
import org.jdom.Element;
import org.jdom.Namespace;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.ow2.easywsdl.schema.api.ComplexType;
import org.ow2.easywsdl.schema.api.SchemaException;
import org.ow2.easywsdl.schema.api.Type;
import org.ow2.easywsdl.schema.api.absItf.AbsItfAttribute;
import org.ow2.easywsdl.schema.api.absItf.AbsItfComplexType;
import org.ow2.easywsdl.schema.api.absItf.AbsItfElement;
import org.ow2.easywsdl.schema.api.absItf.AbsItfSchema;
import org.ow2.easywsdl.schema.api.absItf.AbsItfType;
import org.ow2.easywsdl.schema.api.absItf.AbsItfAttribute.Use;
import org.ow2.easywsdl.schema.api.abstractElmt.AbstractAttributeImpl;
import org.ow2.easywsdl.schema.api.abstractElmt.AbstractElementImpl;
import org.ow2.easywsdl.schema.api.abstractElmt.AbstractSchemaElementImpl;
import org.ow2.easywsdl.schema.org.w3._2001.xmlschema.FormChoice;

public class XSD2XMLImpl extends XSD2XML {

	private Namespace xsi = Namespace.getNamespace("xsi", "http://www.w3.org/2001/XMLSchema-instance");

	@Override
	public Element generateElement(AbsItfElement eIn, Object value) throws SchemaException {
		Element res = null;
		if(eIn != null) {
			Map<Type, Object> values = null;
			if(value == null) {
				values = XSD2XML.createDefaultMap("");
			} else {
				values = XSD2XML.createDefaultMap(value);
			}
			res = this.generateElement(eIn, values, ((AbstractElementImpl) eIn).getSchema().getElementFormDefault(), 1, false, false);
		}
		return res;
	}


	public Element generateElement(AbsItfElement eIn, Map<Type, Object> values, FormChoice form, int minOccurs, boolean createOptionalElement, boolean createOptionalAttribute)
	throws SchemaException {
		if(values == null) {
			values = this.createDefaultMap("");
		}

		// create element
		org.jdom.Element eOut = null;

		if(minOccurs > 0) {
			Namespace ns = org.jdom.Namespace.getNamespace(eIn.getQName().getPrefix(), 
					  eIn.getQName().getNamespaceURI());
			
			if (((AbstractSchemaElementImpl) eIn).getParent() instanceof AbsItfSchema) {
				// top level element
				eOut = new org.jdom.Element(eIn.getQName().getLocalPart(), eIn.getQName().getPrefix(), eIn.getQName().getNamespaceURI());
			} else {
				eOut = new org.jdom.Element(eIn.getQName().getLocalPart());
			}
			
			if(form == FormChoice.QUALIFIED) {
				eOut.setNamespace(org.jdom.Namespace.getNamespace(eIn.getQName().getPrefix(), 
								  eIn.getQName().getNamespaceURI()));
			} 


			// if complextype, generate under element
			if (((AbstractElementImpl) eIn).getType() instanceof ComplexType) {
				if ((((org.ow2.easywsdl.schema.impl.ComplexTypeImpl) ((AbstractElementImpl) eIn)
						.getType()).getModel()) != null) {

					List<org.ow2.easywsdl.schema.api.Element> items = null;

					if ((((org.ow2.easywsdl.schema.impl.ComplexTypeImpl) ((AbstractElementImpl) eIn)
							.getType())).getSequence() != null) {
						// if sequence
						items = (((org.ow2.easywsdl.schema.impl.ComplexTypeImpl) ((AbstractElementImpl) eIn)
								.getType())).getSequence().getElements();
					} else if ((((org.ow2.easywsdl.schema.impl.ComplexTypeImpl) ((AbstractElementImpl) eIn)
							.getType())).getAll() != null) {
						// if all
						items = (((org.ow2.easywsdl.schema.impl.ComplexTypeImpl) ((AbstractElementImpl) eIn)
								.getType())).getAll().getElements();
					} else if((((org.ow2.easywsdl.schema.impl.ComplexTypeImpl) ((AbstractElementImpl) eIn)
							.getType())).getComplexContent() != null && (((org.ow2.easywsdl.schema.impl.ComplexTypeImpl) ((AbstractElementImpl) eIn)
									.getType())).getComplexContent().getExtension() != null) {
						// TODO: generate all inherited elements
						items = getAllElementFindInAllInheritedParent((((org.ow2.easywsdl.schema.impl.ComplexTypeImpl) ((AbstractElementImpl) eIn)
								.getType())).getComplexContent().getExtension().getBase());
						
						
						// generate elements in extension
						if((((org.ow2.easywsdl.schema.impl.ComplexTypeImpl) ((AbstractElementImpl) eIn)
								.getType())).getComplexContent().getExtension().getSequence() != null) {
							items.addAll((((org.ow2.easywsdl.schema.impl.ComplexTypeImpl) ((AbstractElementImpl) eIn)
									.getType())).getComplexContent().getExtension().getSequence().getElements());
						}
					}

					if (items != null) {
						for (final org.ow2.easywsdl.schema.api.Element item : items) {

							// is element
							if (item.getRef() == null) {
								// is an element
								final AbsItfElement e = item;
								FormChoice elmtFrom = null;
								//System.out.println("e.getQName() = " + e.getQName());
								//System.out.println("e.getForm() = " + e.getForm());
								if(e.getForm() != null) {
									elmtFrom = e.getForm();
								} else {
									elmtFrom = form;
								}
								int minOccursChildElmt = e.getMinOccurs();
								if(createOptionalElement == true && minOccursChildElmt == 0) {
									minOccursChildElmt = 1;
								}
								Element child = (Element) this.generateElement(e,
										values, elmtFrom, minOccursChildElmt, createOptionalElement, createOptionalAttribute);
								if(child != null) {
									eOut.addContent(child.detach());
								}
							} else {
								// is a ref on an element
								final List<AbsItfElement> listE = ((AbstractElementImpl) eIn).getParent().getSchema()
								.findElementsInAllSchema(item.getRef());
								if(listE != null && listE.size() > 0) {
									AbsItfElement e = listE.get(0);

									FormChoice elmtFrom = null;
									if(e.getForm() != null) {
										elmtFrom = e.getForm();
									} else {
										elmtFrom = form;
									}

									int minOccursChildElmt = e.getMinOccurs();
									if(createOptionalElement == true && minOccursChildElmt == 0) {
										minOccursChildElmt = 1;
									}
									Element child = (Element) this.generateElement(e,
											values, elmtFrom, minOccursChildElmt, createOptionalElement, createOptionalAttribute);
									if(child != null) {
										eOut.addContent(child.detach());
									}
								} else {
									throw new SchemaException("Impossible to find element corresponding to this reference: " + item.getRef());
								}
							}
						}

						// handle attribute
						for (final AbsItfAttribute attr : ((ComplexType) ((AbstractElementImpl) eIn)
								.getType()).getAttributes()) {
							org.jdom.Attribute a = null;
							if(Use.REQUIRED.equals(attr.getUse())) {
								a = this.generateAttribute(
										eIn, attr, values);
							} else if(createOptionalAttribute == true){
								a = this.generateAttribute(
										eIn, attr, values);
							}
							if(a != null) {

								eOut.setAttribute(a);
							}
						}

					}
				}
			} else {
				// add value on the simpletype
				final String val = findValue(eIn.getType(), values);
				if ((val != null)&&(!eIn.isNillable())) {
					eOut.setText(val);
				}
			}

			// add attribute to element
			List<Attribute> attrs = generateAttributes(eIn, values, ((AbstractElementImpl) eIn).getSchema().getAttributeFormDefault(), createOptionalAttribute);

			// add type attribute on element
			Attribute typeAttr = null;
			if (((AbstractElementImpl) eIn).getType() != null) {
				String type = null;
				// if not a anonymous type
				if (((AbstractElementImpl) eIn).getType().getQName() != null) {
					String prefix = ((AbstractElementImpl) eIn).getParent().getSchema().getAllNamespaces().getPrefix(
							((AbstractElementImpl) eIn).getType().getQName().getNamespaceURI());
					if (prefix != null) {
						type = prefix 
						+ ":"
						+ ((AbstractElementImpl) eIn).getType().getQName().getLocalPart();
						Namespace typeNs = Namespace.getNamespace(prefix, ((AbstractElementImpl) eIn).getParent().getSchema().getAllNamespaces().getNamespaceURI(prefix));
						eOut.addNamespaceDeclaration(typeNs);
						eOut.addNamespaceDeclaration(xsi);
						typeAttr = new Attribute("type", type, xsi);
					} else {
						type = ((AbstractElementImpl) eIn).getType().getQName().getLocalPart();
						eOut.addNamespaceDeclaration(xsi);
						typeAttr = new Attribute("type", type, xsi);
					}
				}
			}

			if(typeAttr != null) {
				attrs.add(typeAttr);
			}

			eOut.setAttributes(attrs);


			//Document doc = new Document(eOut); 
		}
		return eOut;
	}

	private List<org.ow2.easywsdl.schema.api.Element> getAllElementFindInAllInheritedParent(
			Type base) {
		List<org.ow2.easywsdl.schema.api.Element> res = new ArrayList<org.ow2.easywsdl.schema.api.Element>();
		
		if(base instanceof ComplexType) {
			ComplexType ct = (ComplexType)base;
			if(ct.getAll() != null) {
				res.addAll(ct.getAll().getElements());
			} else if(ct.getSequence() != null) {
				res.addAll(ct.getSequence().getElements());
			} else if(ct.getComplexContent() != null && ct.getComplexContent().getExtension() != null) {
				res.addAll(getAllElementFindInAllInheritedParent(ct.getComplexContent().getExtension().getBase()));
			}
		}
		
		return res;
	}


	private List<Attribute> generateAttributes(AbsItfElement eIn, Map<Type, Object> values,
			FormChoice attributeFormDefault, boolean createOptionalAttribute) {
		List<Attribute> res = new ArrayList<Attribute>();
		if(eIn.getType() instanceof ComplexType) {
			ComplexType ct = (ComplexType) eIn.getType();
			for(org.ow2.easywsdl.schema.api.Attribute attr: ct.getAttributes()) {
				if(Use.REQUIRED.equals(attr.getUse()) || createOptionalAttribute==true) {
					Attribute a = null;
					String prefix = ((AbstractElementImpl) eIn).getSchema().getAllNamespaces().getPrefix(attr.getNamespaceUri());

					if((prefix != null)&& !(attr.getNamespaceUri().equals(eIn.getQName().getNamespaceURI())) && (attributeFormDefault == FormChoice.QUALIFIED)) {
						a = new Attribute(attr.getName(),findValue(attr.getType(), values), Namespace.getNamespace(prefix, attr.getNamespaceUri()));
					} else {
						a = new Attribute(attr.getName(),findValue(attr.getType(), values));
					}
					res.add(a);
				}
				
			}
		}
		return res;
	}


	@SuppressWarnings("unchecked")
	private String findValue(AbsItfType key, final Map<Type, Object> values) {
		String res = null;
		if(values.get(key) != null) {
			res = values.get(key).toString();
		} else {
			res = "";
		}
		return res;
	}


	@SuppressWarnings("unchecked")
	public org.jdom.Attribute generateAttribute(final AbsItfElement eIn, final AbsItfAttribute aIn, final Map<Type, Object> value) {
		org.jdom.Attribute attr = null;
		if (aIn.getName() != null) {
			String prefix = null;
			org.jdom.Namespace ns = null;
			if (!aIn.getNamespaceUri().equals(eIn.getQName().getNamespaceURI())) {
				if (((AbstractElementImpl) eIn).getParent().getSchema().getAllNamespaces().getPrefix(
						aIn.getNamespaceUri()) != null) {
					prefix = ((AbstractElementImpl) eIn).getParent().getSchema().getAllNamespaces().getPrefix(
							aIn.getNamespaceUri());
					ns = org.jdom.Namespace.getNamespace(prefix, aIn.getNamespaceUri());
				}
			}
			if(((AbstractAttributeImpl)aIn).getSchema().getAttributeFormDefault() == FormChoice.QUALIFIED) {
				attr = new org.jdom.Attribute(aIn.getName(), findValue(aIn.getType(), value), ns);
			} else {
				attr = new org.jdom.Attribute(aIn.getName(), findValue(aIn.getType(), value), null);
			}
		}
		return attr;
	}





	@Override
	public String printXml(AbsItfElement e, Object value)
	throws SchemaException {
		final org.jdom.Element eOut = this.generateElement(e, value);
		return new XMLOutputter(Format.getPrettyFormat()).outputString(eOut);
	}


	@Override
	public Element addMinOccursEqual0OrArrayElement(AbsItfElement childDefinition,
			Element parentElement) throws SchemaException {

		// verif if child is nillable or an array element
		String maxOccurs = childDefinition.getMaxOccurs();
		int maxOcc = -1;
		if(maxOccurs == null) {
			maxOcc = 1;
		} else if(maxOccurs.toUpperCase().equals("UNBOUNDED")) {
			maxOcc = 10;
		} else {
			maxOcc = Integer.parseInt(maxOccurs);
		}

		//		System.out.println("childDefinition.getQName() = " + childDefinition.getQName());
		//		System.out.println("maxOcc = " + maxOcc);
		//		System.out.println("childDefinition.getMinOccurs() = " + childDefinition.getMinOccurs());

		Element child = null;
		if(childDefinition.getMinOccurs() == 0 || maxOcc > 1) {

			child = generateElement(childDefinition, this.createDefaultMap(""), ((AbstractElementImpl) childDefinition).getSchema().getElementFormDefault(), 1, false, true);

	//		System.out.println("MY CHILD: \n" + new XMLOutputter(Format.getPrettyFormat()).outputString(child));
			
			// find parent complex type definition
			ComplexType parentType = this.findParentType((AbstractSchemaElementImpl) childDefinition);
			if(parentType.getSequence() != null) {
				addChildInGoodPlace(childDefinition, parentElement, child,
						parentType);
			} else if(parentType.getAll() != null) {
				addChildInGoodPlace(childDefinition, parentElement, child,
						parentType);
			} else {
				parentElement.addContent(child.detach());
			}
		} else {
			throw new SchemaException("this element (" + childDefinition.getQName() + ") is not an array or not minOccurs = 0");
		}

		return child;
	}


	private void addChildInGoodPlace(AbsItfElement childDefinition,
			Element parentElement, Element child, ComplexType parentType) {
		int index = 0;
		Element elmtInP = null;
		for(org.ow2.easywsdl.schema.api.Element elmt: parentType.getSequence().getElements()) {
			if(elmt.getQName().equals(childDefinition.getQName())) {
				List<Element> arrayElmts = parentElement.getChildren(childDefinition.getQName().getLocalPart());
				if(arrayElmts == null || arrayElmts.size() == 0) {
					arrayElmts = parentElement.getChildren(childDefinition.getQName().getLocalPart(), Namespace.getNamespace(childDefinition.getQName().getNamespaceURI()));
				}

				if(arrayElmts != null && arrayElmts.size() > 0) {
					arrayElmts.add((Element) child.detach());
				} else {
					parentElement.addContent(index, child.detach());
				}
				break;
			}
			elmtInP = parentElement.getChild(elmt.getQName().getLocalPart());
			if(elmtInP == null) {
				elmtInP = parentElement.getChild(elmt.getQName().getLocalPart(), Namespace.getNamespace(elmt.getQName().getNamespaceURI()));
			}
			if(elmtInP != null) {
				index++;
			}
		}
	}


	private ComplexType findParentType(AbstractSchemaElementImpl childDefinition) {
		ComplexType parentType = null;
		AbstractSchemaElementImpl parent = ((AbstractSchemaElementImpl)childDefinition).getParent();

		if(parent != null) {
			if(parent instanceof AbsItfElement) {
				parentType = (ComplexType) ((AbsItfElement)parent).getType();
			} else if(parent instanceof AbsItfComplexType) {
				parentType = (ComplexType) ((AbsItfComplexType)parent);
			} else {
				parentType = this.findParentType(parent);
			}
		}

		return parentType;
	}


	@Override
	public String printXml(AbsItfElement eIn, Map<Type, Object> values,
			boolean createOptionalElement, boolean createOptionalAttribute) throws SchemaException {
		final org.jdom.Element eOut = this.generateElement(eIn, values, ((AbstractElementImpl) eIn).getSchema().getElementFormDefault(), 1, createOptionalElement, createOptionalAttribute);
		return new XMLOutputter(Format.getPrettyFormat()).outputString(eOut);
	}




}
