/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easywsdl.tooling.xsd2xml.test;

import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Calendar;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.QName;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.ow2.easywsdl.schema.DefaultSchemaImpl;
import org.ow2.easywsdl.schema.SchemaFactory;
import org.ow2.easywsdl.schema.api.Element;
import org.ow2.easywsdl.schema.api.Schema;
import org.ow2.easywsdl.schema.api.SchemaException;
import org.ow2.easywsdl.schema.api.Type;
import org.ow2.easywsdl.schema.api.absItf.AbsItfElement;
import org.ow2.easywsdl.schema.api.absItf.AbsItfType;
import org.ow2.easywsdl.tooling.xsd2xml.XSD2XML;
import org.ow2.easywsdl.wsdl.WSDLFactory;
import org.ow2.easywsdl.wsdl.api.Description;
import org.ow2.easywsdl.wsdl.api.Types;

public class XSD2XMLTest
extends TestCase {
    private String TARGET_NAMESPACE = "http://petals.ow2.org/";

    public QName cName(String string) {
        return new QName(this.TARGET_NAMESPACE, string);
    }

    public XSD2XMLTest(String string) {
        super(string);
    }

    protected void setUp() throws Exception {
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testReaderSchema() throws URISyntaxException, SchemaException, IOException {
        URL uRL = Thread.currentThread().getContextClassLoader().getResource("descriptors/sample.xsd");
        Schema schema = SchemaFactory.newInstance().newSchemaReader().read(uRL);
        Assert.assertNotNull((Object)schema);
        Assert.assertEquals((int)5, (int)schema.getTypes().size());
        Assert.assertEquals((String)"PurchaseOrderType", (String)((Type)schema.getTypes().get(0)).getQName().getLocalPart());
        Assert.assertEquals((String)"USAddress", (String)((Type)schema.getTypes().get(1)).getQName().getLocalPart());
        Assert.assertEquals((String)"Items", (String)((Type)schema.getTypes().get(2)).getQName().getLocalPart());
        Assert.assertEquals((String)"SKU", (String)((Type)schema.getTypes().get(3)).getQName().getLocalPart());
        Assert.assertEquals((int)2, (int)schema.getElements().size());
        Assert.assertEquals((String)"purchaseOrder", (String)((Element)schema.getElements().get(0)).getQName().getLocalPart());
        Assert.assertEquals((String)"comment", (String)((Element)schema.getElements().get(1)).getQName().getLocalPart());
    }

    public void testImportSchema() throws URISyntaxException, SchemaException, IOException {
        URL uRL = Thread.currentThread().getContextClassLoader().getResource("descriptors/reservationList.xsd");
        Schema schema = SchemaFactory.newInstance().newSchemaReader().read(uRL);
        Assert.assertNotNull((Object)schema);
    }

    public void testCreateElmtSchema() throws URISyntaxException, SchemaException {
        Schema schema = SchemaFactory.newInstance().newSchema();
        schema.setTargetNamespace("http://petals.ow2.org/");
        Element element = (Element)schema.createElement();
        element.setQName(new QName("nbAssure"));
        element.setType((AbsItfType)SchemaFactory.getDefaultSchema().getTypeInt());
        org.jdom.Element element2 = XSD2XML.newInstance().generateElement((AbsItfElement)element, (Object)"?");
        Assert.assertNotNull((Object)element2);
    }

    public void testCreateArraySchema() throws URISyntaxException, SchemaException, IOException {
        URL uRL = Thread.currentThread().getContextClassLoader().getResource("descriptors/ManagerProcess.xsd");
        Schema schema = SchemaFactory.newInstance().newSchemaReader().read(uRL);
        Element element = (Element)schema.createElement();
        element.setQName(new QName("http://irit.contractnet.org", "bidArray"));
        element.setType((AbsItfType)schema.getTypes().get(0));
    }

    public void testCreateMiseAJourSuiviCollecteElement() throws URISyntaxException, SchemaException, IOException {
        URL uRL = Thread.currentThread().getContextClassLoader().getResource("descriptors/i_servicemajsuivi.xsd");
        Schema schema = SchemaFactory.newInstance().newSchemaReader().read(uRL);
        Element element = (Element)schema.getElement(new QName("http://suivi.architecture.cnav.fr/", "miseAJourSuiviCollecte"));
        Assert.assertNotNull((Object)element);
        Assert.assertEquals((String)"miseAJourSuiviCollecte", (String)element.getQName().getLocalPart());
    }

    public void testRejectedBidElement() throws URISyntaxException, SchemaException, IOException {
        URL uRL = Thread.currentThread().getContextClassLoader().getResource("descriptors/ContractorProcessAbstract.xsd");
        Schema schema = SchemaFactory.newInstance().newSchemaReader().read(uRL);
        Element element = (Element)schema.getElement(new QName("http://irit.contractnet.org/contractor", "ReceiveBidRejectRequest"));
        Assert.assertNotNull((Object)element);
        Assert.assertEquals((String)"ReceiveBidRejectRequest", (String)element.getQName().getLocalPart());
    }

    public void testCreateGetPresenceElement() throws URISyntaxException, SchemaException, IOException {
        URL uRL = Thread.currentThread().getContextClassLoader().getResource("descriptors/PresenceEnablerSEI-V1_0.xsd");
        Schema schema = SchemaFactory.newInstance().newSchemaReader().read(uRL);
        Element element = (Element)schema.getElement(new QName("http://com.orange.ft.enabler.sei/PresenceEnabler/V1_0/PresenceQuerySEI", "getPresence"));
        Assert.assertNotNull((Object)element);
        Assert.assertEquals((String)"getPresence", (String)element.getQName().getLocalPart());
        System.out.println(XSD2XML.newInstance().printXml((AbsItfElement)element, (Object)"?"));
    }

    public void testCreateGetPresenceElementFromWsdl() throws URISyntaxException, SchemaException, IOException {
        Schema schema;
        URL uRL = Thread.currentThread().getContextClassLoader().getResource("descriptors/PresenceEnablerSEI-V1_0.wsdl");
        Description description = WSDLFactory.newInstance().newWSDLReader().read(uRL);
        Element element = null;
        Iterator iterator = ((Types)description.getTypes()).getSchemas().iterator();
        while (iterator.hasNext() && (element = (Element)(schema = (Schema)iterator.next()).getElement(new QName("http://com.orange.ft.enabler.sei/PresenceEnabler/V1_0/PresenceQuerySEI", "getPresence"))) == null) {
        }
        Assert.assertNotNull(element);
        Assert.assertEquals((String)"getPresence", (String)element.getQName().getLocalPart());
        System.out.println(XSD2XML.newInstance().printXml(element, (Object)"?"));
    }

    public void testAddDefaultValue() throws URISyntaxException, SchemaException, IOException {
        URL uRL = Thread.currentThread().getContextClassLoader().getResource("descriptors/ContractorProcessAbstract.xsd");
        Schema schema = SchemaFactory.newInstance().newSchemaReader().read(uRL);
        Element element = (Element)schema.getElement(new QName("http://irit.contractnet.org/contractor", "ReceiveBidRejectRequest"));
        Assert.assertNotNull((Object)element);
        Map map = XSD2XML.createDefaultMap((Object)"?");
        map.put(DefaultSchemaImpl.getInstance().getTypeInt(), "0");
        map.put(DefaultSchemaImpl.getInstance().getTypeBoolean(), "true");
        map.put(DefaultSchemaImpl.getInstance().getTypeDateTime(), Calendar.getInstance().getTime().toString());
        System.out.println(XSD2XML.newInstance().printXml((AbsItfElement)element, map, true, true));
    }

    public void testAddDefaultValueWithEmptyMap() throws URISyntaxException, SchemaException, IOException {
        URL uRL = Thread.currentThread().getContextClassLoader().getResource("descriptors/ContractorProcessAbstract.xsd");
        Schema schema = SchemaFactory.newInstance().newSchemaReader().read(uRL);
        Element element = (Element)schema.getElement(new QName("http://irit.contractnet.org/contractor", "ReceiveBidRejectRequest"));
        Assert.assertNotNull((Object)element);
        System.out.println(XSD2XML.newInstance().printXml((AbsItfElement)element, null, true, true));
    }

    public void testBindResponseElementFromWsdl() throws URISyntaxException, SchemaException, IOException {
        Schema schema;
        URL uRL = Thread.currentThread().getContextClassLoader().getResource("descriptors/prosodie/authorizationService.wsdl");
        Description description = WSDLFactory.newInstance().newWSDLReader().read(uRL);
        Element element = null;
        Iterator iterator = ((Types)description.getTypes()).getSchemas().iterator();
        while (iterator.hasNext() && (element = (Element)(schema = (Schema)iterator.next()).getElement(new QName("http://contract.prosodie.com/AuthorizationService/1/", "bindResponse"))) == null) {
        }
        Assert.assertNotNull(element);
        Assert.assertEquals((String)"bindResponse", (String)element.getQName().getLocalPart());
        System.out.println(XSD2XML.newInstance().printXml(element, (Object)"?"));
    }
}

