/**
 * easyWSDL - easyWSDL toolbox Platform.
 * Copyright (c) 2008,  eBM Websourcing
 * All rights reserved.
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 *     * Redistributions of source code must retain the above copyright
 *       notice, this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above copyright
 *       notice, this list of conditions and the following disclaimer in the
 *       documentation and/or other materials provided with the distribution.
 *     * Neither the name of the University of California, Berkeley nor the
 *       names of its contributors may be used to endorse or promote products
 *       derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE REGENTS AND CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package org.ow2.easywsdl.extensions.sawsdl.api;

import java.net.URI;
import java.util.Map;

import javax.xml.transform.dom.DOMSource;

import org.ow2.easywsdl.wsdl.api.WSDLException;
import org.ow2.easywsdl.wsdl.api.WSDLReader.FeatureConstants;
import org.w3c.dom.Document;


/**
 * This interface describes a collection of methods that enable conversion of a
 * WSDL document (in XML, following the WSDL schema described in the WSDL
 * specification) into a WSDL tag.
 * 
 * @author Nicolas Salatge - eBM WebSourcing
 */
public interface SAWSDLReader {

    /**
     * Sets the specified feature to the specified value.
     * <p>
     * The minimum features that must be supported are:
     * <p>
     * <table border=1>
     * <tr>
     * <th>Name</th>
     * <th>DescriptionImpl</th>
     * <th>Default Value</th>
     * </tr>
     * <tr>
     * <td><center>org.ow2.easywsdl.schema.test.verbose</center></td>
     * <td>If set to true, status messages will be displayed.</td>
     * <td><center>type: boolean - default value: false</center></td>
     * </tr>
     * <tr>
     * <td><center>org.ow2.easywsdl.schema.test.importDocuments</center></td>
     * <td>If set to true, imported WSDL documents will be retrieved and
     * processed.</td>
     * <td><center>type: boolean - default value: true</center></td>
     * </tr>
     * <tr>
     * <td>
     * <center>org.ow2.easywsdl.schema.test.pathDirectoryOfImportLocations
     * </center></td>
     * <td>If the location is set, imported WSDL documents will be retrieved at
     * this location (Set the importDocuments Features at true).</td>
     * <td><center>type: String</center></td>
     * </tr>
     * </table>
     * <p>
     * All feature names must be fully-qualified, Java package style. All names
     * starting with om.ebmwebsourcing. are reserved for features defined by the
     * specification. It is recommended that implementation- specific features
     * be fully-qualified to match the package name of that implementation. For
     * example: com.abc.featureName
     * 
     * @param name
     *            the name of the feature to be set.
     * @param value
     *            the value to set the feature to.
     * @throws WSDLException
     *             TODO
     * @see #getFeature(String)
     */
    void setFeature(FeatureConstants name, Object value) throws WSDLException;

    /**
     * Gets the value of the specified feature.
     * 
     * @param name
     *            the name of the feature to get the value of.
     * @return the value of feature
     * @throws IllegalArgumentException
     *             if the feature name is not recognized.
     * @see #setFeature(String, boolean)
     */
    Object getFeature(FeatureConstants name);

    /**
     * Gets all features.
     * 
     * @return the features
     * @see #setFeature(String, boolean)
     */
    Map<FeatureConstants, Object> getFeatures();

    /**
     * Read the WSDL document accessible via the specified URI into a WSDL
     * definition.
     * 
     * @param wsdlURI
     *            a URI (can be a filename or URL) pointing to a WSDL XML
     *            definition.
     * @return the definition.
     */
    Description readSAWSDL(URI wsdlURI) throws SAWSDLException;

    /**
     * Read the specified WSDL document into a WSDL definition.
     * 
     * @param documentBaseURI
     *            the document base URI of the WSDL definition described by the
     *            document. Will be set as the documentBaseURI of the returned
     *            Definition. Can be null, in which case it will be ignored.
     * @param wsdlDocument
     *            the WSDL document, an XML document obeying the WSDL schema.
     * @return the definition described in the document.
     */
    Description readSAWSDL(Document wsdlDocument) throws SAWSDLException;

    /**
     * Read a WSDL document into a WSDL definition.
     * 
     * @param wslURI
     *            uri of the wsdl
     * @param inputSource
     *            an InputSource pointing to the WSDL document, an XML document
     *            obeying the WSDL schema.
     * @return the definition described in the document pointed to by the
     *         InputSource.
     */
    Description readSAWSDL(URI wsdlURI, DOMSource inputSource) throws SAWSDLException;

}
