/**
 * easyWSDL - easyWSDL toolbox Platform.
 * Copyright (c) 2008,  eBM Websourcing
 * All rights reserved.
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 *     * Redistributions of source code must retain the above copyright
 *       notice, this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above copyright
 *       notice, this list of conditions and the following disclaimer in the
 *       documentation and/or other materials provided with the distribution.
 *     * Neither the name of the University of California, Berkeley nor the
 *       names of its contributors may be used to endorse or promote products
 *       derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE REGENTS AND CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package org.ow2.easywsdl.extensions.sawsdl.impl.inout;

import org.ow2.easywsdl.extensions.sawsdl.api.Description;
import org.ow2.easywsdl.extensions.sawsdl.api.SAWSDLException;
import org.ow2.easywsdl.extensions.sawsdl.api.SAWSDLWriter;
import org.ow2.easywsdl.extensions.sawsdl.impl.SAWSDLJAXBContext;
import org.ow2.easywsdl.wsdl.WSDLFactory;
import org.ow2.easywsdl.wsdl.api.WSDLException;
import org.ow2.easywsdl.wsdl.api.WSDLWriter;
import org.ow2.easywsdl.wsdl.decorator.DecoratorDescriptionImpl;
import org.w3c.dom.Document;


/**
 * @author Nicolas Salatge - eBM WebSourcing
 */
public class SAWSDLWriterImpl implements SAWSDLWriter {

    WSDLWriter writer = null;

    public SAWSDLWriterImpl() throws SAWSDLException {
        try {
        	WSDLFactory factory = WSDLFactory.newInstance();
			factory.setJAXBObjectFactoryList(SAWSDLJAXBContext.getDefaultObjectFactories());

            this.writer = factory.newWSDLWriter();
        } catch (final WSDLException e) {
            throw new SAWSDLException(e);
        }
    }

    @SuppressWarnings("unchecked")
    public Document getDocument(final Description wsdlDef) throws SAWSDLException {
        Document res = null;
        try {
            res = this.writer.getDocument(((DecoratorDescriptionImpl) wsdlDef).getFirstDescription());
        } catch (final WSDLException e) {
            throw new SAWSDLException(e);
        }
        return res;
    }

    public boolean getFeature(final String name) throws IllegalArgumentException {
        return this.writer.getFeature(name);
    }

    public void setFeature(final String name, final boolean value) throws IllegalArgumentException {
        this.writer.setFeature(name, value);
    }

    @SuppressWarnings("unchecked")
    public String writeSAWSDL(final Description wsdlDef) throws SAWSDLException {
        String res = null;
        try {
            res = this.writer.writeWSDL(((DecoratorDescriptionImpl) wsdlDef).getFirstDescription());
        } catch (final WSDLException e) {
            throw new SAWSDLException(e);
        }
        return res;
    }

}
