/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.cep.server;

import com.ebmwebsourcing.cep.server.CepManagementImpl;
import com.ebmwebsourcing.easybox.api.XmlObjectReadException;
import com.ebmwebsourcing.easybox.api.XmlObjectReader;
import com.ebmwebsourcing.easycommons.research.util.cxf.CXFHelper;
import com.ebmwebsourcing.easycommons.research.util.cxf.Server;
import com.ebmwebsourcing.easycommons.research.util.easybox.DefaultFramework;
import com.ebmwebsourcing.easycommons.research.util.easybox.Framework;
import com.ebmwebsourcing.easycommons.research.util.easybox.SOAUtil;
import com.ebmwebsourcing.easywsdl11.api.element.Definitions;
import com.ebmwebsourcing.easywsdl11.api.element.Port;
import com.ebmwebsourcing.easywsdl11.api.element.Service;
import com.ebmwebsourcing.soapbinding11.api.SoapBindingHelper;
import com.ebmwebsourcing.soapbinding11.api.element.Address;
import javax.xml.namespace.QName;
import seacloud.petalslink.com.service.management.cloud._1_0.CloudManagementException;

public class Cep
implements Server {
    private Server ep = null;
    private Object implementation = null;
    private Definitions def = null;
    private Port endpoint = null;
    private Service service = null;
    private boolean isStopped = false;

    public Cep(String address) throws CloudManagementException {
        this.implementation = new CepManagementImpl(address);
        this.ep = CXFHelper.getService((String)address, this.implementation.getClass(), (Object)this.implementation);
        System.out.println("***************** CEP Started on : " + address);
        try {
            System.out.println("ep.getWsdlLocation() = " + this.ep.getWsdlLocation());
            if (this.ep.getWsdlLocation() == null) {
                throw new CloudManagementException("Impossible to find wsdl location on " + this.implementation.getClass());
            }
            this.def = (Definitions)((XmlObjectReader)SOAUtil.getInstance().getReader((Framework)DefaultFramework.getInstance()).get()).readDocument(Thread.currentThread().getContextClassLoader().getResource(this.ep.getWsdlLocation()), Definitions.class);
            System.out.println("********************* def = ");
            this.service = this.def.getServiceByName(this.ep.getServiceQName().getLocalPart());
            System.out.println("********************* service = " + this.service);
            this.endpoint = this.service.getPorts()[0];
            System.out.println("********************* endpoint = " + this.endpoint);
            Address addr = SoapBindingHelper.getAddress((Port)this.endpoint);
            System.out.println("********************* addr = " + addr);
            addr.setLocation(address);
            System.out.println("********************* addr2 = " + addr);
            SoapBindingHelper.setAddress((Port)this.endpoint, (Address)addr);
            System.out.println("********************* endpoint = " + this.endpoint);
        }
        catch (XmlObjectReadException e) {
            e.printStackTrace();
            throw new CloudManagementException(e.getMessage(), (Throwable)e);
        }
    }

    public String getAddress() {
        return this.ep.getAddress();
    }

    public void start() {
        this.ep.start();
        System.out.println("Start Server and expose service at this address: " + this.getAddress() + "?wsdl");
        this.isStopped = false;
    }

    public void stop() {
        this.ep.stop();
        this.isStopped = true;
    }

    public QName getServiceQName() {
        return this.service.inferQName();
    }

    public String getWsdlLocation() {
        return this.def.getXmlObjectBaseURI().toString();
    }

    public boolean isStopped() {
        return false;
    }

    public static enum CEP_MODE {
        ESPER,
        ETALIS;

    }
}

