/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.eventcloud.mocked.launcher;

import com.ebmwebsourcing.eventcloud.mocked.launcher.ConfigurationImpl;
import com.ebmwebsourcing.eventcloud.mocked.launcher.Launcher;
import com.ebmwebsourcing.eventcloud.mocked.launcher.util.CommandReader;
import com.ebmwebsourcing.eventcloud.mocked.launcher.util.Locker;
import com.ebmwebsourcing.eventcloud.mocked.launcher.util.SystemExitHook;
import com.ebmwebsourcing.eventcloud.mocked.server.EventCloudMocked;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.logging.LogManager;

public class EventCloudLauncher
implements Launcher {
    protected static final String START_COMMAND = "start";
    protected static final String SHUTDOWN_COMMAND = "shutdown";
    protected static final String VERSION_COMMAND = "version";
    protected String banner = " -----------------------------------------------------------\n|                                                           |\n|                          EventCloud Mocked                |\n|                                                           |\n -----------------------------------------------------------\n";
    protected static final String LOGGER_FILE = "/logger/EventCloud-logging.properties";
    protected EventCloudMocked server;
    protected SystemExitHook systemExitHook;
    protected final Locker locker = new Locker(new File("."));

    protected void showBanner() {
        System.out.println();
        System.out.println(this.banner);
        System.out.println();
    }

    public void setBanner(String banner) {
        this.banner = banner;
    }

    public void launch(String[] args) {
        this.showBanner();
        ArrayList<String> command = new ArrayList<String>();
        boolean console = true;
        if (args.length == 0) {
            command.add(START_COMMAND);
        }
        for (String arg : args) {
            command.add(arg);
        }
        try {
            if (command.contains(SHUTDOWN_COMMAND)) {
                System.out.println("EventCloud is stopping...");
                this.shutdown();
            } else if (command.contains(VERSION_COMMAND)) {
                this.version();
            } else if (command.contains(START_COMMAND)) {
                System.out.println("EventCloud is starting...");
                this.start();
                if (console) {
                    this.commandLineMode(this.server);
                }
                if (this.systemExitHook != null) {
                    Runtime.getRuntime().removeShutdownHook(this.systemExitHook);
                }
                this.systemExitHook.run();
                System.exit(0);
            } else {
                System.out.println("Command '" + command + "' is unknown");
                this.printUsage();
                System.exit(-1);
            }
        }
        catch (Throwable e) {
            System.out.println("Command processing error : " + command);
            e.printStackTrace(System.err);
            if (this.systemExitHook != null) {
                Runtime.getRuntime().removeShutdownHook(this.systemExitHook);
            }
            System.exit(-1);
        }
    }

    @Override
    public void start() throws Exception {
        if (this.locker.isLocked()) {
            throw new Exception("Can not start the EventCloud server, remove lock file from EventCloud root path or stop server");
        }
        this.locker.lock();
        ConfigurationImpl conf = new ConfigurationImpl();
        String host = conf.getHost();
        int port = conf.getPort();
        if (host == null || port <= 0) {
            throw new Exception("Wrong host or port parameters!!!");
        }
        this.server = new EventCloudMocked("http://" + host + ":" + port + "/services/eventCloudMocked", Boolean.valueOf(conf.getProperties().get("ui")));
        this.server.start();
        System.out.println("EventCloudMocked started at: http://" + host + ":" + port + "/services/eventCloudMocked");
        this.systemExitHook = new SystemExitHook(this.locker);
        Runtime.getRuntime().addShutdownHook(this.systemExitHook);
    }

    @Override
    public void shutdown() throws Exception {
        if (this.systemExitHook == null) {
            this.systemExitHook = new SystemExitHook(this.locker);
        }
        this.systemExitHook.start();
    }

    @Override
    public void version() throws Exception {
        System.out.println("No version");
    }

    protected void printUsage() {
        System.out.println("usage:");
        System.out.println(" -start                  start the EventCloudMocked container");
        System.out.println(" -shutdowm               shutdown the EventCloudMocked container");
        System.out.println(" -version                get the EventCloudMocked container version");
    }

    protected void printSpecificStartMessage() {
    }

    protected void commandLineMode(EventCloudMocked node) throws Exception {
        CommandReader console = new CommandReader(node);
        console.read();
    }

    static {
        try {
            InputStream inputStream = null;
            File logger = new File("./logger/EventCloud-logging.properties");
            inputStream = logger.exists() ? new FileInputStream(logger) : EventCloudLauncher.class.getClass().getResourceAsStream(LOGGER_FILE);
            if (inputStream != null) {
                LogManager.getLogManager().readConfiguration(inputStream);
                inputStream.close();
            }
        }
        catch (Exception e) {
            throw new RuntimeException("couldn't initialize logging properly", e);
        }
    }
}

