/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.eventcloud.mocked.server;

import com.ebmwebsourcing.easybox.api.XmlObject;
import com.ebmwebsourcing.easybox.api.XmlObjectWriter;
import com.ebmwebsourcing.easycommons.research.util.SOAException;
import com.ebmwebsourcing.easycommons.research.util.dom.DOMUtil;
import com.ebmwebsourcing.easycommons.research.util.easybox.DefaultFramework;
import com.ebmwebsourcing.easycommons.research.util.easybox.Framework;
import com.ebmwebsourcing.easycommons.research.util.easybox.SOAUtil;
import com.ebmwebsourcing.easycommons.research.util.jaxb.SOAJAXBContext;
import com.ebmwebsourcing.easycommons.soap.handler.SOAPSender;
import com.ebmwebsourcing.easycommons.xml.XMLPrettyPrinter;
import com.ebmwebsourcing.easyesb.rawreport10.api.element.Report;
import com.ebmwebsourcing.easyesb.rawreport10.api.element.ReportList;
import com.ebmwebsourcing.easyesb.rawreport10.api.type.TimeStampType;
import com.ebmwebsourcing.eventcloud.mocked.server.AbstractFilter;
import com.ebmwebsourcing.eventcloud.mocked.server.TopicKey;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.MessageContentExpression;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.Notify;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.refinedabstraction.RefinedWsnbFactory;
import com.ebmwebsourcing.wsstar.wsnb.services.impl.util.WSNHelper;
import easybox.esstar.petalslink.com.management.model.datatype._1.EJaxbDeploy;
import easybox.esstar.petalslink.com.management.model.datatype._1.EJaxbDeployResponse;
import easybox.esstar.petalslink.com.management.model.datatype._1.EJaxbDescriptorType;
import easybox.org.oasis_open.docs.wsn.b_2.EJaxbFilterType;
import easybox.org.oasis_open.docs.wsn.b_2.EJaxbNotificationMessageHolderType;
import easybox.org.oasis_open.docs.wsn.b_2.EJaxbNotify;
import easybox.org.oasis_open.docs.wsn.b_2.EJaxbSubscribe;
import easybox.org.oasis_open.docs.wsn.b_2.EJaxbSubscribeResponse;
import easybox.org.oasis_open.docs.wsn.b_2.EJaxbTopicExpressionType;
import easybox.org.oasis_open.docs.wsn.b_2.EJaxbUnsubscribe;
import easybox.org.oasis_open.docs.wsn.b_2.EJaxbUnsubscribeResponse;
import easybox.org.oasis_open.docs.wsn.b_2.ObjectFactory;
import easybox.org.oasis_open.docs.wsrf.rp_2.EJaxbGetResourcePropertyResponse;
import engine.cep.admin.api.AddStatementResponseWithActions;
import engine.cep.admin.api.AddStatementWithActions;
import engine.cep.admin.api.ListAllStatements;
import engine.cep.admin.api.ListAllStatementsResponse;
import esstar.petalslink.com.data.management.user._1.Bind;
import esstar.petalslink.com.data.management.user._1.BindResponse;
import esstar.petalslink.com.data.management.user._1.Proxify;
import esstar.petalslink.com.data.management.user._1.ProxifyResponse;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.logging.Logger;
import javax.jws.WebService;
import javax.xml.bind.JAXBElement;
import javax.xml.namespace.QName;
import org.oasis_open.docs.wsn.bw_2.InvalidFilterFault;
import org.oasis_open.docs.wsn.bw_2.InvalidMessageContentExpressionFault;
import org.oasis_open.docs.wsn.bw_2.InvalidProducerPropertiesExpressionFault;
import org.oasis_open.docs.wsn.bw_2.InvalidTopicExpressionFault;
import org.oasis_open.docs.wsn.bw_2.NotifyMessageNotSupportedFault;
import org.oasis_open.docs.wsn.bw_2.SubscribeCreationFailedFault;
import org.oasis_open.docs.wsn.bw_2.TopicExpressionDialectUnknownFault;
import org.oasis_open.docs.wsn.bw_2.TopicNotSupportedFault;
import org.oasis_open.docs.wsn.bw_2.UnableToDestroySubscriptionFault;
import org.oasis_open.docs.wsn.bw_2.UnacceptableInitialTerminationTimeFault;
import org.oasis_open.docs.wsn.bw_2.UnrecognizedPolicyRequestFault;
import org.oasis_open.docs.wsn.bw_2.UnsupportedPolicyRequestFault;
import org.oasis_open.docs.wsrf.rpw_2.InvalidResourcePropertyQNameFault;
import org.oasis_open.docs.wsrf.rw_2.ResourceUnavailableFault;
import org.oasis_open.docs.wsrf.rw_2.ResourceUnknownFault;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import seacloud.petalslink.com.data._1.AddResourcesDescriptor;
import seacloud.petalslink.com.data._1.AddResourcesDescriptorResponse;
import seacloud.petalslink.com.service.management.cloud._1_0.CloudManagement;
import seacloud.petalslink.com.service.management.cloud._1_0.CloudManagementException;

@WebService(serviceName="CloudManagementService", portName="CloudManagementSOAPEndpoint", targetNamespace="http://com.petalslink.seacloud/service/management/cloud/1.0", wsdlLocation="wsdl/SeaCloud.wsdl", endpointInterface="seacloud.petalslink.com.service.management.cloud._1_0.CloudManagement")
public class EventCloudMockedManagementImpl
implements CloudManagement {
    private static final Logger LOG = Logger.getLogger(EventCloudMockedManagementImpl.class.getName());
    private String eventcloudAddress;
    private int cpt = 0;
    private boolean ui = false;
    private SOAPSender sender = new SOAPSender();
    private Map<TopicKey, List<URI>> clientsMap = new HashMap<TopicKey, List<URI>>();
    private List<AbstractFilter> filters = new ArrayList<AbstractFilter>();
    private List<URI> clientsForReport = new ArrayList<URI>();

    public EventCloudMockedManagementImpl(String cepAddress, boolean ui) throws CloudManagementException {
        this.eventcloudAddress = cepAddress;
        this.ui = ui;
        ServiceLoader<AbstractFilter> serviceLoader = ServiceLoader.load(AbstractFilter.class);
        serviceLoader.reload();
        for (AbstractFilter command : serviceLoader) {
            this.filters.add(command);
            LOG.info("SPI: Filter found: \"" + command + "\" is created");
        }
    }

    public EJaxbSubscribeResponse subscribe(EJaxbSubscribe subscribeRequest) throws UnrecognizedPolicyRequestFault, InvalidTopicExpressionFault, UnacceptableInitialTerminationTimeFault, NotifyMessageNotSupportedFault, TopicNotSupportedFault, InvalidMessageContentExpressionFault, TopicExpressionDialectUnknownFault, ResourceUnknownFault, UnsupportedPolicyRequestFault, InvalidFilterFault, SubscribeCreationFailedFault, InvalidProducerPropertiesExpressionFault {
        EJaxbSubscribeResponse response = new EJaxbSubscribeResponse();
        try {
            URI clientEPR = URI.create(subscribeRequest.getConsumerReference().getAddress().getValue());
            System.out.println("Event cloud (subscribe) =>\n" + XMLPrettyPrinter.prettyPrint((Document)SOAJAXBContext.getInstance().unmarshallAnyElement((Object)subscribeRequest)));
            System.out.println("Event cloud (subscribe) => client EPR: " + clientEPR);
            System.out.println("Event cloud (subscribe) => filter: " + subscribeRequest.getFilter().getAny());
            EJaxbTopicExpressionType texp = null;
            for (Object obj : subscribeRequest.getFilter().getAny()) {
                JAXBElement jelmt;
                if (obj instanceof EJaxbTopicExpressionType) {
                    texp = (EJaxbTopicExpressionType)obj;
                    break;
                }
                if (!(obj instanceof JAXBElement) || !((jelmt = (JAXBElement)obj).getValue() instanceof EJaxbTopicExpressionType)) continue;
                texp = (EJaxbTopicExpressionType)jelmt.getValue();
                break;
            }
            System.out.println("Event cloud (subscribe) => texp = " + texp);
            QName topic = WSNHelper.getQNameInSimpleTopicExpression((EJaxbTopicExpressionType)texp);
            List msgs = WSNHelper.getMessages((MessageContentExpression)WSNHelper.getMessageContentInFilter((EJaxbFilterType)subscribeRequest.getFilter()));
            System.out.println("Event cloud (subscribe) => topic: " + topic);
            System.out.println("Event cloud (subscribe) => msgs: " + msgs);
            if (topic.toString().equals("{http://www.petalslink.org/resources/event/1.0}CreationResourcesTopic")) {
                System.out.println("Event cloud (subscribe) => IGNORE: topic: {http://www.petalslink.org/resources/event/1.0}CreationResourcesTopic");
            } else if (topic.toString().equals("{http://www.petalslink.org/rawreport/1.0}RawReportTopic")) {
                if (!this.clientsForReport.contains(clientEPR)) {
                    this.clientsForReport.add(clientEPR);
                }
                System.out.println("Event cloud (subscribe) on RawReportTopic. Add Bsm client: " + this.clientsForReport);
            } else {
                List<URI> clientURIS = this.clientsMap.get(topic);
                if (clientURIS == null) {
                    clientURIS = new ArrayList<URI>();
                }
                System.out.println("Event cloud (subscribe) => find topic: " + TopicKey.findTopicKeys(new TopicKey(topic, msgs), Arrays.asList(this.clientsMap.keySet().toArray(new TopicKey[this.clientsMap.size()]))));
                if (TopicKey.findTopicKeys(new TopicKey(topic, msgs), Arrays.asList(this.clientsMap.keySet().toArray(new TopicKey[this.clientsMap.size()]))).size() > 0) {
                    for (TopicKey key : TopicKey.findTopicKeys(new TopicKey(topic, msgs), Arrays.asList(this.clientsMap.keySet().toArray(new TopicKey[this.clientsMap.size()])))) {
                        clientURIS = this.clientsMap.get(key);
                        if (clientURIS.contains(clientEPR)) continue;
                        clientURIS.add(clientEPR);
                    }
                } else {
                    clientURIS.add(clientEPR);
                    this.clientsMap.put(new TopicKey(topic, msgs), clientURIS);
                }
                System.out.println("Event cloud (subscribe) => clients added: " + this.clientsMap);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new InvalidTopicExpressionFault(e.getMessage(), (Throwable)e);
        }
        return response;
    }

    public void notify(EJaxbNotify notify) {
        LOG.info("Executing operation notify on event cloud");
        System.out.println(notify);
        try {
            System.out.println("Event cloud (notify) => notify received: \n" + XMLPrettyPrinter.prettyPrint((Document)SOAJAXBContext.getInstance().unmarshallAnyElement((Object)notify)));
            for (EJaxbNotificationMessageHolderType h : notify.getNotificationMessage()) {
                QName topic = WSNHelper.getQNameInSimpleTopicExpression((EJaxbTopicExpressionType)h.getTopic());
                ArrayList<QName> msgs = new ArrayList<QName>();
                Element elmt = (Element)h.getMessage().getAny();
                QName msg = new QName(elmt.getNamespaceURI(), elmt.getLocalName());
                msgs.add(msg);
                System.out.println("Event cloud (notify) => this.clientMap: " + this.clientsMap);
                System.out.println("Event cloud (notify) => topic = " + topic);
                System.out.println("Event cloud (notify) => msgs = " + msgs);
                List<TopicKey> keys = TopicKey.findTopicKeys(new TopicKey(topic, msgs), Arrays.asList(this.clientsMap.keySet().toArray(new TopicKey[this.clientsMap.size()])));
                System.out.println("Event cloud (notify) => keys = " + keys);
                for (TopicKey key : keys) {
                    List<URI> clients = this.clientsMap.get(key);
                    System.out.println("Event cloud (notify) => clients found: " + clients);
                    if (clients == null) continue;
                    for (URI uri : clients) {
                        if (this.filters.isEmpty()) {
                            Document request = SOAPSender.createSOAPMessageRequest((Document)SOAJAXBContext.getInstance().unmarshallAnyElement((Object)notify));
                            System.out.println("Event cloud (notify) => Send notification to " + uri.toString());
                            System.out.println("Event cloud (notify) => notif to send:\n" + XMLPrettyPrinter.prettyPrint((Document)request));
                            this.sender.sendSoapRequest(request, uri.toString(), "http://docs.oasis-open.org/wsn/bw-2/NotificationConsumer/Notify");
                        } else {
                            for (AbstractFilter filter : this.filters) {
                                if (filter.filter(uri.toString(), h.getProducerReference().getAddress().getValue().toString(), this.ui)) {
                                    Document request = SOAPSender.createSOAPMessageRequest((Document)SOAJAXBContext.getInstance().unmarshallAnyElement((Object)notify));
                                    System.out.println("Event cloud (notify) => Send notification to " + uri.toString());
                                    System.out.println("Event cloud (notify) => notif to send:\n" + XMLPrettyPrinter.prettyPrint((Document)request));
                                    this.sender.sendSoapRequest(request, uri.toString(), "http://docs.oasis-open.org/wsn/bw-2/NotificationConsumer/Notify");
                                    continue;
                                }
                                LOG.warning("notification produced by " + h.getProducerReference().getAddress().toString() + " and at destination to " + uri.toString() + " has been rejected by social filter");
                            }
                        }
                        this.sendReportToMonitoring(this.clientsForReport, uri, elmt, notify);
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void sendReportToMonitoring(List<URI> clientsBSM, URI consumer, Element eventPayload, EJaxbNotify notify) {
        try {
            ReportList reports = (ReportList)SOAUtil.getInstance().getXmlContext((Framework)DefaultFramework.getInstance()).getXmlObjectFactory().create(ReportList.class);
            String subscriptionAddress = consumer.toString();
            String producerAddress = null;
            producerAddress = ((EJaxbNotificationMessageHolderType)notify.getNotificationMessage().get(0)).getProducerReference() != null ? ((EJaxbNotificationMessageHolderType)notify.getNotificationMessage().get(0)).getProducerReference().getAddress().getValue() : "unknown";
            Report report = (Report)SOAUtil.getInstance().getXmlContext((Framework)DefaultFramework.getInstance()).getXmlObjectFactory().create(Report.class);
            report.setExchangeId("-1");
            report.setEndpointName(subscriptionAddress);
            report.setOperationName("notify");
            report.setInterfaceQName(new QName("http://docs.oasis-open.org/wsn/bw-2", "NotificationConsumer"));
            report.setServiceQName(null);
            report.setConsumerEndpointAddress(subscriptionAddress);
            report.setProviderEndpointAddress(producerAddress);
            report.setDateInGMT(Calendar.getInstance().getTime());
            report.setTimeStamp(TimeStampType.t1);
            report.setContentLength((long)XMLPrettyPrinter.prettyPrint((Element)eventPayload).length());
            reports.addReport(report);
            Document notifPayload = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().newDocument();
            ((XmlObjectWriter)SOAUtil.getInstance().getWriter((Framework)DefaultFramework.getInstance()).get()).writeDocument((XmlObject)reports, (Node)notifPayload);
            QName topicUsed = new QName("http://www.petalslink.org/rawreport/1.0", "RawReportTopic", "tns");
            String dialect = "http://docs.oasis-open.org/wsn/t-1/TopicExpression/Concrete";
            for (URI currentConsumerEdp : clientsBSM) {
                Notify notifyWithRawReport = WSNHelper.createNotification((String)currentConsumerEdp.toString(), (String)this.eventcloudAddress, (QName)topicUsed, (Object)notifPayload);
                Document request = RefinedWsnbFactory.getInstance().getWsnbWriter().writeNotifyAsDOM(notifyWithRawReport);
                this.sender.sendSoapRequest(SOAPSender.createSOAPMessageRequest((Document)request), currentConsumerEdp.toString(), null);
                System.out.println("Notification with RawReport sended to " + currentConsumerEdp.toString() + "\nNotification raw report:\n" + XMLPrettyPrinter.prettyPrint((Document)request));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public AddResourcesDescriptorResponse addResourcesDescriptor(AddResourcesDescriptor arg0) throws CloudManagementException {
        throw new UnsupportedOperationException();
    }

    public String addStatement(String arg0, String arg1) throws CloudManagementException {
        throw new UnsupportedOperationException();
    }

    public AddStatementResponseWithActions addStatementWithActions(AddStatementWithActions parameters) throws CloudManagementException {
        AddStatementResponseWithActions res = new AddStatementResponseWithActions();
        throw new UnsupportedOperationException();
    }

    public BindResponse bind(Bind arg0) throws CloudManagementException {
        throw new UnsupportedOperationException();
    }

    public String deleteStatement(String arg0) throws CloudManagementException {
        throw new UnsupportedOperationException();
    }

    public EJaxbDeployResponse deploy(EJaxbDeploy parameters) throws CloudManagementException {
        try {
            System.out.println("--------- DEPLOY");
            System.out.println("--------- DEPLOY SOCIAL RELATION: " + parameters.getMainResource().getFileURI());
            ArrayList<URL> rscs = new ArrayList<URL>();
            rscs.add(new URL(parameters.getMainResource().getFileURI()));
            for (EJaxbDescriptorType rsc : parameters.getResources()) {
                rscs.add(new URL(rsc.getFileURI()));
            }
            for (AbstractFilter filter : this.filters) {
                filter.init(rscs);
            }
            EJaxbDeployResponse resp = new EJaxbDeployResponse();
            return resp;
        }
        catch (Exception e) {
            throw new CloudManagementException(e.getMessage(), (Throwable)e);
        }
    }

    public String expose(QName arg0, String arg1) throws CloudManagementException {
        throw new UnsupportedOperationException();
    }

    public EJaxbGetResourcePropertyResponse getResourceProperty(QName arg0) throws ResourceUnavailableFault, ResourceUnknownFault, InvalidResourcePropertyQNameFault {
        throw new UnsupportedOperationException();
    }

    public String getStatementById(String arg0) throws CloudManagementException {
        throw new UnsupportedOperationException();
    }

    public ListAllStatementsResponse listAllStatements(ListAllStatements arg0) throws CloudManagementException {
        throw new UnsupportedOperationException();
    }

    public ProxifyResponse proxify(Proxify arg0) throws CloudManagementException {
        throw new UnsupportedOperationException();
    }

    public EJaxbUnsubscribeResponse unsubscribe(EJaxbUnsubscribe arg0) throws UnableToDestroySubscriptionFault, ResourceUnknownFault {
        throw new UnsupportedOperationException();
    }

    public String updateStatement(String arg0, String arg1) throws CloudManagementException {
        throw new UnsupportedOperationException();
    }

    static {
        try {
            SOAJAXBContext.getInstance().addOtherObjectFactory(new Class[]{ObjectFactory.class});
        }
        catch (SOAException e) {
            e.printStackTrace();
        }
    }
}

