/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.wsstar.basefaults.datatypes.api.test;

import com.ebmwebsourcing.wsaddressing10.api.type.EndpointReferenceType;
import com.ebmwebsourcing.wsstar.basefaults.datatypes.api.abstraction.BaseFaultType;
import com.ebmwebsourcing.wsstar.basefaults.datatypes.api.abstraction.WsrfbfFactory;
import com.ebmwebsourcing.wsstar.basefaults.datatypes.api.abstraction.WsrfbfReader;
import com.ebmwebsourcing.wsstar.basefaults.datatypes.api.abstraction.WsrfbfWriter;
import com.ebmwebsourcing.wsstar.basefaults.datatypes.api.implementor.WsrfbfModelFactory;
import com.ebmwebsourcing.wsstar.basefaults.datatypes.api.refinedabstraction.RefinedWsrfbfFactory;
import com.ebmwebsourcing.wsstar.basefaults.datatypes.api.test.WsrfbfUnitTestsUtils;
import com.ebmwebsourcing.wsstar.basefaults.datatypes.api.test.util.AbsWsaTypesUnitTests;
import com.ebmwebsourcing.wsstar.basefaults.datatypes.api.test.util.WsaUnitTestsUtils;
import com.ebmwebsourcing.wsstar.basefaults.datatypes.api.utils.WsrfbfException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.junit.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public abstract class AbsWsrfbfTypesUnitTests
extends TestCase {
    protected boolean isDebug = false;
    private WsrfbfFactory factory;
    protected WsrfbfModelFactory modelFactoryImpl;
    private WsrfbfReader reader;
    private WsrfbfWriter writer;

    protected void setUp() throws Exception {
        super.setUp();
        this.initRefinedWsrfbfFactory();
        this.initRequiredDependencyModelFactories();
    }

    protected abstract void setWsrfbfModelFactory();

    protected abstract void initRequiredDependencyModelFactories();

    public void initRefinedWsrfbfFactory() {
        if (this.modelFactoryImpl == null) {
            this.setWsrfbfModelFactory();
        }
        AbsWsrfbfTypesUnitTests.assertNotNull((String)(WsaUnitTestsUtils.getFailedMessagePrefix("OASIS \"WS-BaseFaults\"") + "the \"WsrfbfModelFactory\" implementation Object has not been set.\n" + "Please provide an instance of \"WsrfbfModelFactory\" implementation class"), (Object)this.modelFactoryImpl);
        if (this.factory == null) {
            this.factory = RefinedWsrfbfFactory.getInstance((WsrfbfModelFactory)this.modelFactoryImpl);
        }
        if (this.reader == null) {
            this.reader = this.factory.getWsrfbfReader();
        }
        if (this.writer == null) {
            this.writer = this.factory.getWsrfbfWriter();
        }
    }

    public static void setBaseFaultContentType(BaseFaultType minimalFault, EndpointReferenceType originator, String descriptionValue, Locale descriptionLang, String errorCodeValue, URI errorCodeDialect, String faultCausePath) {
        try {
            WsrfbfFactory wsrfbfFactory = RefinedWsrfbfFactory.getInstance();
            minimalFault.setOriginator(originator);
            BaseFaultType.Description description = wsrfbfFactory.createBaseFaultTypeDescription(descriptionValue);
            description.setLang(descriptionLang);
            minimalFault.addDescription(description);
            BaseFaultType.ErrorCode errorCode = wsrfbfFactory.createBaseFaultTypeErrorCode(errorCodeDialect);
            errorCode.addCode((Object)errorCodeValue);
            minimalFault.setErrorCode(errorCode);
            if (faultCausePath != null && faultCausePath.length() > 0) {
                Element faultCauseContent = WsrfbfUnitTestsUtils.createDefaultFaultCauseContent(faultCausePath);
                BaseFaultType.FaultCause faultCause = wsrfbfFactory.createBaseFaultTypeFaultCause(faultCauseContent);
                minimalFault.setFaultCause(faultCause);
            }
        }
        catch (WsrfbfException e) {
            e.printStackTrace();
        }
    }

    public static boolean checkBaseFaultType(BaseFaultType expectedFault, BaseFaultType toCheckFault, String relatedSpecification, boolean isDebug) {
        Date expectedTimestamp = expectedFault.getTimestamp();
        Date toCheckTimestamp = toCheckFault.getTimestamp();
        if (isDebug) {
            System.out.println("[DEBUG] --> toCheckFault timstamp : " + toCheckTimestamp.toString() + "\n[DEBUG] --> expectedFault timstamp : " + expectedTimestamp.toString() + "\n");
        }
        Assert.assertTrue((String)(WsaUnitTestsUtils.getFailedMessagePrefix(relatedSpecification) + "faults have different timestamp values\n" + "\t(-> toCheckFault timestamp : " + toCheckTimestamp.toString() + "\n\t-> expectedFault timestamp : " + expectedTimestamp.toString() + ")"), (boolean)toCheckTimestamp.equals(toCheckTimestamp));
        EndpointReferenceType expectedOriginator = expectedFault.getOriginator();
        EndpointReferenceType toCheckOriginator = toCheckFault.getOriginator();
        Assert.assertTrue((String)(WsaUnitTestsUtils.getFailedMessagePrefix(relatedSpecification) + "faults have different Originators :  \n" + "\t(-> toCheckFault  originator is " + (toCheckOriginator != null ? "not null" : "null") + "\n\t-> expectedFault originator is " + (expectedOriginator != null ? "not null" : "null") + ")"), (toCheckOriginator == null && expectedOriginator == null || toCheckOriginator != null && expectedOriginator != null ? 1 : 0) != 0);
        if (toCheckOriginator != null) {
            AbsWsaTypesUnitTests.checkEndpointReferenceType(expectedOriginator, toCheckOriginator, relatedSpecification, isDebug);
        }
        List expectedDescriptions = expectedFault.getDescriptions();
        List toCheckDescriptions = toCheckFault.getDescriptions();
        int expectedDescriptionCount = expectedDescriptions != null ? expectedDescriptions.size() : -1;
        Assert.assertTrue((String)(WsaUnitTestsUtils.getFailedMessagePrefix(relatedSpecification) + "faults have different description values\n" + "\t(-> toCheckFault descriptions count : " + (toCheckDescriptions != null ? Integer.valueOf(toCheckDescriptions.size()) : "none") + "\n\t-> expectedFault descriptions count : " + (expectedDescriptionCount == -1 ? "none" : Integer.valueOf(expectedDescriptionCount)) + ")"), (toCheckDescriptions == null && expectedDescriptions == null || toCheckDescriptions.size() == expectedDescriptionCount ? 1 : 0) != 0);
        for (int i = 0; i < expectedDescriptionCount; ++i) {
            BaseFaultType.Description toCheckDescription = (BaseFaultType.Description)toCheckDescriptions.get(i);
            BaseFaultType.Description expectedDescription = (BaseFaultType.Description)expectedDescriptions.get(i);
            if (isDebug) {
                System.out.println("[DEBUG] --> toCheckFault description #" + i + " : lang = \"" + toCheckDescription.getLang().getLanguage() + "\" - value = \"" + toCheckDescription.getValue() + "\"" + "\n[DEBUG] --> expectedFault description #" + i + " : lang = \"" + expectedDescription.getLang().getLanguage() + "\" - value = \"" + expectedDescription.getValue() + "\"\n");
            }
            Assert.assertTrue((String)(WsaUnitTestsUtils.getFailedMessagePrefix("W3C \"WS-Addressing\"") + "faults description contents are different \n" + "\t(-> toCheckFault description #" + i + " : lang = " + toCheckDescription.getLang().getLanguage() + ";value = " + toCheckDescription.getValue() + "\n\t-> expectedFault description #" + i + " : lang = " + expectedDescription.getLang().getLanguage() + ";value = " + expectedDescription.getValue()), (toCheckDescription.getLang().equals(expectedDescription.getLang()) && toCheckDescription.getValue().equals(expectedDescription.getValue()) ? 1 : 0) != 0);
        }
        BaseFaultType.ErrorCode expectedErrorCode = expectedFault.getErrorCode();
        BaseFaultType.ErrorCode toCheckErrorCode = toCheckFault.getErrorCode();
        Assert.assertTrue((String)(WsaUnitTestsUtils.getFailedMessagePrefix(relatedSpecification) + "faults have different ErrorCode \n" + "\t(-> toCheckFault  errorCode is " + (toCheckErrorCode != null ? "not null" : "null") + "\n\t-> expectedFault errorCode is " + (expectedErrorCode != null ? "not null" : "null") + ")"), (toCheckErrorCode == null && expectedErrorCode == null || toCheckErrorCode != null && expectedErrorCode != null ? 1 : 0) != 0);
        Assert.assertTrue((String)(WsaUnitTestsUtils.getFailedMessagePrefix(relatedSpecification) + "faults have different errorCode dialects\n" + "\t(-> toCheckFault  errorCode dialect : " + toCheckErrorCode.getDialect().toString() + "\n\t-> expectedFault errorCode dialect : " + expectedErrorCode.getDialect().toString() + ")"), (boolean)toCheckErrorCode.getDialect().equals(expectedErrorCode.getDialect()));
        List toCheckErrorCodeContents = toCheckErrorCode.getCodes();
        List expectedErrorCodeContents = expectedErrorCode.getCodes();
        int expectedErrCodeContentCount = expectedErrorCodeContents != null ? expectedErrorCodeContents.size() : -1;
        Assert.assertTrue((String)(WsaUnitTestsUtils.getFailedMessagePrefix(relatedSpecification) + "faults have different error code contents\n" + "\t(-> toCheckFault errorCode count : " + (toCheckErrorCodeContents != null ? Integer.valueOf(toCheckErrorCodeContents.size()) : "none") + "\n\t-> expectedFault errorCode count : " + (expectedErrCodeContentCount == -1 ? "none" : Integer.valueOf(expectedErrCodeContentCount)) + ")"), (toCheckDescriptions == null && expectedDescriptions == null || toCheckDescriptions.size() == expectedDescriptionCount ? 1 : 0) != 0);
        for (int i = 0; i < expectedErrCodeContentCount; ++i) {
            Object toCheckErrorCodeContent = toCheckErrorCodeContents.get(i);
            Object expectedErrorCodeContent = expectedErrorCodeContents.get(i);
            if (isDebug) {
                System.out.println("[DEBUG] --> toCheckFault errorCode #" + i + " : dialect = \"" + toCheckErrorCode.getDialect().toString() + "\" - content  = \"" + toCheckErrorCodeContent.toString() + "\"" + "\n[DEBUG] --> expectedFault errorCode #" + i + " : dialect = \"" + expectedErrorCode.getDialect().toString() + "\" - content = \"" + expectedErrorCodeContent.toString() + "\"\n");
            }
            Assert.assertTrue((String)(WsaUnitTestsUtils.getFailedMessagePrefix("W3C \"WS-Addressing\"") + "fault errorCode content are different \n" + "\t(-> toCheckFault errorCode  #" + i + " : content = " + toCheckErrorCodeContent.toString() + "\n\t-> expectedFault errorCode  #" + i + " : content = " + expectedErrorCodeContent.toString()), (boolean)toCheckErrorCodeContent.toString().equals(expectedErrorCodeContent.toString()));
        }
        BaseFaultType.FaultCause expectedFaultCause = expectedFault.getFaultCause();
        BaseFaultType.FaultCause toCheckFaultCause = toCheckFault.getFaultCause();
        Assert.assertTrue((String)(WsaUnitTestsUtils.getFailedMessagePrefix(relatedSpecification) + "faults have different faultCause \n" + "\t(-> toCheckFault  faultCause is " + (toCheckFaultCause != null ? "not null" : "null") + "\n\t-> expectedFault faultCause is " + (expectedFaultCause != null ? "not null" : "null") + ")"), (toCheckFaultCause == null && expectedFaultCause == null || toCheckFaultCause != null && expectedFaultCause != null ? 1 : 0) != 0);
        if (toCheckFaultCause != null) {
            String expectedAnyAsString;
            Element toCheckFaultCauseAny = toCheckFaultCause.getAny();
            Element expectedFaultCauseAny = expectedFaultCause.getAny();
            String toCheckAnyAsString = toCheckFaultCauseAny != null && toCheckFaultCauseAny instanceof Element ? WsaUnitTestsUtils.formatToComparison(toCheckFaultCauseAny) : null;
            String string = expectedAnyAsString = expectedFaultCauseAny != null && expectedFaultCauseAny instanceof Element ? WsaUnitTestsUtils.formatToComparison(expectedFaultCauseAny) : null;
            if (isDebug) {
                System.out.println("[DEBUG] --> toCheckFaultCauseAny : " + toCheckFaultCauseAny + "\n\t(nodesAsString = " + toCheckAnyAsString + ")" + "\n[DEBUG] --> expectedFaultCauseAny : " + expectedFaultCauseAny + "\n\t(nodesAsString = " + toCheckAnyAsString + ")\n");
            }
            Assert.assertTrue((String)(WsaUnitTestsUtils.getFailedMessagePrefix(relatedSpecification) + "endpoints metadata content are different \n" + "\t(-> toCheckFault formatted to comparison faultCause value is : " + (toCheckFaultCauseAny != null ? toCheckFaultCauseAny : null) + "\n\t-> expectedFault formatted to comparison faultCause value is : " + (expectedFaultCauseAny != null ? expectedFaultCauseAny : null) + ")"), (toCheckAnyAsString == null && expectedAnyAsString == null || expectedAnyAsString != null && toCheckAnyAsString != null && toCheckAnyAsString.equals(expectedAnyAsString) ? 1 : 0) != 0);
        }
        return true;
    }

    public final void genericCreateWriteAsDOMReadBaseFaultType(String faultCausePath) throws WsrfbfException {
        try {
            BaseFaultType defaultCreatedBaseFault = this.factory.createBaseFaultType(new Date());
            AbsWsrfbfTypesUnitTests.setBaseFaultContentType(defaultCreatedBaseFault, WsrfbfUnitTestsUtils.createDefaultBaseFaultOriginator(), "Ceci est une decription en fran\u00e7ais de la faute", Locale.FRENCH, "6", new URI("http://www.ebmwebsourcing.com/dialect/wsrf/errors"), faultCausePath);
            Document baseFaultAsDOM = this.writer.writeBaseFaultTypeAsDOM(defaultCreatedBaseFault);
            try {
                WsaUnitTestsUtils.validateResult(baseFaultAsDOM, WsrfbfUnitTestsUtils.WSRFBF_XML_SCHEMAS_PATHS, "OASIS \"WS-BaseFaults\"", BaseFaultType.class, this.isDebug);
                System.out.println("\t Unit Test Step 1 (\"create\" and \"write to DOM\") : Passed !\n");
            }
            catch (SAXException e) {
                Assert.fail((String)(WsaUnitTestsUtils.getFailedMessagePrefix("OASIS \"WS-BaseFaults\"") + e.getMessage()));
            }
            BaseFaultType readBaseFault = this.reader.readBaseFaultType(baseFaultAsDOM);
            AbsWsrfbfTypesUnitTests.checkBaseFaultType(defaultCreatedBaseFault, readBaseFault, "OASIS \"WS-BaseFaults\"", this.isDebug);
            System.out.println("\t Unit Test Step 2 (\"read from DOM\") : Passed !");
        }
        catch (URISyntaxException e1) {
            throw new WsrfbfException((Throwable)e1);
        }
    }

    @Test
    public final void testCreateWriteAsDOMReadBaseFaultTypeWithWsnFaultCause() throws WsrfbfException {
        System.out.println("trasnform Properties = " + System.getProperty("javax.xml.transform.TransformerFactory"));
        System.out.println("doc Properties = " + System.getProperty("javax.xml.parsers.DocumentBuilderFactory"));
        System.out.println("\n\t ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n\t ~~~~~~~ unit test \"Create, Write-to-DOM and read-from-DOM BaseFaultType with WS-Notification FaultCause\" ~~~~~~~ \n");
        this.genericCreateWriteAsDOMReadBaseFaultType("/defaultWsnFaultCause.xml");
        System.out.println("\n\t OK, unit test \"Create, Write-to-DOM and read-from-DOM BaseFaultType\" passed !\n\n\t ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n");
    }

    @Test
    public final void testCreateWriteAsDOMReadBaseFaultTypeWithWsrfFaultCause() throws WsrfbfException {
        System.out.println("\n\t ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n\t ~~~~~~~ unit test \"Create, Write-to-DOM and read-from-DOM BaseFaultType with WS-Resource FaultCause \" ~~~~~~~ \n");
        this.genericCreateWriteAsDOMReadBaseFaultType("/defaultWsrfFaultCause.xml");
        System.out.println("\n\t OK, unit test \"Create, Write-to-DOM and read-from-DOM BaseFaultType\" passed !\n\n\t ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n");
    }
}

