/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.wsstar.basefaults.datatypes.api.test.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class WsaUnitTestsUtils {
    public static final String WSA_SPECIFICATION_NAME = "W3C \"WS-Addressing\"";
    public static final String WSA_XML_SCHEMA_PATH = "/schema/wsaddressing10/wsaddressing10.xsd";
    public static final String[] WSA_XML_SCHEMAS_PATHS = new String[]{"/schema/wsaddressing10/wsaddressing10.xsd"};
    public static final String DEFAULT_ENDPOINT_URI_VALUE = "http://myURL/for/test::MyServiceName@myEndpointAddress";
    public static final String TEMP_TEST_DIRECTORY = "tmp" + File.separatorChar;

    public static String getFailedMessagePrefix(String specification) {
        return "\nUnit Tests of " + specification + " Model implementation Failed !\n Failure Cause :\n";
    }

    public static boolean validateResult(Document objAsDOMDoc, String[] xmlSchemasPaths, String specification, Class<?> clazz, boolean isDebug) throws SAXException {
        boolean isValid = false;
        SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        Source[] xmlSchemas = new StreamSource[xmlSchemasPaths.length];
        for (int i = 0; i < xmlSchemasPaths.length; ++i) {
            xmlSchemas[i] = new StreamSource(clazz.getResourceAsStream(xmlSchemasPaths[i]));
        }
        Schema schema = factory.newSchema(xmlSchemas);
        Validator validator = schema.newValidator();
        DOMSource source = new DOMSource(objAsDOMDoc);
        try {
            validator.validate(source);
            if (isDebug) {
                System.out.println("\t(The created DOM Document representation of the \"" + clazz.getSimpleName() + "\" Object\n\t is valid according to " + specification + " xml-schema)\n");
            }
            isValid = true;
        }
        catch (SAXException ex) {
            isValid = false;
            throw new SAXException("\tThe created DOM Document representation of the \"" + clazz.getSimpleName() + " \" Object\n\t is not valid according to " + specification + " xml-schema because : \n " + ex.getMessage() + "\n");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return isValid;
    }

    public static String formatToComparison(Element Elt) {
        String result = Elt.getNodeName() + (Elt.getNodeValue() != null ? "_" + Elt.getNodeValue() + "_" : "_");
        NodeList list = Elt.getElementsByTagName("*");
        for (int i = 0; i < list.getLength(); ++i) {
            Element element = (Element)list.item(i);
            result = result + element.getNodeName() + (element.getNodeValue() != null ? "_" + element.getNodeValue() + "_" : "_");
            if (element.getElementsByTagName("*").getLength() != 0) continue;
            String curentContentText = element.getNodeValue();
            if (curentContentText == null) {
                curentContentText = "";
            }
            curentContentText.replaceAll("\t", "").replaceAll("\n", "").replaceAll(" ", "");
            if (curentContentText.isEmpty()) continue;
            result = result + curentContentText + "_";
        }
        return result;
    }

    public static Document fromStreamToDocument(InputStream stream) {
        Document result = null;
        try {
            Document parsedXmlDoc;
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            result = parsedXmlDoc = builder.parse(stream);
        }
        catch (ParserConfigurationException pce) {
            pce.printStackTrace();
        }
        catch (SAXException se) {
            se.printStackTrace();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return result;
    }
}

