package com.ebmwebsourcing.wsstar.basenotification.datatypes.impl.impl;

import java.util.Date;
import java.util.logging.Logger;

import com.ebmwebsourcing.wsstar.basefaults.datatypes.impl.impl.BaseFaultTypeImpl;
import com.ebmwebsourcing.wsstar.basefaults.datatypes.impl.utils.WsrfbfUtils;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.PauseFailedFaultType;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.impl.WsnbJAXBContext;

import easybox.org.oasis_open.docs.wsn.b_2.EJaxbPauseFailedFaultType;

public class PauseFailedFaultTypeImpl extends BaseFaultTypeImpl implements
		PauseFailedFaultType {
	/**
	 * Default constructor
	 * 
	 * Note : According to the xml schema the "timestamp" field is mandatory
	 * 
	 * @param timestamp the timestamp of the {@link PauseFailedFaultType) object that must
	 * 		  be {@link Date} representation of an Date xml type.
	 */
	protected PauseFailedFaultTypeImpl(Date timestamp){
		super(Logger.getLogger(PauseFailedFaultTypeImpl.class.getSimpleName()));
		
		EJaxbPauseFailedFaultType jaxbTypeObj = 
			new EJaxbPauseFailedFaultType();
		
		jaxbTypeObj.setTimestamp(WsrfbfUtils.toXMLGregorianCalendar(timestamp, this.getLogger()));
		
		this.setJaxbTypeObj(jaxbTypeObj);
	}
	
	protected PauseFailedFaultTypeImpl(EJaxbPauseFailedFaultType jaxbTypeObj){
		super(jaxbTypeObj,Logger.getLogger(PauseFailedFaultTypeImpl.class.getSimpleName()));
	}
	
	/**
	 * A way to create a  {@link EJaxbPauseFailedFaultType}
	 *  "Jaxb model type" object from a {@link PauseFailedFaultType} "api type" one  
	 *    
	 * @param apiTypeObj
	 */
	public static EJaxbPauseFailedFaultType toJaxbModel(PauseFailedFaultType apiTypeObj){

		EJaxbPauseFailedFaultType jaxbTypeObj = null;

		if (apiTypeObj instanceof PauseFailedFaultTypeImpl) {
			jaxbTypeObj = (EJaxbPauseFailedFaultType)
			((PauseFailedFaultTypeImpl)apiTypeObj).getJaxbTypeObj();
		} else {
			jaxbTypeObj = (EJaxbPauseFailedFaultType) 
			BaseFaultTypeImpl.toJaxbModel(apiTypeObj,
					WsnbJAXBContext.WSNB_JAXB_FACTORY.createEJaxbPauseFailedFaultType());
		}
		return jaxbTypeObj;
	}
}
