package com.ebmwebsourcing.wsstar.basenotification.datatypes.impl.impl;

import java.util.Date;
import java.util.logging.Logger;

import com.ebmwebsourcing.wsstar.basefaults.datatypes.impl.impl.BaseFaultTypeImpl;
import com.ebmwebsourcing.wsstar.basefaults.datatypes.impl.utils.WsrfbfUtils;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.UnableToDestroyPullPointFaultType;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.impl.WsnbJAXBContext;

import easybox.org.oasis_open.docs.wsn.b_2.EJaxbUnableToDestroyPullPointFaultType;

public class UnableToDestroyPullPointFaultTypeImpl extends BaseFaultTypeImpl
		implements UnableToDestroyPullPointFaultType {
	/**
	 * Default constructor
	 * 
	 * Note : According to the xml schema the "timestamp" field is mandatory
	 * 
	 * @param timestamp the timestamp of the {@link UnableToDestroyPullPointFaultType) object that must
	 * 		  be {@link Date} representation of an Date xml type.
	 */
	protected UnableToDestroyPullPointFaultTypeImpl(Date timestamp){
		super(Logger.getLogger(UnableToDestroyPullPointFaultTypeImpl.class.getSimpleName()));
		
		EJaxbUnableToDestroyPullPointFaultType jaxbTypeObj = 
			new EJaxbUnableToDestroyPullPointFaultType();
		
		jaxbTypeObj.setTimestamp(WsrfbfUtils.toXMLGregorianCalendar(timestamp, this.getLogger()));
		
		this.setJaxbTypeObj(jaxbTypeObj);
	}
	
	protected UnableToDestroyPullPointFaultTypeImpl(EJaxbUnableToDestroyPullPointFaultType jaxbTypeObj){
		super(jaxbTypeObj,Logger.getLogger(UnableToDestroyPullPointFaultTypeImpl.class.getSimpleName()));
	}
	
	/**
	 * A way to create a  {@link EJaxbUnableToDestroyPullPointFaultType}
	 *  "Jaxb model type" object from a {@link UnableToDestroyPullPointFaultType} "api type" one  
	 *    
	 * @param apiTypeObj
	 */
	public static EJaxbUnableToDestroyPullPointFaultType toJaxbModel(UnableToDestroyPullPointFaultType apiTypeObj){

		EJaxbUnableToDestroyPullPointFaultType jaxbTypeObj = null;

		if (apiTypeObj instanceof UnableToDestroyPullPointFaultTypeImpl) {
			jaxbTypeObj = (EJaxbUnableToDestroyPullPointFaultType)
			((UnableToDestroyPullPointFaultTypeImpl)apiTypeObj).getJaxbTypeObj();
		} else {
			jaxbTypeObj = (EJaxbUnableToDestroyPullPointFaultType) 
			BaseFaultTypeImpl.toJaxbModel(apiTypeObj,
					WsnbJAXBContext.WSNB_JAXB_FACTORY.createEJaxbUnableToDestroyPullPointFaultType());
		}
		return jaxbTypeObj;
	}
}
