package com.ebmwebsourcing.wsstar.basenotification.datatypes.impl.impl;

import java.util.Date;
import java.util.List;
import java.util.logging.Logger;

import javax.xml.namespace.QName;

import com.ebmwebsourcing.wsstar.basefaults.datatypes.impl.impl.BaseFaultTypeImpl;
import com.ebmwebsourcing.wsstar.basefaults.datatypes.impl.utils.WsrfbfUtils;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.UnrecognizedPolicyRequestFaultType;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.impl.WsnbJAXBContext;

import easybox.org.oasis_open.docs.wsn.b_2.EJaxbUnrecognizedPolicyRequestFaultType;

public class UnrecognizedPolicyRequestFaultTypeImpl extends BaseFaultTypeImpl
		implements UnrecognizedPolicyRequestFaultType {
	/**
	 * Default constructor
	 * 
	 * Note : According to the xml schema the "timestamp" field is mandatory
	 * 
	 * @param timestamp the timestamp of the {@link UnrecognizedPolicyRequestFaultType) object that must
	 * 		  be {@link Date} representation of an Date xml type.
	 */
	protected UnrecognizedPolicyRequestFaultTypeImpl(Date timestamp){
		super(Logger.getLogger(UnrecognizedPolicyRequestFaultTypeImpl.class.getSimpleName()));
		
		EJaxbUnrecognizedPolicyRequestFaultType jaxbTypeObj = 
			new EJaxbUnrecognizedPolicyRequestFaultType();
		
		jaxbTypeObj.setTimestamp(WsrfbfUtils.toXMLGregorianCalendar(timestamp, this.getLogger()));
		
		this.setJaxbTypeObj(jaxbTypeObj);
	}
	
	protected UnrecognizedPolicyRequestFaultTypeImpl(EJaxbUnrecognizedPolicyRequestFaultType jaxbTypeObj){
		super(jaxbTypeObj,Logger.getLogger(UnrecognizedPolicyRequestFaultTypeImpl.class.getSimpleName()));
	}
	
	@Override
	public final List<QName> getUnrecognizedPolicies() {
		return ((EJaxbUnrecognizedPolicyRequestFaultType)this.getJaxbTypeObj()).getUnrecognizedPolicy();
	}
	
	@Override
	public final void addUnrecognizedPolicy(QName value) {
		((EJaxbUnrecognizedPolicyRequestFaultType)this.getJaxbTypeObj()).getUnrecognizedPolicy().add(value);
	}
	
	
	/**
	 * A way to create a  {@link EJaxbUnrecognizedPolicyRequestFaultType}
	 *  "Jaxb model type" object from a {@link UnrecognizedPolicyRequestFaultType} "api type" one  
	 *    
	 * @param apiTypeObj
	 */
	public static EJaxbUnrecognizedPolicyRequestFaultType toJaxbModel(UnrecognizedPolicyRequestFaultType apiTypeObj){

		EJaxbUnrecognizedPolicyRequestFaultType jaxbTypeObj = null;
		
		if (apiTypeObj instanceof UnrecognizedPolicyRequestFaultTypeImpl) {
			jaxbTypeObj = (EJaxbUnrecognizedPolicyRequestFaultType)
				((UnrecognizedPolicyRequestFaultTypeImpl)apiTypeObj).getJaxbTypeObj();
		} else {
			jaxbTypeObj = (EJaxbUnrecognizedPolicyRequestFaultType) 
			BaseFaultTypeImpl.toJaxbModel(apiTypeObj,
					WsnbJAXBContext.WSNB_JAXB_FACTORY.createEJaxbUnrecognizedPolicyRequestFaultType());
			
			// ~~~~ Set UnrecognizedPolicy QNames ~~~~~
			List<QName> unrecognizedPolicyQnames = apiTypeObj.getUnrecognizedPolicies();
			if (unrecognizedPolicyQnames != null && unrecognizedPolicyQnames.size() > 0){
				jaxbTypeObj.getUnrecognizedPolicy().addAll(unrecognizedPolicyQnames);
			}
		}
		return jaxbTypeObj;
	}
}
