package com.ebmwebsourcing.wsstar.basenotification.datatypes.impl.impl;

import java.net.URI;
import java.util.logging.Logger;

import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.MessageContentExpression;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.QueryExpressionType;

import easybox.org.oasis_open.docs.wsn.b_2.EJaxbQueryExpressionType;

public class MessageContentExpressionImpl extends QueryExpressionTypeImpl
		implements MessageContentExpression {
	
	private static Logger logger  = Logger.getLogger(MessageContentExpressionImpl.class.getSimpleName());
	
	/**
	 * Default constructor
	 */
	protected MessageContentExpressionImpl(URI dialect) {
		super(dialect, MessageContentExpressionImpl.logger);		
	}

	public MessageContentExpressionImpl(EJaxbQueryExpressionType jaxbTypeObj){
		super(jaxbTypeObj, MessageContentExpressionImpl.logger);
	}
	
	/**
	 * A way to create a  {@link EJaxbQueryExpressionType}
	 * object from a {@link MessageContentExpression} "api type" one  
	 *    
	 * @param apiTypeObj
	 */
	public static EJaxbQueryExpressionType toJaxbModel(MessageContentExpression apiTypeObj)	{
		
		QueryExpressionType param = (apiTypeObj instanceof MessageContentExpressionImpl) ?
				(QueryExpressionTypeImpl)apiTypeObj :
					(QueryExpressionType)apiTypeObj;
		
		return QueryExpressionTypeImpl.toJaxbModel(param);
	}
}
