package com.ebmwebsourcing.wsstar.basenotification.datatypes.impl.impl;

import java.net.URI;
import java.util.logging.Logger;

import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.ProducerPropertiesExpression;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.QueryExpressionType;

import easybox.org.oasis_open.docs.wsn.b_2.EJaxbQueryExpressionType;

public class ProducerPropertiesExpressionImpl extends QueryExpressionTypeImpl
		implements ProducerPropertiesExpression {
	private static Logger logger  = Logger.getLogger(MessageContentExpressionImpl.class.getSimpleName());
	
	/**
	 * Default constructor
	 */
	protected ProducerPropertiesExpressionImpl(URI dialect) {
		super(dialect, ProducerPropertiesExpressionImpl.logger);		
	}

	protected ProducerPropertiesExpressionImpl(EJaxbQueryExpressionType jaxbTypeObj){
		super(jaxbTypeObj, ProducerPropertiesExpressionImpl.logger);
	}
	
	/**
	 * A way to create a  {@link EJaxbQueryExpressionType}
	 * object from a {@link ProducerPropertiesExpression} "api type" one  
	 *    
	 * @param apiTypeObj
	 */
	public static EJaxbQueryExpressionType toJaxbModel(ProducerPropertiesExpression apiTypeObj){
		
		QueryExpressionType param = (apiTypeObj instanceof ProducerPropertiesExpressionImpl) ?
				(QueryExpressionTypeImpl)apiTypeObj :
					(QueryExpressionType)apiTypeObj;
		
		return QueryExpressionTypeImpl.toJaxbModel(param);
	}
}
