package com.ebmwebsourcing.wsstar.basenotification.datatypes.impl.impl;

import java.util.Date;
import java.util.logging.Logger;

import com.ebmwebsourcing.wsstar.basefaults.datatypes.impl.impl.BaseFaultTypeImpl;
import com.ebmwebsourcing.wsstar.basefaults.datatypes.impl.utils.WsrfbfUtils;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.ResumeFailedFaultType;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.impl.WsnbJAXBContext;

import easybox.org.oasis_open.docs.wsn.b_2.EJaxbResumeFailedFaultType;

public class ResumeFailedFaultTypeImpl extends BaseFaultTypeImpl implements
		ResumeFailedFaultType {
	/**
	 * Default constructor
	 * 
	 * Note : According to the xml schema the "timestamp" field is mandatory
	 * 
	 * @param timestamp the timestamp of the {@link ResumeFailedFaultType) object that must
	 * 		  be {@link Date} representation of an Date xml type.
	 */
	protected ResumeFailedFaultTypeImpl(Date timestamp){
		super(Logger.getLogger(ResumeFailedFaultTypeImpl.class.getSimpleName()));
		
		EJaxbResumeFailedFaultType jaxbTypeObj = 
			new EJaxbResumeFailedFaultType();
		
		jaxbTypeObj.setTimestamp(WsrfbfUtils.toXMLGregorianCalendar(timestamp, this.getLogger()));
		
		this.setJaxbTypeObj(jaxbTypeObj);
	}
	
	protected ResumeFailedFaultTypeImpl(EJaxbResumeFailedFaultType jaxbTypeObj){
		super(jaxbTypeObj,Logger.getLogger(ResumeFailedFaultTypeImpl.class.getSimpleName()));
	}
	
	/**
	 * A way to create a  {@link EJaxbResumeFailedFaultType}
	 *  "Jaxb model type" object from a {@link ResumeFailedFaultType} "api type" one  
	 *    
	 * @param apiTypeObj
	 */
	public static EJaxbResumeFailedFaultType toJaxbModel(ResumeFailedFaultType apiTypeObj){

		EJaxbResumeFailedFaultType jaxbTypeObj = null;

		if (apiTypeObj instanceof ResumeFailedFaultTypeImpl) {
			jaxbTypeObj = (EJaxbResumeFailedFaultType)
			((ResumeFailedFaultTypeImpl)apiTypeObj).getJaxbTypeObj();
		} else {
			jaxbTypeObj = (EJaxbResumeFailedFaultType) 
			BaseFaultTypeImpl.toJaxbModel(apiTypeObj,
					WsnbJAXBContext.WSNB_JAXB_FACTORY.createEJaxbResumeFailedFaultType());
		}
		return jaxbTypeObj;
	}
}
