package com.ebmwebsourcing.wsstar.basenotification.datatypes.impl.impl;

import java.util.Date;
import java.util.logging.Logger;

import com.ebmwebsourcing.wsstar.basefaults.datatypes.impl.impl.BaseFaultTypeImpl;
import com.ebmwebsourcing.wsstar.basefaults.datatypes.impl.utils.WsrfbfUtils;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.MultipleTopicsSpecifiedFaultType;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.impl.WsnbJAXBContext;

import easybox.org.oasis_open.docs.wsn.b_2.EJaxbMultipleTopicsSpecifiedFaultType;

public class MultipleTopicsSpecifiedFaultTypeImpl extends BaseFaultTypeImpl
		implements MultipleTopicsSpecifiedFaultType {
	/**
	 * Default constructor
	 * 
	 * Note : According to the xml schema the "timestamp" field is mandatory
	 * 
	 * @param timestamp the timestamp of the {@link MultipleTopicsSpecifiedFaultType) object that must
	 * 		  be {@link Date} representation of an Date xml type.
	 */
	protected MultipleTopicsSpecifiedFaultTypeImpl(Date timestamp){
		super(Logger.getLogger(MultipleTopicsSpecifiedFaultTypeImpl.class.getSimpleName()));
		
		EJaxbMultipleTopicsSpecifiedFaultType jaxbTypeObj = 
			new EJaxbMultipleTopicsSpecifiedFaultType();
		
		jaxbTypeObj.setTimestamp(WsrfbfUtils.toXMLGregorianCalendar(timestamp, this.getLogger()));
		
		this.setJaxbTypeObj(jaxbTypeObj);
	}
	
	protected MultipleTopicsSpecifiedFaultTypeImpl(EJaxbMultipleTopicsSpecifiedFaultType jaxbTypeObj){
		super(jaxbTypeObj,Logger.getLogger(MultipleTopicsSpecifiedFaultTypeImpl.class.getSimpleName()));
	}
	
	/**
	 * A way to create a  {@link EJaxbMultipleTopicsSpecifiedFaultType}
	 *  "Jaxb model type" object from a {@link MultipleTopicsSpecifiedFaultType} "api type" one  
	 *    
	 * @param apiTypeObj
	 */
	public static EJaxbMultipleTopicsSpecifiedFaultType toJaxbModel(MultipleTopicsSpecifiedFaultType apiTypeObj){

		EJaxbMultipleTopicsSpecifiedFaultType jaxbTypeObj = null;

		if (apiTypeObj instanceof MultipleTopicsSpecifiedFaultTypeImpl) {
			jaxbTypeObj = (EJaxbMultipleTopicsSpecifiedFaultType)
			((MultipleTopicsSpecifiedFaultTypeImpl)apiTypeObj).getJaxbTypeObj();
		} else {
			jaxbTypeObj = (EJaxbMultipleTopicsSpecifiedFaultType) 
			BaseFaultTypeImpl.toJaxbModel(apiTypeObj,
					WsnbJAXBContext.WSNB_JAXB_FACTORY.createEJaxbMultipleTopicsSpecifiedFaultType());
		}
		return jaxbTypeObj;
	}
}
