package com.ebmwebsourcing.wsstar.basenotification.datatypes.impl.impl;

import java.util.ArrayList;
import java.util.List;

import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.NotificationMessageHolderType;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.Notify;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.impl.WsnbJAXBContext;

import easybox.org.oasis_open.docs.wsn.b_2.EJaxbNotificationMessageHolderType;
import easybox.org.oasis_open.docs.wsn.b_2.EJaxbNotify;

public class NotifyImpl implements Notify {

	private EJaxbNotify jaxbTypeObj;
//	private static Logger logger  = Logger.getLogger(NotifyImpl.class.getSimpleName());
	
	/**
	 * Default constructor
	 */
	protected NotifyImpl(NotificationMessageHolderType notifyMsg) {		
		this.jaxbTypeObj = WsnbJAXBContext.WSNB_JAXB_FACTORY.createEJaxbNotify();
		this.jaxbTypeObj.getNotificationMessage().add(NotificationMessageHolderTypeImpl.toJaxbModel(notifyMsg));		
	}

	protected NotifyImpl(EJaxbNotify jaxbTypeObj){
		this.jaxbTypeObj = jaxbTypeObj;
	}
	
	protected final EJaxbNotify getJaxbTypeObj() {
		return jaxbTypeObj;
	}
	
	@Override
	public final List<NotificationMessageHolderType> getNotificationMessage() {
		List<NotificationMessageHolderType> notifMsgHolders = new ArrayList<NotificationMessageHolderType>();
		
		List<EJaxbNotificationMessageHolderType> jaxbNotifMsgHolders =
			this.jaxbTypeObj.getNotificationMessage();		
		
		for (EJaxbNotificationMessageHolderType notifMsgItem : jaxbNotifMsgHolders) {
			notifMsgHolders.add(new NotificationMessageHolderTypeImpl(notifMsgItem));
		}		
		return notifMsgHolders;
	}

	@Override
	public final void addNotificationMessage(NotificationMessageHolderType msg) {
		this.jaxbTypeObj.getNotificationMessage().add(NotificationMessageHolderTypeImpl.toJaxbModel(msg));
	}
	
	/**
	 * A way to create a  {@link EJaxbNotificationMessageHolderType}
	 *  "Jaxb model type" object from a {@link NotificationMessageHolderType} "api type" one  
	 * @param apiTypeObj
	 * @return
	 */
	public static EJaxbNotify toJaxbModel(
			Notify apiTypeObj) {
		EJaxbNotify jaxbTypeObj = null;
		
		if (apiTypeObj instanceof NotifyImpl){
			jaxbTypeObj = ((NotifyImpl)apiTypeObj).getJaxbTypeObj();
		} else {
			jaxbTypeObj = WsnbJAXBContext.WSNB_JAXB_FACTORY.createEJaxbNotify();
			
			// ~~~~ Set NotificationMessageHolders ~~~~~
			List<NotificationMessageHolderType> notifmsgs = apiTypeObj.getNotificationMessage();
			for (NotificationMessageHolderType notifMsgHolderItem : notifmsgs) {
				jaxbTypeObj.getNotificationMessage().add(NotificationMessageHolderTypeImpl.toJaxbModel(notifMsgHolderItem));
			}			
		}
		return jaxbTypeObj;
	}
	
	@Override
	public List<Object> getAny() {
		return this.jaxbTypeObj.getAny();
	}
}
