package com.ebmwebsourcing.wsstar.basenotification.datatypes.impl.impl;

import java.util.Date;
import java.util.logging.Logger;

import com.ebmwebsourcing.wsstar.basefaults.datatypes.impl.impl.BaseFaultTypeImpl;
import com.ebmwebsourcing.wsstar.basefaults.datatypes.impl.utils.WsrfbfUtils;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.NotifyMessageNotSupportedFaultType;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.impl.WsnbJAXBContext;

import easybox.org.oasis_open.docs.wsn.b_2.EJaxbNotifyMessageNotSupportedFaultType;

public class NotifyMessageNotSupportedFaultTypeImpl extends BaseFaultTypeImpl
		implements NotifyMessageNotSupportedFaultType {
	/**
	 * Default constructor
	 * 
	 * Note : According to the xml schema the "timestamp" field is mandatory
	 * 
	 * @param timestamp the timestamp of the {@link NotifyMessageNotSupportedFaultType) object that must
	 * 		  be {@link Date} representation of an Date xml type.
	 */
	protected NotifyMessageNotSupportedFaultTypeImpl(Date timestamp){
		super(Logger.getLogger(NotifyMessageNotSupportedFaultTypeImpl.class.getSimpleName()));
		
		EJaxbNotifyMessageNotSupportedFaultType	jaxbTypeObj =
			new EJaxbNotifyMessageNotSupportedFaultType();
		
		jaxbTypeObj.setTimestamp(WsrfbfUtils.toXMLGregorianCalendar(timestamp, this.getLogger()));
		
		this.setJaxbTypeObj(jaxbTypeObj);
	}
	
	protected NotifyMessageNotSupportedFaultTypeImpl(EJaxbNotifyMessageNotSupportedFaultType jaxbTypeObj){
		super(jaxbTypeObj,Logger.getLogger(NotifyMessageNotSupportedFaultTypeImpl.class.getSimpleName()));
	}
	
	/**
	 * A way to create a  {@link EJaxbNotifyMessageNotSupportedFaultType}
	 *  "Jaxb model type" object from a {@link NotifyMessageNotSupportedFaultType} "api type" one  
	 *    
	 * @param apiTypeObj
	 */
	public static EJaxbNotifyMessageNotSupportedFaultType toJaxbModel(NotifyMessageNotSupportedFaultType apiTypeObj){

		EJaxbNotifyMessageNotSupportedFaultType jaxbTypeObj = null;

		if (apiTypeObj instanceof NotifyMessageNotSupportedFaultTypeImpl) {
			jaxbTypeObj = (EJaxbNotifyMessageNotSupportedFaultType)
			((NotifyMessageNotSupportedFaultTypeImpl)apiTypeObj).getJaxbTypeObj();
		} else {
			jaxbTypeObj = (EJaxbNotifyMessageNotSupportedFaultType) 
			BaseFaultTypeImpl.toJaxbModel(apiTypeObj,
					WsnbJAXBContext.WSNB_JAXB_FACTORY.createEJaxbNotifyMessageNotSupportedFaultType());
		}
		return jaxbTypeObj;
	}
}
