package com.ebmwebsourcing.wsstar.basenotification.datatypes.impl.impl;

import java.util.Date;
import java.util.logging.Logger;

import com.ebmwebsourcing.wsstar.basefaults.datatypes.impl.impl.BaseFaultTypeImpl;
import com.ebmwebsourcing.wsstar.basefaults.datatypes.impl.utils.WsrfbfUtils;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.InvalidTopicExpressionFaultType;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.impl.WsnbJAXBContext;

import easybox.org.oasis_open.docs.wsn.b_2.EJaxbInvalidTopicExpressionFaultType;

public class InvalidTopicExpressionFaultTypeImpl extends BaseFaultTypeImpl
		implements InvalidTopicExpressionFaultType {
	/**
	 * Default constructor
	 * 
	 * Note : According to the xml schema the "timestamp" field is mandatory
	 * 
	 * @param timestamp the timestamp of the {@link InvalidTopicExpressionFaultType) object that must
	 * 		  be {@link Date} representation of an Date xml type.
	 */
	protected InvalidTopicExpressionFaultTypeImpl(Date timestamp){
		super(Logger.getLogger(InvalidTopicExpressionFaultTypeImpl.class.getSimpleName()));
		
		EJaxbInvalidTopicExpressionFaultType jaxbTypeObj = 
			new EJaxbInvalidTopicExpressionFaultType();
		
		jaxbTypeObj.setTimestamp(WsrfbfUtils.toXMLGregorianCalendar(timestamp, this.getLogger()));
		
		this.setJaxbTypeObj(jaxbTypeObj);
	}
	
	protected InvalidTopicExpressionFaultTypeImpl(EJaxbInvalidTopicExpressionFaultType jaxbTypeObj){
		super(jaxbTypeObj,Logger.getLogger(InvalidTopicExpressionFaultTypeImpl.class.getSimpleName()));
	}
	
	/**
	 * A way to create a  {@link EJaxbInvalidTopicExpressionFaultType}
	 *  "Jaxb model type" object from a {@link InvalidTopicExpressionFaultType} "api type" one  
	 *    
	 * @param apiTypeObj
	 */
	public static EJaxbInvalidTopicExpressionFaultType toJaxbModel(InvalidTopicExpressionFaultType apiTypeObj){

		EJaxbInvalidTopicExpressionFaultType jaxbTypeObj = null;

		if (apiTypeObj instanceof InvalidTopicExpressionFaultTypeImpl) {
			jaxbTypeObj = (EJaxbInvalidTopicExpressionFaultType)
			((InvalidTopicExpressionFaultTypeImpl)apiTypeObj).getJaxbTypeObj();
		} else {
			jaxbTypeObj = (EJaxbInvalidTopicExpressionFaultType) 
			BaseFaultTypeImpl.toJaxbModel(apiTypeObj,
					WsnbJAXBContext.WSNB_JAXB_FACTORY.createEJaxbInvalidTopicExpressionFaultType());
		}
		return jaxbTypeObj;
	}
}
