package com.ebmwebsourcing.wsstar.basenotification.datatypes.impl.impl;

import java.util.Date;
import java.util.logging.Logger;

import com.ebmwebsourcing.wsstar.basefaults.datatypes.impl.impl.BaseFaultTypeImpl;
import com.ebmwebsourcing.wsstar.basefaults.datatypes.impl.utils.WsrfbfUtils;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.InvalidProducerPropertiesExpressionFaultType;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.impl.WsnbJAXBContext;

import easybox.org.oasis_open.docs.wsn.b_2.EJaxbInvalidProducerPropertiesExpressionFaultType;

public class InvalidProducerPropertiesExpressionFaultTypeImpl extends BaseFaultTypeImpl
		implements	InvalidProducerPropertiesExpressionFaultType {
	/**
	 * Default constructor
	 * 
	 * Note : According to the xml schema the "timestamp" field is mandatory
	 * 
	 * @param timestamp the timestamp of the {@link InvalidProducerPropertiesExpressionFaultType) object that must
	 * 		  be {@link Date} representation of an Date xml type.
	 */
	protected InvalidProducerPropertiesExpressionFaultTypeImpl(Date timestamp){
		super(Logger.getLogger(InvalidProducerPropertiesExpressionFaultTypeImpl.class.getSimpleName()));
		
		EJaxbInvalidProducerPropertiesExpressionFaultType jaxbTypeObj =
			new EJaxbInvalidProducerPropertiesExpressionFaultType();
		
		jaxbTypeObj.setTimestamp(WsrfbfUtils.toXMLGregorianCalendar(timestamp, this.getLogger()));
		
		this.setJaxbTypeObj(jaxbTypeObj);
	}
	
	protected InvalidProducerPropertiesExpressionFaultTypeImpl(EJaxbInvalidProducerPropertiesExpressionFaultType jaxbTypeObj){
		super(jaxbTypeObj,Logger.getLogger(InvalidProducerPropertiesExpressionFaultTypeImpl.class.getSimpleName()));
	}
	
	/**
	 * A way to create a  {@link EJaxbInvalidProducerPropertiesExpressionFaultType}
	 *  "Jaxb model type" object from a {@link InvalidProducerPropertiesExpressionFaultType} api type" one  
	 *    
	 * @param apiTypeObj
	 */
	public static EJaxbInvalidProducerPropertiesExpressionFaultType toJaxbModel(InvalidProducerPropertiesExpressionFaultType apiTypeObj){

		EJaxbInvalidProducerPropertiesExpressionFaultType jaxbTypeObj = null;

		if (apiTypeObj instanceof InvalidProducerPropertiesExpressionFaultTypeImpl) {
			jaxbTypeObj = (EJaxbInvalidProducerPropertiesExpressionFaultType)
			((InvalidProducerPropertiesExpressionFaultTypeImpl)apiTypeObj).getJaxbTypeObj();
		} else {
			jaxbTypeObj = (EJaxbInvalidProducerPropertiesExpressionFaultType) 
			BaseFaultTypeImpl.toJaxbModel(apiTypeObj,
					WsnbJAXBContext.WSNB_JAXB_FACTORY.createEJaxbInvalidProducerPropertiesExpressionFaultType());
		}
		return jaxbTypeObj;
	}
}
