package com.ebmwebsourcing.wsstar.basenotification.datatypes.impl.impl;

import java.util.Date;
import java.util.logging.Logger;

import com.ebmwebsourcing.wsstar.basefaults.datatypes.impl.impl.BaseFaultTypeImpl;
import com.ebmwebsourcing.wsstar.basefaults.datatypes.impl.utils.WsrfbfUtils;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.TopicExpressionDialectUnknownFaultType;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.impl.WsnbJAXBContext;

import easybox.org.oasis_open.docs.wsn.b_2.EJaxbTopicExpressionDialectUnknownFaultType;

public class TopicExpressionDialectUnknownFaultTypeImpl extends
		BaseFaultTypeImpl implements TopicExpressionDialectUnknownFaultType {
	/**
	 * Default constructor
	 * 
	 * Note : According to the xml schema the "timestamp" field is mandatory
	 * 
	 * @param timestamp the timestamp of the {@link TopicExpressionDialectUnknownFaultType) object that must
	 * 		  be {@link Date} representation of an Date xml type.
	 */
	protected TopicExpressionDialectUnknownFaultTypeImpl(Date timestamp){
		super(Logger.getLogger(TopicExpressionDialectUnknownFaultTypeImpl.class.getSimpleName()));
		
		EJaxbTopicExpressionDialectUnknownFaultType jaxbTypeObj = 
			new EJaxbTopicExpressionDialectUnknownFaultType();
		
		jaxbTypeObj.setTimestamp(WsrfbfUtils.toXMLGregorianCalendar(timestamp, this.getLogger()));
		
		this.setJaxbTypeObj(jaxbTypeObj);
	}
	
	protected TopicExpressionDialectUnknownFaultTypeImpl(EJaxbTopicExpressionDialectUnknownFaultType jaxbTypeObj){
		super(jaxbTypeObj,Logger.getLogger(TopicExpressionDialectUnknownFaultTypeImpl.class.getSimpleName()));
	}
	
	/**
	 * A way to create a  {@link EJaxbTopicExpressionDialectUnknownFaultType}
	 *  "Jaxb model type" object from a {@link TopicExpressionDialectUnknownFaultType} "api type" one  
	 *    
	 * @param apiTypeObj
	 */
	public static EJaxbTopicExpressionDialectUnknownFaultType toJaxbModel(TopicExpressionDialectUnknownFaultType apiTypeObj){

		EJaxbTopicExpressionDialectUnknownFaultType jaxbTypeObj = null;

		if (apiTypeObj instanceof TopicExpressionDialectUnknownFaultTypeImpl) {
			jaxbTypeObj = (EJaxbTopicExpressionDialectUnknownFaultType)
			((TopicExpressionDialectUnknownFaultTypeImpl)apiTypeObj).getJaxbTypeObj();
		} else {
			jaxbTypeObj = (EJaxbTopicExpressionDialectUnknownFaultType) 
			BaseFaultTypeImpl.toJaxbModel(apiTypeObj,
					WsnbJAXBContext.WSNB_JAXB_FACTORY.createEJaxbTopicExpressionDialectUnknownFaultType());
		}
		return jaxbTypeObj;
	}
}
