package com.ebmwebsourcing.wsstar.basenotification.datatypes.impl.impl;

import java.util.Date;
import java.util.logging.Logger;

import com.ebmwebsourcing.wsstar.basefaults.datatypes.impl.impl.BaseFaultTypeImpl;
import com.ebmwebsourcing.wsstar.basefaults.datatypes.impl.utils.WsrfbfUtils;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.UnableToCreatePullPointFaultType;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.impl.WsnbJAXBContext;

import easybox.org.oasis_open.docs.wsn.b_2.EJaxbUnableToCreatePullPointFaultType;

public class UnableToCreatePullPointFaultTypeImpl extends BaseFaultTypeImpl
		implements UnableToCreatePullPointFaultType {
	/**
	 * Default constructor
	 * 
	 * Note : According to the xml schema the "timestamp" field is mandatory
	 * 
	 * @param timestamp the timestamp of the {@link UnableToCreatePullPointFaultType) object that must
	 * 		  be {@link Date} representation of an Date xml type.
	 */
	protected UnableToCreatePullPointFaultTypeImpl(Date timestamp){
		super(Logger.getLogger(UnableToCreatePullPointFaultTypeImpl.class.getSimpleName()));
		
		EJaxbUnableToCreatePullPointFaultType jaxbTypeObj = 
			new EJaxbUnableToCreatePullPointFaultType();
		
		jaxbTypeObj.setTimestamp(WsrfbfUtils.toXMLGregorianCalendar(timestamp, this.getLogger()));
		
		this.setJaxbTypeObj(jaxbTypeObj);
	}
	
	protected UnableToCreatePullPointFaultTypeImpl(EJaxbUnableToCreatePullPointFaultType jaxbTypeObj){
		super(jaxbTypeObj,Logger.getLogger(UnableToCreatePullPointFaultTypeImpl.class.getSimpleName()));
	}
	
	/**
	 * A way to create a  {@link EJaxbUnableToCreatePullPointFaultType}
	 *  "Jaxb model type" object from a {@link UnableToCreatePullPointFaultType} "api type" one  
	 *    
	 * @param apiTypeObj
	 */
	public static EJaxbUnableToCreatePullPointFaultType toJaxbModel(UnableToCreatePullPointFaultType apiTypeObj){

		EJaxbUnableToCreatePullPointFaultType jaxbTypeObj = null;

		if (apiTypeObj instanceof UnableToCreatePullPointFaultTypeImpl) {
			jaxbTypeObj = (EJaxbUnableToCreatePullPointFaultType)
			((UnableToCreatePullPointFaultTypeImpl)apiTypeObj).getJaxbTypeObj();
		} else {
			jaxbTypeObj = (EJaxbUnableToCreatePullPointFaultType) 
			BaseFaultTypeImpl.toJaxbModel(apiTypeObj,
					WsnbJAXBContext.WSNB_JAXB_FACTORY.createEJaxbUnableToCreatePullPointFaultType());
		}
		return jaxbTypeObj;
	}
}
