package com.ebmwebsourcing.wsstar.basenotification.datatypes.impl.impl;

import java.util.Date;
import java.util.logging.Logger;

import com.ebmwebsourcing.wsstar.basefaults.datatypes.impl.impl.BaseFaultTypeImpl;
import com.ebmwebsourcing.wsstar.basefaults.datatypes.impl.utils.WsrfbfUtils;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.UnableToGetMessagesFaultType;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.impl.WsnbJAXBContext;

import easybox.org.oasis_open.docs.wsn.b_2.EJaxbUnableToGetMessagesFaultType;

public class UnableToGetMessagesFaultTypeImpl extends BaseFaultTypeImpl
		implements UnableToGetMessagesFaultType {
	/**
	 * Default constructor
	 * 
	 * Note : According to the xml schema the "timestamp" field is mandatory
	 * 
	 * @param timestamp the timestamp of the {@link UnableToGetMessagesFaultType) object that must
	 * 		  be {@link Date} representation of an Date xml type.
	 */
	protected UnableToGetMessagesFaultTypeImpl(Date timestamp){
		super(Logger.getLogger(UnableToGetMessagesFaultTypeImpl.class.getSimpleName()));
		
		EJaxbUnableToGetMessagesFaultType jaxbTypeObj = 
			new EJaxbUnableToGetMessagesFaultType();
		
		jaxbTypeObj.setTimestamp(WsrfbfUtils.toXMLGregorianCalendar(timestamp, this.getLogger()));
		
		this.setJaxbTypeObj(jaxbTypeObj);
	}
	
	protected UnableToGetMessagesFaultTypeImpl(EJaxbUnableToGetMessagesFaultType jaxbTypeObj){
		super(jaxbTypeObj,Logger.getLogger(UnableToGetMessagesFaultTypeImpl.class.getSimpleName()));
	}
	
	/**
	 * A way to create a  {@link EJaxbUnableToGetMessagesFaultType}
	 *  "Jaxb model type" object from a {@link UnableToGetMessagesFaultType} "api type" one  
	 *    
	 * @param apiTypeObj
	 */
	public static EJaxbUnableToGetMessagesFaultType toJaxbModel(UnableToGetMessagesFaultType apiTypeObj){

		EJaxbUnableToGetMessagesFaultType jaxbTypeObj = null;

		if (apiTypeObj instanceof UnableToGetMessagesFaultTypeImpl) {
			jaxbTypeObj = (EJaxbUnableToGetMessagesFaultType)
			((UnableToGetMessagesFaultTypeImpl)apiTypeObj).getJaxbTypeObj();
		} else {
			jaxbTypeObj = (EJaxbUnableToGetMessagesFaultType) 
			BaseFaultTypeImpl.toJaxbModel(apiTypeObj,
					WsnbJAXBContext.WSNB_JAXB_FACTORY.createEJaxbUnableToGetMessagesFaultType());
		}
		return jaxbTypeObj;
	}
}
